/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.graph.LinearDag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearModificationDag
extends LinearDag {
    private final LinearDag myTail;
    private final long[] myNodes;
    private final TLongIntHashMap myIndex;
    private long myLastNode;
    private int myLastNodeIndex;

    LinearModificationDag(@NotNull LinearDag tail, @NotNull List<Long> nodes, float loadFactor) {
        if (tail == null) {
            LinearModificationDag.$$$reportNull$$$0(0);
        }
        if (nodes == null) {
            LinearModificationDag.$$$reportNull$$$0(1);
        }
        this.myLastNodeIndex = -1;
        this.myTail = tail;
        this.myNodes = new long[nodes.size()];
        this.myIndex = new TLongIntHashMap(nodes.size(), loadFactor);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            this.addEdge(nodes.get(i));
        }
    }

    private void addEdge(long node) {
        ++this.myLastNodeIndex;
        this.myNodes[this.myLastNodeIndex] = node;
        this.myIndex.put(node, this.myLastNodeIndex);
        this.myLastNode = node;
    }

    @Override
    @NotNull
    public List<Long> toposort() {
        if (this.myLastNodeIndex == -1) {
            List<Long> list = this.myTail.toposort();
            if (list == null) {
                LinearModificationDag.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Long> tips = this.getNodesWithoutChildren();
        if (tips.isEmpty() && !this.isEmpty()) {
            tips.addAll(this.getAllNodes());
        }
        List<Long> result = this.toposortFrom(tips);
        this.checkCycles(result);
        List<Long> list = result;
        if (list == null) {
            LinearModificationDag.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Long> getParents(@NotNull Long node) {
        if (node == null) {
            LinearModificationDag.$$$reportNull$$$0(4);
        }
        if (this.selfContainsNode(node)) {
            int index = this.myIndex.get(node.longValue());
            int parentIndex = index - 1;
            if (parentIndex < 0) {
                List<Long> list = this.myTail.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.myTail.getLastNode());
                if (list == null) {
                    LinearModificationDag.$$$reportNull$$$0(5);
                }
                return list;
            }
            List<Long> list = Collections.singletonList(this.myNodes[parentIndex]);
            if (list == null) {
                LinearModificationDag.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<Long> list = this.myTail.getParents(node);
        if (list == null) {
            LinearModificationDag.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    protected List<Long> getSelfParents(@NotNull Long node) {
        if (node == null) {
            LinearModificationDag.$$$reportNull$$$0(8);
        }
        if (this.selfContainsNode(node)) {
            int index = this.myIndex.get(node.longValue());
            int parentIndex = index - 1;
            if (parentIndex < 0) {
                return this.myTail.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.myTail.getLastNode());
            }
            return Collections.singletonList(this.myNodes[parentIndex]);
        }
        return null;
    }

    @Override
    protected void fillSelfChildren(@NotNull Long node, @NotNull List<Long> accumulator) {
        if (node == null) {
            LinearModificationDag.$$$reportNull$$$0(9);
        }
        if (accumulator == null) {
            LinearModificationDag.$$$reportNull$$$0(10);
        }
        if (this.selfContainsNode(node)) {
            int index = this.myIndex.get(node.longValue());
            int childIndex = index + 1;
            if (childIndex <= this.myLastNodeIndex) {
                accumulator.add(this.myNodes[childIndex]);
            }
        } else if (node.equals(this.myTail.getLastNode())) {
            accumulator.add(this.myNodes[0]);
        }
    }

    @Override
    public boolean containsNode(@NotNull Long node) {
        if (node == null) {
            LinearModificationDag.$$$reportNull$$$0(11);
        }
        if (this.myIndex.containsKey(node.longValue())) {
            return true;
        }
        return this.myTail.containsNode(node);
    }

    @Override
    @NotNull
    public List<Long> getNodesWithoutChildren() {
        if (this.isEmpty()) {
            List<Long> list = Collections.emptyList();
            if (list == null) {
                LinearModificationDag.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<Long> list = Collections.singletonList(this.myLastNode);
        if (list == null) {
            LinearModificationDag.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Long> getNodesWithoutParents() {
        if (this.myTail.isEmpty() && this.selfSize() > 0) {
            List<Long> list = Collections.singletonList(this.myNodes[0]);
            if (list == null) {
                LinearModificationDag.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<Long> list = this.myTail.getNodesWithoutParents();
        if (list == null) {
            LinearModificationDag.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    public int size() {
        return this.myTail.size() + this.selfSize();
    }

    @Override
    protected int selfSize() {
        return this.myNodes.length;
    }

    @Override
    @NotNull
    protected Collection<Pair<Long, Long>> getInitialEdges() {
        ArrayList<Pair<Long, Long>> initialEdges = new ArrayList<Pair<Long, Long>>();
        for (int i = 0; i < this.myNodes.length; ++i) {
            if (i == 0) {
                initialEdges.add((Pair<Long, Long>)Pair.create((Object)this.myNodes[i], (Object)null));
                continue;
            }
            initialEdges.add((Pair<Long, Long>)Pair.create((Object)this.myNodes[i], (Object)this.myNodes[i - 1]));
        }
        ArrayList<Pair<Long, Long>> arrayList = initialEdges;
        if (arrayList == null) {
            LinearModificationDag.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    protected LinearDag getTail() {
        LinearDag linearDag = this.myTail;
        if (linearDag == null) {
            LinearModificationDag.$$$reportNull$$$0(17);
        }
        return linearDag;
    }

    @Override
    @NotNull
    public Set<Long> getAllNodes() {
        HashSet<Long> allNodes = new HashSet<Long>(this.size());
        for (long node : this.myNodes) {
            allNodes.add(node);
        }
        allNodes.addAll(this.myTail.getAllNodes());
        HashSet<Long> hashSet = allNodes;
        if (hashSet == null) {
            LinearModificationDag.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @Override
    @NotNull
    List<Long> getInitialNodes() {
        ArrayList<Long> initialNodes = new ArrayList<Long>(this.myNodes.length);
        for (int i = this.myNodes.length - 1; i >= 0; --i) {
            initialNodes.add(this.myNodes[i]);
        }
        ArrayList<Long> arrayList = initialNodes;
        if (arrayList == null) {
            LinearModificationDag.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    @Nullable
    Long getLastNode() {
        return this.myLastNode;
    }

    private boolean selfContainsNode(@NotNull Long node) {
        if (node == null) {
            LinearModificationDag.$$$reportNull$$$0(20);
        }
        return this.myIndex.containsKey(node.longValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/LinearModificationDag";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/LinearModificationDag";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toposort";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutChildren";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutParents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialEdges";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelfParents";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selfContainsNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

