/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.graph.BaseModificationDAG;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.ModificationDagConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModificationDAG
extends BaseModificationDAG {
    private final DAG<Long> myTail;
    private final TLongObjectHashMap<Object> myParents;
    private final TLongObjectHashMap<Object> myChildren;
    private final long[] mySelfNodesWithNullParents;
    private final long[] mySelfNodesWithoutChildren;
    private long myMin;
    private long myMinParentWithChildren;

    ModificationDAG(@NotNull DAG<Long> tail, @NotNull Collection<? extends Pair<Long, Long>> edges, @NotNull ModificationDagConfig config) {
        if (tail == null) {
            ModificationDAG.$$$reportNull$$$0(0);
        }
        if (edges == null) {
            ModificationDAG.$$$reportNull$$$0(1);
        }
        if (config == null) {
            ModificationDAG.$$$reportNull$$$0(2);
        }
        this.myMin = Long.MAX_VALUE;
        this.myMinParentWithChildren = -1L;
        this.myTail = tail;
        this.myParents = new TLongObjectHashMap(edges.size(), config.getLoadFactor());
        this.myChildren = new TLongObjectHashMap(edges.size(), config.getLoadFactor());
        TLongArrayList nodesWithNullParents = new TLongArrayList();
        for (Pair<Long, Long> pair : edges) {
            this.addEdge(pair);
            if (pair.second != null) continue;
            nodesWithNullParents.add(((Long)pair.first).longValue());
        }
        this.mySelfNodesWithoutChildren = this.preCalculateNodesWithoutChildren(config.getMaxNodesWithoutChildren(edges.size()));
        this.mySelfNodesWithNullParents = nodesWithNullParents.toArray();
    }

    @Nullable
    private long[] preCalculateNodesWithoutChildren(final int maxNodesThreshold) {
        if (maxNodesThreshold == 0) {
            return null;
        }
        final ArrayList acc = new ArrayList();
        this.calculateSelfNodesWithoutChildren(new ItemProcessor<Long>(){

            public boolean processItem(Long item) {
                acc.add(item);
                return acc.size() <= maxNodesThreshold;
            }
        });
        if (acc.size() > maxNodesThreshold) {
            return null;
        }
        long[] result = new long[acc.size()];
        for (int i = 0; i < acc.size(); ++i) {
            result[i] = (Long)acc.get(i);
        }
        return result;
    }

    private void addEdge(@NotNull Pair<Long, Long> edge) {
        if (edge == null) {
            ModificationDAG.$$$reportNull$$$0(3);
        }
        this.addVertex((Long)edge.first);
        if (edge.second != null) {
            this.addVertex((Long)edge.second);
            this.addEdge((Long)edge.first, (Long)edge.second);
        }
    }

    private void addVertex(@NotNull Long value) {
        if (value == null) {
            ModificationDAG.$$$reportNull$$$0(4);
        }
        if (this.myParents.get(value.longValue()) == null && !this.myTail.containsNode(value)) {
            this.storeParents(value, new long[0]);
            this.myChildren.put(value.longValue(), null);
        }
    }

    private void addEdge(long child, long parent) {
        long[] parents = (long[])this.myParents.get(child);
        if (parents == null) {
            parents = new long[]{parent};
            this.storeParents(child, parents);
            return;
        }
        for (long p : parents) {
            if (p != parent) continue;
            return;
        }
        long[] newParents = new long[parents.length + 1];
        System.arraycopy(parents, 0, newParents, 0, parents.length);
        newParents[parents.length] = parent;
        this.storeParents(child, newParents);
        this.addChild(parent, child);
    }

    /*
     * WARNING - void declaration
     */
    private void storeParents(long node, @NotNull long[] lArray) {
        void parents;
        if (lArray == null) {
            ModificationDAG.$$$reportNull$$$0(5);
        }
        this.myParents.put(node, (Object)parents);
        this.myMin = Math.min(this.myMin, node);
    }

    private void addChild(@NotNull Long parent, @NotNull Long child) {
        if (parent == null) {
            ModificationDAG.$$$reportNull$$$0(6);
        }
        if (child == null) {
            ModificationDAG.$$$reportNull$$$0(7);
        }
        this.myMinParentWithChildren = this.myMinParentWithChildren < 0L ? parent : Math.min(this.myMinParentWithChildren, parent);
        long[] children = (long[])this.myChildren.get(parent.longValue());
        if (children == null) {
            children = new long[]{child};
            this.myChildren.put(parent.longValue(), (Object)children);
            return;
        }
        for (long c : children) {
            if (c != child) continue;
            return;
        }
        long[] newChildren = new long[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = child;
        this.myChildren.put(parent.longValue(), (Object)newChildren);
    }

    @Override
    @NotNull
    public List<Long> toposort() {
        if (this.myParents.isEmpty()) {
            List<Long> list = this.myTail.toposort();
            if (list == null) {
                ModificationDAG.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<Long> tips = this.getNodesWithoutChildren();
        if (tips.isEmpty() && !this.isEmpty()) {
            tips.addAll(this.getAllNodes());
        }
        List<Long> result = this.toposortFrom(tips);
        this.checkCycles(result);
        List<Long> list = result;
        if (list == null) {
            ModificationDAG.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Long> getParents(@NotNull Long node) {
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(10);
        }
        DAG dag = this;
        while (!((DAG)dag).isEmpty()) {
            List<Long> parents = ((DAG)dag).getSelfParents(node);
            if (parents != null) {
                List<Long> list = parents;
                if (list == null) {
                    ModificationDAG.$$$reportNull$$$0(11);
                }
                return list;
            }
            dag = ((DAG)dag).getTail();
        }
        List<Long> list = Collections.emptyList();
        if (list == null) {
            ModificationDAG.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        if (!this.myParents.isEmpty()) {
            return false;
        }
        return this.myTail.isEmpty();
    }

    @Override
    @Nullable
    protected List<Long> getSelfParents(@NotNull Long node) {
        long[] parents;
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(13);
        }
        if ((parents = this.doGetParents(node)) == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>(parents.length);
        for (long parent : parents) {
            list.add(parent);
        }
        return list;
    }

    private long[] doGetParents(@NotNull Long node) {
        long nodeId;
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(14);
        }
        if ((nodeId = node.longValue()) < this.myMin) {
            return null;
        }
        return (long[])this.myParents.get(nodeId);
    }

    @Override
    public boolean hasParents(@NotNull Long node) {
        long[] parents;
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(15);
        }
        if ((parents = this.doGetParents(node)) != null && parents.length > 0) {
            return true;
        }
        return this.myTail.hasParents(node);
    }

    @Override
    protected void fillSelfChildren(@NotNull Long node, @NotNull List<Long> accumulator) {
        long[] children;
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(16);
        }
        if (accumulator == null) {
            ModificationDAG.$$$reportNull$$$0(17);
        }
        if ((children = (long[])this.myChildren.get(node.longValue())) == null) {
            return;
        }
        for (long c : children) {
            accumulator.add(c);
        }
    }

    @Override
    public boolean containsNode(@NotNull Long node) {
        long[] parents;
        if (node == null) {
            ModificationDAG.$$$reportNull$$$0(18);
        }
        if ((parents = this.doGetParents(node)) != null) {
            return true;
        }
        return this.myTail.containsNode(node);
    }

    @Override
    protected void processNodesWithoutChildren(final @NotNull ItemProcessor<Long> nodesProcessor) {
        if (nodesProcessor == null) {
            ModificationDAG.$$$reportNull$$$0(19);
        }
        final boolean[] stopped = new boolean[1];
        ItemProcessor<Long> tailProcessor = new ItemProcessor<Long>(){

            public boolean processItem(Long node) {
                if (node >= ModificationDAG.this.myMinParentWithChildren && ModificationDAG.this.myChildren.get((long)node.intValue()) != null) {
                    return true;
                }
                stopped[0] = !nodesProcessor.processItem((Object)node);
                return !stopped[0];
            }
        };
        this.myTail.processNodesWithoutChildren(tailProcessor);
        if (stopped[0]) {
            return;
        }
        this.addSelfNodesWithoutChildren(nodesProcessor);
    }

    private void addSelfNodesWithoutChildren(@NotNull ItemProcessor<Long> accumulator) {
        if (accumulator == null) {
            ModificationDAG.$$$reportNull$$$0(20);
        }
        if (this.mySelfNodesWithoutChildren != null) {
            for (long n : this.mySelfNodesWithoutChildren) {
                if (accumulator.processItem((Object)n)) continue;
                return;
            }
        } else {
            this.calculateSelfNodesWithoutChildren(accumulator);
        }
    }

    private void calculateSelfNodesWithoutChildren(@NotNull ItemProcessor<Long> accumulator) {
        if (accumulator == null) {
            ModificationDAG.$$$reportNull$$$0(21);
        }
        TLongObjectIterator iter = this.myChildren.iterator();
        int i = this.myChildren.size();
        while (i-- > 0) {
            iter.advance();
            Long node = iter.key();
            long[] children = (long[])iter.value();
            if (children != null && children.length != 0 || accumulator.processItem((Object)node)) continue;
            return;
        }
    }

    @Override
    @NotNull
    public List<Long> getNodesWithoutParents() {
        ArrayList<Long> result = new ArrayList<Long>();
        this.fillSelfNodesWithoutParents(result);
        result.addAll(this.myTail.getNodesWithoutParents());
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            ModificationDAG.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private void fillSelfNodesWithoutParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAG.$$$reportNull$$$0(23);
        }
        TLongObjectIterator iter = this.myParents.iterator();
        int i = this.myParents.size();
        while (i-- > 0) {
            iter.advance();
            long[] parents = (long[])iter.value();
            if (parents != null && parents.length != 0) continue;
            result.add(iter.key());
        }
    }

    @Override
    void fillNodesWithMissingParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAG.$$$reportNull$$$0(24);
        }
        this.fillSelfNodesWithoutParents(result);
        this.fillSelfNodesWithNullParents(result);
        this.myTail.fillNodesWithMissingParents(result);
    }

    private void fillSelfNodesWithNullParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAG.$$$reportNull$$$0(25);
        }
        for (long node : this.mySelfNodesWithNullParents) {
            result.add(node);
        }
    }

    @Override
    public int size() {
        return this.selfSize() + this.myTail.size();
    }

    @Override
    protected int selfSize() {
        return this.myParents.size();
    }

    @Override
    @NotNull
    protected Collection<Pair<Long, Long>> getInitialEdges() {
        ArrayList<Pair<Long, Long>> initialEdges = new ArrayList<Pair<Long, Long>>();
        TLongObjectIterator iter = this.myParents.iterator();
        TLongHashSet nodesWithNullParents = new TLongHashSet(this.mySelfNodesWithNullParents);
        int i = this.myParents.size();
        while (i-- > 0) {
            iter.advance();
            Long child = iter.key();
            long[] parents = (long[])iter.value();
            if (parents != null && parents.length > 0) {
                for (long parent : parents) {
                    initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)parent));
                }
                if (!nodesWithNullParents.contains(child.longValue())) continue;
                initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)null));
                continue;
            }
            initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)null));
        }
        ArrayList<Pair<Long, Long>> arrayList = initialEdges;
        if (arrayList == null) {
            ModificationDAG.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected DAG<Long> getTail() {
        DAG<Long> dAG = this.myTail;
        if (dAG == null) {
            ModificationDAG.$$$reportNull$$$0(27);
        }
        return dAG;
    }

    @Override
    @NotNull
    public Set<Long> getAllNodes() {
        HashSet<Long> allNodes = new HashSet<Long>(this.size());
        long[] lArray = this.myParents.keys();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long node = lArray[i];
            allNodes.add(node);
        }
        allNodes.addAll(this.myTail.getAllNodes());
        HashSet<Long> hashSet = allNodes;
        if (hashSet == null) {
            ModificationDAG.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ModificationDAG";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesProcessor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ModificationDAG";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toposort";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutParents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialEdges";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVertex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "storeParents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelfParents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetParents";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasParents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfChildren";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processNodesWithoutChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addSelfNodesWithoutChildren";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateSelfNodesWithoutChildren";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfNodesWithoutParents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fillNodesWithMissingParents";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfNodesWithNullParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

