/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.graph.BaseModificationDAG;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.ModificationDagConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModificationDAGInt
extends BaseModificationDAG {
    private final DAG<Long> myTail;
    private final TIntObjectHashMap<Object> myParents;
    private final TIntObjectHashMap<Object> myChildren;
    private final int[] mySelfNodesWithNullParents;
    private final int[] mySelfNodesWithoutChildren;
    private long myMin;
    private long myMinParentWithChildren;

    ModificationDAGInt(@NotNull DAG<Long> tail, @NotNull Collection<? extends Pair<Long, Long>> edges, @NotNull ModificationDagConfig config) {
        if (tail == null) {
            ModificationDAGInt.$$$reportNull$$$0(0);
        }
        if (edges == null) {
            ModificationDAGInt.$$$reportNull$$$0(1);
        }
        if (config == null) {
            ModificationDAGInt.$$$reportNull$$$0(2);
        }
        this.myMin = Long.MAX_VALUE;
        this.myMinParentWithChildren = -1L;
        this.myTail = tail;
        this.myParents = new TIntObjectHashMap(edges.size(), config.getLoadFactor());
        this.myChildren = new TIntObjectHashMap(edges.size(), config.getLoadFactor());
        TIntArrayList nodesWithNullParents = new TIntArrayList();
        for (Pair<Long, Long> pair : edges) {
            this.addEdge(pair);
            if (pair.second != null) continue;
            nodesWithNullParents.add(((Long)pair.first).intValue());
        }
        this.mySelfNodesWithoutChildren = this.preCalculateNodesWithoutChildren(config.getMaxNodesWithoutChildren(edges.size()));
        this.mySelfNodesWithNullParents = nodesWithNullParents.toArray();
    }

    @Nullable
    private int[] preCalculateNodesWithoutChildren(final int maxNodesThreshold) {
        if (maxNodesThreshold == 0) {
            return null;
        }
        final ArrayList acc = new ArrayList();
        this.calculateSelfNodesWithoutChildren(new ItemProcessor<Long>(){

            public boolean processItem(Long item) {
                acc.add(item);
                return acc.size() <= maxNodesThreshold;
            }
        });
        if (acc.size() > maxNodesThreshold) {
            return null;
        }
        int[] result = new int[acc.size()];
        for (int i = 0; i < acc.size(); ++i) {
            result[i] = ((Long)acc.get(i)).intValue();
        }
        return result;
    }

    private void addEdge(@NotNull Pair<Long, Long> edge) {
        if (edge == null) {
            ModificationDAGInt.$$$reportNull$$$0(3);
        }
        this.addVertex((Long)edge.first);
        if (edge.second != null) {
            this.addVertex((Long)edge.second);
            this.addEdge(((Long)edge.first).intValue(), ((Long)edge.second).intValue());
        }
    }

    private void addVertex(@NotNull Long value) {
        if (value == null) {
            ModificationDAGInt.$$$reportNull$$$0(4);
        }
        if (this.myParents.get(value.intValue()) == null && !this.myTail.containsNode(value)) {
            this.storeParents(value.intValue(), new int[0]);
            this.myChildren.put(value.intValue(), null);
        }
    }

    private void addEdge(int child, int parent) {
        int[] parents = (int[])this.myParents.get(child);
        if (parents == null) {
            parents = new int[]{parent};
            this.storeParents(child, parents);
            return;
        }
        int[] nArray = parents;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long p = nArray[i];
            if (p != (long)parent) continue;
            return;
        }
        int[] newParents = new int[parents.length + 1];
        System.arraycopy(parents, 0, newParents, 0, parents.length);
        newParents[parents.length] = parent;
        this.storeParents(child, newParents);
        this.addChild(parent, child);
    }

    private void storeParents(int node, @NotNull int[] parents) {
        if (parents == null) {
            ModificationDAGInt.$$$reportNull$$$0(5);
        }
        this.myParents.put(node, (Object)parents);
        this.myMin = Math.min(this.myMin, (long)node);
    }

    private void addChild(int parent, int child) {
        this.myMinParentWithChildren = this.myMinParentWithChildren < 0L ? (long)parent : Math.min(this.myMinParentWithChildren, (long)parent);
        int[] children = (int[])this.myChildren.get(parent);
        if (children == null) {
            children = new int[]{child};
            this.myChildren.put(parent, (Object)children);
            return;
        }
        int[] nArray = children;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long c = nArray[i];
            if (c != (long)child) continue;
            return;
        }
        int[] newChildren = new int[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = child;
        this.myChildren.put(parent, (Object)newChildren);
    }

    @Override
    @NotNull
    public List<Long> toposort() {
        if (this.myParents.isEmpty()) {
            List<Long> list = this.myTail.toposort();
            if (list == null) {
                ModificationDAGInt.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<Long> tips = this.getNodesWithoutChildren();
        if (tips.isEmpty() && !this.isEmpty()) {
            tips.addAll(this.getAllNodes());
        }
        List<Long> result = this.toposortFrom(tips);
        this.checkCycles(result);
        List<Long> list = result;
        if (list == null) {
            ModificationDAGInt.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Long> getParents(@NotNull Long node) {
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(8);
        }
        DAG dag = this;
        while (!((DAG)dag).isEmpty()) {
            List<Long> parents = ((DAG)dag).getSelfParents(node);
            if (parents != null) {
                List<Long> list = parents;
                if (list == null) {
                    ModificationDAGInt.$$$reportNull$$$0(9);
                }
                return list;
            }
            dag = ((DAG)dag).getTail();
        }
        List<Long> list = Collections.emptyList();
        if (list == null) {
            ModificationDAGInt.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        if (!this.myParents.isEmpty()) {
            return false;
        }
        return this.myTail.isEmpty();
    }

    @Override
    @Nullable
    protected List<Long> getSelfParents(@NotNull Long node) {
        int[] parents;
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(11);
        }
        if ((parents = this.doGetParents(node)) == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>(parents.length);
        int[] nArray = parents;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long parent = nArray[i];
            list.add(parent);
        }
        return list;
    }

    private int[] doGetParents(@NotNull Long node) {
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(12);
        }
        long nodeId = node;
        if (this.isOutOfRange(node)) {
            return null;
        }
        if (nodeId < this.myMin) {
            return null;
        }
        return (int[])this.myParents.get((int)nodeId);
    }

    @Override
    public boolean hasParents(@NotNull Long node) {
        int[] parents;
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(13);
        }
        if ((parents = this.doGetParents(node)) != null && parents.length > 0) {
            return true;
        }
        return this.myTail.hasParents(node);
    }

    @Override
    protected void fillSelfChildren(@NotNull Long node, @NotNull List<Long> accumulator) {
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(14);
        }
        if (accumulator == null) {
            ModificationDAGInt.$$$reportNull$$$0(15);
        }
        if (this.isOutOfRange(node)) {
            return;
        }
        int[] children = (int[])this.myChildren.get(node.intValue());
        if (children == null) {
            return;
        }
        int[] nArray = children;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long c = nArray[i];
            accumulator.add(c);
        }
    }

    @Override
    public boolean containsNode(@NotNull Long node) {
        int[] parents;
        if (node == null) {
            ModificationDAGInt.$$$reportNull$$$0(16);
        }
        if ((parents = this.doGetParents(node)) != null) {
            return true;
        }
        return this.myTail.containsNode(node);
    }

    @Override
    protected void processNodesWithoutChildren(final @NotNull ItemProcessor<Long> nodesProcessor) {
        if (nodesProcessor == null) {
            ModificationDAGInt.$$$reportNull$$$0(17);
        }
        final boolean[] stopped = new boolean[1];
        ItemProcessor<Long> tailProcessor = new ItemProcessor<Long>(){

            public boolean processItem(Long node) {
                if (!ModificationDAGInt.this.isOutOfRange(node) && node >= ModificationDAGInt.this.myMinParentWithChildren && ModificationDAGInt.this.myChildren.get(node.intValue()) != null) {
                    return true;
                }
                stopped[0] = !nodesProcessor.processItem((Object)node);
                return !stopped[0];
            }
        };
        this.myTail.processNodesWithoutChildren(tailProcessor);
        if (stopped[0]) {
            return;
        }
        this.addSelfNodesWithoutChildren(nodesProcessor);
    }

    private void addSelfNodesWithoutChildren(@NotNull ItemProcessor<Long> accumulator) {
        if (accumulator == null) {
            ModificationDAGInt.$$$reportNull$$$0(18);
        }
        if (this.mySelfNodesWithoutChildren != null) {
            int[] nArray = this.mySelfNodesWithoutChildren;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long n2 = nArray[i];
                if (accumulator.processItem((Object)n2)) continue;
                return;
            }
        } else {
            this.calculateSelfNodesWithoutChildren(accumulator);
        }
    }

    private void calculateSelfNodesWithoutChildren(@NotNull ItemProcessor<Long> accumulator) {
        if (accumulator == null) {
            ModificationDAGInt.$$$reportNull$$$0(19);
        }
        TIntObjectIterator iter = this.myChildren.iterator();
        int i = this.myChildren.size();
        while (i-- > 0) {
            iter.advance();
            long node = iter.key();
            int[] children = (int[])iter.value();
            if (children != null && children.length != 0 || accumulator.processItem((Object)node)) continue;
            return;
        }
    }

    @Override
    @NotNull
    public List<Long> getNodesWithoutParents() {
        ArrayList<Long> result = new ArrayList<Long>();
        this.fillSelfNodesWithoutParents(result);
        result.addAll(this.myTail.getNodesWithoutParents());
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            ModificationDAGInt.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private void fillSelfNodesWithoutParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAGInt.$$$reportNull$$$0(21);
        }
        TIntObjectIterator iter = this.myParents.iterator();
        int i = this.myParents.size();
        while (i-- > 0) {
            iter.advance();
            int[] parents = (int[])iter.value();
            if (parents != null && parents.length != 0) continue;
            result.add(Long.valueOf(iter.key()));
        }
    }

    @Override
    void fillNodesWithMissingParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAGInt.$$$reportNull$$$0(22);
        }
        this.fillSelfNodesWithoutParents(result);
        this.fillSelfNodesWithNullParents(result);
        this.myTail.fillNodesWithMissingParents(result);
    }

    private void fillSelfNodesWithNullParents(@NotNull Collection<Long> result) {
        if (result == null) {
            ModificationDAGInt.$$$reportNull$$$0(23);
        }
        for (int node : this.mySelfNodesWithNullParents) {
            result.add(Long.valueOf(node));
        }
    }

    @Override
    public int size() {
        return this.selfSize() + this.myTail.size();
    }

    @Override
    protected int selfSize() {
        return this.myParents.size();
    }

    @Override
    @NotNull
    protected Collection<Pair<Long, Long>> getInitialEdges() {
        ArrayList<Pair<Long, Long>> initialEdges = new ArrayList<Pair<Long, Long>>();
        TIntObjectIterator iter = this.myParents.iterator();
        TIntHashSet nodesWithNullParents = new TIntHashSet(this.mySelfNodesWithNullParents);
        int i = this.myParents.size();
        while (i-- > 0) {
            iter.advance();
            long child = iter.key();
            int[] parents = (int[])iter.value();
            if (parents != null && parents.length > 0) {
                int[] nArray = parents;
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long parent = nArray[j];
                    initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)parent));
                }
                if (!nodesWithNullParents.contains((int)child)) continue;
                initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)null));
                continue;
            }
            initialEdges.add((Pair<Long, Long>)Pair.create((Object)child, (Object)null));
        }
        ArrayList<Pair<Long, Long>> arrayList = initialEdges;
        if (arrayList == null) {
            ModificationDAGInt.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected DAG<Long> getTail() {
        DAG<Long> dAG = this.myTail;
        if (dAG == null) {
            ModificationDAGInt.$$$reportNull$$$0(25);
        }
        return dAG;
    }

    @Override
    @NotNull
    public Set<Long> getAllNodes() {
        HashSet<Long> allNodes = new HashSet<Long>(this.size());
        int[] nArray = this.myParents.keys();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long node = nArray[i];
            allNodes.add(node);
        }
        allNodes.addAll(this.myTail.getAllNodes());
        HashSet<Long> hashSet = allNodes;
        if (hashSet == null) {
            ModificationDAGInt.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    private boolean isOutOfRange(long node) {
        return node < Integer.MIN_VALUE || node > Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ModificationDAGInt";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesProcessor";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ModificationDAGInt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toposort";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutParents";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialEdges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVertex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "storeParents";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelfParents";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doGetParents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasParents";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processNodesWithoutChildren";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSelfNodesWithoutChildren";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateSelfNodesWithoutChildren";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfNodesWithoutParents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillNodesWithMissingParents";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfNodesWithNullParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

