/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGIterator;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import jetbrains.buildServer.util.graph.GreaterOrEqualsThan;
import jetbrains.buildServer.util.graph.VisitedNodesCollector;
import org.jetbrains.annotations.NotNull;

class ModificationDAGIterator
extends DAGIterator<Long> {
    private final DAG<Long> myGraph;
    private final List<Long> myStartNodes;
    private final List<Long> myUninterestingNodes;
    private boolean myInitialized;
    private Iterator<Long> myDelegate;

    ModificationDAGIterator(@NotNull DAG<Long> graph, @NotNull Long startNode) {
        if (graph == null) {
            ModificationDAGIterator.$$$reportNull$$$0(0);
        }
        if (startNode == null) {
            ModificationDAGIterator.$$$reportNull$$$0(1);
        }
        this(graph, Arrays.asList(startNode));
    }

    ModificationDAGIterator(@NotNull DAG<Long> graph, @NotNull Collection<Long> startNodes) {
        if (graph == null) {
            ModificationDAGIterator.$$$reportNull$$$0(2);
        }
        if (startNodes == null) {
            ModificationDAGIterator.$$$reportNull$$$0(3);
        }
        this.myStartNodes = new ArrayList<Long>();
        this.myUninterestingNodes = new ArrayList<Long>();
        this.myInitialized = false;
        this.myGraph = graph;
        this.markStart(startNodes);
    }

    @Override
    public void markStart(@NotNull Long node) {
        if (node == null) {
            ModificationDAGIterator.$$$reportNull$$$0(4);
        }
        this.markStart((Collection<Long>)Collections.singletonList(node));
    }

    @Override
    public void markStart(@NotNull Collection<Long> nodes) {
        if (nodes == null) {
            ModificationDAGIterator.$$$reportNull$$$0(5);
        }
        this.myStartNodes.clear();
        this.myStartNodes.addAll(nodes);
    }

    @Override
    public void markUninteresting(@NotNull Long node) {
        if (node == null) {
            ModificationDAGIterator.$$$reportNull$$$0(6);
        }
        this.markUninteresting((Collection<Long>)Collections.singletonList(node));
    }

    @Override
    public void markUninteresting(@NotNull Collection<Long> nodes) {
        if (nodes == null) {
            ModificationDAGIterator.$$$reportNull$$$0(7);
        }
        this.myUninterestingNodes.clear();
        this.myUninterestingNodes.addAll(nodes);
    }

    @Override
    public boolean hasNext() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myDelegate.hasNext();
    }

    @Override
    public Long next() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myDelegate.next();
    }

    private void initialize() {
        List<Long> nodes = this.getReachableNodes();
        this.myDelegate = nodes.iterator();
        this.myInitialized = true;
    }

    @NotNull
    private List<Long> getReachableNodes() {
        final TLongHashSet uninteresting = new TLongHashSet();
        VisitedNodesCollector collector = new VisitedNodesCollector(uninteresting);
        final ArrayList<DepthFirstSearch<Long>> uninterestingNodesSearches = new ArrayList<DepthFirstSearch<Long>>();
        for (Long u : this.myUninterestingNodes) {
            uninterestingNodesSearches.add(this.myGraph.getDepthFirstSearch(u, collector));
        }
        final TLongHashSet visitedNodes = new TLongHashSet();
        final ArrayList<Long> reachableNodes = new ArrayList<Long>();
        for (Long start : this.myStartNodes) {
            this.myGraph.depthFirstSearch(start, (DFSVisitor<Long>)new DFSVisitorAdapter<Long>(){

                @Override
                public boolean discover(@NotNull Long node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (DepthFirstSearch dfs : uninterestingNodesSearches) {
                        dfs.runWhile(new GreaterOrEqualsThan(node));
                    }
                    if (uninteresting.contains(node.longValue())) {
                        return false;
                    }
                    if (!visitedNodes.add(node.longValue())) {
                        return false;
                    }
                    reachableNodes.add(node);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/ModificationDAGIterator$1", "discover"));
                }
            });
        }
        ArrayList<Long> arrayList = reachableNodes;
        if (arrayList == null) {
            ModificationDAGIterator.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNodes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ModificationDAGIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ModificationDAGIterator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markStart";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markUninteresting";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

