/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.TLongArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.ReachabilityIndexExt;
import jetbrains.buildServer.util.graph.ReachabilityIndexExtImpl;
import jetbrains.buildServer.util.graph.ReachabilityIndexImpl;
import org.jetbrains.annotations.NotNull;

class ReachabilityIndexBuilder<T> {
    private final DAG<T> myDag;
    private final T[] myPostOrderNum2Node;
    private final TObjectIntHashMap<T> myPostOrderNum;
    private final TObjectIntHashMap<T> myMinReachablePostOrderNum;
    private final Map<T, TLongArrayList> myIntervals;
    private int myNextPostOrderNum;

    public ReachabilityIndexBuilder(@NotNull DAG<T> dag) {
        if (dag == null) {
            ReachabilityIndexBuilder.$$$reportNull$$$0(0);
        }
        this.myNextPostOrderNum = 0;
        this.myDag = dag;
        this.myPostOrderNum2Node = new Object[this.myDag.size()];
        this.myPostOrderNum = new TObjectIntHashMap(this.myDag.size());
        this.myMinReachablePostOrderNum = new TObjectIntHashMap();
        this.myIntervals = new HashMap<T, TLongArrayList>(this.myDag.size());
    }

    @NotNull
    ReachabilityIndexImpl<T> build() {
        long[][] intervals = this.computeIntervals();
        ReachabilityIndexImpl<T> reachabilityIndexImpl = new ReachabilityIndexImpl<T>(this.myPostOrderNum, this.myPostOrderNum2Node, intervals);
        if (reachabilityIndexImpl == null) {
            ReachabilityIndexBuilder.$$$reportNull$$$0(1);
        }
        return reachabilityIndexImpl;
    }

    @NotNull
    ReachabilityIndexExt<T> buildExt() {
        long[][] intervals = this.computeIntervals();
        ReachabilityIndexExtImpl<T> reachabilityIndexExtImpl = new ReachabilityIndexExtImpl<T>(this.myPostOrderNum, this.myPostOrderNum2Node, intervals);
        if (reachabilityIndexExtImpl == null) {
            ReachabilityIndexBuilder.$$$reportNull$$$0(2);
        }
        return reachabilityIndexExtImpl;
    }

    private long[][] computeIntervals() {
        for (T tip : this.myDag.getNodesWithoutChildren()) {
            this.myDag.depthFirstSearch(tip, new DFSVisitorAdapter<T>(){

                @Override
                public void finish(@NotNull T node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ReachabilityIndexBuilder.this.myPostOrderNum.containsKey(node)) {
                        return;
                    }
                    int poNum = ReachabilityIndexBuilder.this.myNextPostOrderNum++;
                    ((ReachabilityIndexBuilder)ReachabilityIndexBuilder.this).myPostOrderNum2Node[poNum] = node;
                    ReachabilityIndexBuilder.this.myPostOrderNum.put(node, poNum);
                    int min = ReachabilityIndexBuilder.this.findMinReachablePostOrderNum(node, poNum);
                    ReachabilityIndexBuilder.this.myMinReachablePostOrderNum.put(node, min);
                    TLongArrayList ints = new TLongArrayList(1);
                    ints.add(ReachabilityIndexImpl.asLong(min, poNum));
                    ReachabilityIndexBuilder.this.myIntervals.put(node, ints);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/ReachabilityIndexBuilder$1", "finish"));
                }
            });
        }
        long[][] intervals = new long[this.myNextPostOrderNum][];
        for (int poNum = 0; poNum < this.myNextPostOrderNum; ++poNum) {
            T node = this.myPostOrderNum2Node[poNum];
            TLongArrayList nodeIntervals = this.myIntervals.get(node);
            for (T parent : this.myDag.getParents(node)) {
                TLongArrayList parentInts = this.myIntervals.get(parent);
                for (int parentIntIdx = 0; parentIntIdx < parentInts.size(); ++parentIntIdx) {
                    long parentInt = parentInts.get(parentIntIdx);
                    boolean add = true;
                    for (int nodeIntIdx = 0; nodeIntIdx < nodeIntervals.size(); ++nodeIntIdx) {
                        long nodeInt = nodeIntervals.get(nodeIntIdx);
                        if (!ReachabilityIndexImpl.includes(nodeInt, parentInt)) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    nodeIntervals.add(parentInt);
                }
            }
            nodeIntervals.sort();
            intervals[poNum] = nodeIntervals.toNativeArray();
        }
        return intervals;
    }

    private int findMinReachablePostOrderNum(@NotNull T node, int poNum) {
        if (node == null) {
            ReachabilityIndexBuilder.$$$reportNull$$$0(3);
        }
        int min = poNum;
        for (T parent : this.myDag.getParents(node)) {
            if (!this.myMinReachablePostOrderNum.containsKey(parent)) continue;
            min = Math.min(this.myMinReachablePostOrderNum.remove(parent), min);
        }
        return min;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ReachabilityIndexBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ReachabilityIndexBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMinReachablePostOrderNum";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

