/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.TLongArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.util.graph.ReachabilityIndexExt;
import jetbrains.buildServer.util.graph.ReachabilityIndexImpl;
import org.jetbrains.annotations.NotNull;

public class ReachabilityIndexExtImpl<T>
extends ReachabilityIndexImpl<T>
implements ReachabilityIndexExt<T> {
    private final TObjectIntHashMap<T> myNode2postOrderNumber;
    private final ArrayList<T> myPostOrderNumber2Node;
    private final ArrayList<long[]> myIntervals;
    private final int myMinPoNum;
    private int myNextPoNum;

    public ReachabilityIndexExtImpl(@NotNull TObjectIntHashMap<T> node2PostOrderNumber, @NotNull T[] postOrderNumber2Node, @NotNull long[][] intervals) {
        if (node2PostOrderNumber == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(0);
        }
        if (postOrderNumber2Node == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(1);
        }
        if (intervals == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(2);
        }
        super(node2PostOrderNumber, postOrderNumber2Node, intervals);
        this.myNode2postOrderNumber = new TObjectIntHashMap();
        this.myPostOrderNumber2Node = new ArrayList();
        this.myIntervals = new ArrayList();
        this.myNextPoNum = this.myMinPoNum = postOrderNumber2Node.length;
    }

    @Override
    public void addEdges(@NotNull T child, @NotNull List<T> parents) {
        if (child == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(3);
        }
        if (parents == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(4);
        }
        int childNum = this.myNextPoNum++;
        this.myNode2postOrderNumber.put(child, childNum);
        this.myPostOrderNumber2Node.add(child);
        TLongArrayList childIntervals = new TLongArrayList();
        for (int parentNum : this.getPostOrderNumbers(parents)) {
            for (long parentInterval : this.getIntervals(parentNum)) {
                boolean add = true;
                for (int i = 0; i < childIntervals.size(); ++i) {
                    long childInterval = childIntervals.get(i);
                    if (!ReachabilityIndexExtImpl.includes(childInterval, parentInterval)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                childIntervals.add(parentInterval);
            }
        }
        if (!childIntervals.isEmpty()) {
            childIntervals.sort();
            int lastIntervalIdx = childIntervals.size() - 1;
            long lastParentInterval = childIntervals.get(lastIntervalIdx);
            int end = ReachabilityIndexImpl.intervalEnd(lastParentInterval);
            if (childNum == end + 1) {
                childIntervals.set(lastIntervalIdx, ReachabilityIndexImpl.asLong(ReachabilityIndexImpl.intervalStart(lastParentInterval), childNum));
            } else {
                childIntervals.add(ReachabilityIndexImpl.asLong(childNum, childNum));
            }
        } else {
            childIntervals.add(ReachabilityIndexImpl.asLong(childNum, childNum));
        }
        this.myIntervals.add(childIntervals.toNativeArray());
    }

    @Override
    public boolean containsNode(@NotNull T node) {
        if (node == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(5);
        }
        return this.myNode2postOrderNumber.containsKey(node) || super.containsNode(node);
    }

    @Override
    protected int getPostOrderNumber(@NotNull T node) {
        if (node == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(6);
        }
        if (this.myNode2postOrderNumber.containsKey(node)) {
            return this.myNode2postOrderNumber.get(node);
        }
        return super.getPostOrderNumber(node);
    }

    @NotNull
    private int[] getPostOrderNumbers(@NotNull List<T> nodes) {
        if (nodes == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(7);
        }
        int[] result = new int[nodes.size()];
        int i = 0;
        for (T node : nodes) {
            result[i++] = this.getPostOrderNumber(node);
        }
        if (result == null) {
            ReachabilityIndexExtImpl.$$$reportNull$$$0(8);
        }
        return result;
    }

    @Override
    protected long[] getIntervals(int poNum) {
        int shift = poNum - this.myMinPoNum;
        if (shift >= 0) {
            return this.myIntervals.get(shift);
        }
        return super.getIntervals(poNum);
    }

    @Override
    protected T getNode(int poNum) {
        if (poNum >= this.myMinPoNum) {
            return this.myPostOrderNumber2Node.get(poNum);
        }
        return super.getNode(poNum);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2PostOrderNumber";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postOrderNumber2Node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intervals";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ReachabilityIndexExtImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ReachabilityIndexExtImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostOrderNumbers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPostOrderNumber";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPostOrderNumbers";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

