/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.TObjectIntHashMap;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.graph.ReachabilityIndex;
import org.jetbrains.annotations.NotNull;

class ReachabilityIndexImpl<T>
implements ReachabilityIndex<T> {
    private static final long LOWER_BOUND_MASK = -4294967296L;
    private static final long UPPER_BOUND_MASK = 0xFFFFFFFFL;
    private final TObjectIntHashMap<T> myNode2postOrderNumber;
    private final T[] myPostOrderNumber2Node;
    private final long[][] myIntervals;

    ReachabilityIndexImpl(@NotNull TObjectIntHashMap<T> node2PostOrderNumber, @NotNull T[] postOrderNumber2Node, @NotNull long[][] intervals) {
        if (node2PostOrderNumber == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(0);
        }
        if (postOrderNumber2Node == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(1);
        }
        if (intervals == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(2);
        }
        this.myNode2postOrderNumber = node2PostOrderNumber;
        this.myPostOrderNumber2Node = postOrderNumber2Node;
        this.myIntervals = intervals;
    }

    @Override
    public void processReachable(@NotNull T from, @NotNull ItemProcessor<T> processor) {
        long[] intervals;
        if (from == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(4);
        }
        if (!this.containsNode(from)) {
            throw new IllegalArgumentException("Unknown node " + from);
        }
        int poNum = this.getPostOrderNumber(from);
        for (long interval : intervals = this.getIntervals(poNum)) {
            int start = ReachabilityIndexImpl.intervalStart(interval);
            int end = ReachabilityIndexImpl.intervalEnd(interval);
            for (int i = start; i <= end; ++i) {
                if (processor.processItem(this.getNode(i))) continue;
                return;
            }
        }
    }

    @Override
    public boolean isReachable(@NotNull T node, @NotNull T from) {
        if (node == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(5);
        }
        if (from == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(6);
        }
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("Unknown node " + node);
        }
        if (!this.containsNode(from)) {
            throw new IllegalArgumentException("Unknown node " + from);
        }
        int nodePoNum = this.getPostOrderNumber(node);
        int fromPoNum = this.getPostOrderNumber(from);
        long[] intervals = this.getIntervals(fromPoNum);
        return this.hasIntervalContaining(intervals, nodePoNum);
    }

    @Override
    @NotNull
    public Predicate<T> createReachablePredicate(@NotNull T from) {
        if (from == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(7);
        }
        if (!this.containsNode(from)) {
            throw new IllegalArgumentException("Unknown node " + from);
        }
        int poNum = this.getPostOrderNumber(from);
        final long[] intervals = this.getIntervals(poNum);
        Predicate predicate = new Predicate<T>(){

            public boolean apply(T item) {
                int poNum = ReachabilityIndexImpl.this.getPostOrderNumber(item);
                return ReachabilityIndexImpl.this.hasIntervalContaining(intervals, poNum);
            }
        };
        if (predicate == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(8);
        }
        return predicate;
    }

    protected boolean containsNode(@NotNull T node) {
        if (node == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(9);
        }
        return this.myNode2postOrderNumber.containsKey(node);
    }

    protected int getPostOrderNumber(@NotNull T node) {
        if (node == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(10);
        }
        return this.myNode2postOrderNumber.get(node);
    }

    protected long[] getIntervals(int poNum) {
        return this.myIntervals[poNum];
    }

    protected T getNode(int poNum) {
        return this.myPostOrderNumber2Node[poNum];
    }

    private boolean hasIntervalContaining(@NotNull long[] intervals, int poNum) {
        long interval;
        int start;
        int diff;
        if (intervals == null) {
            ReachabilityIndexImpl.$$$reportNull$$$0(11);
        }
        boolean found = false;
        long[] lArray = intervals;
        int n = lArray.length;
        for (int i = 0; i < n && (diff = poNum - (start = ReachabilityIndexImpl.intervalStart(interval = lArray[i]))) >= 0; ++i) {
            int end = ReachabilityIndexImpl.intervalEnd(interval);
            if (poNum > end) continue;
            found = true;
            break;
        }
        return found;
    }

    static long asLong(int intervalStart, int intervalEnd) {
        assert (intervalStart >= 0 && intervalEnd >= 0);
        return (long)intervalStart << 32 | (long)intervalEnd;
    }

    static boolean includes(long interval1, long interval2) {
        return interval1 == interval2 || (interval1 & 0xFFFFFFFF00000000L) <= (interval2 & 0xFFFFFFFF00000000L) && (interval1 & 0xFFFFFFFFL) >= (interval2 & 0xFFFFFFFFL);
    }

    static boolean containsNode(long interval, int node) {
        assert (node >= 0);
        return ReachabilityIndexImpl.intervalStart(interval) <= node && node <= ReachabilityIndexImpl.intervalEnd(interval);
    }

    static int intervalStart(long interval) {
        return (int)((interval & 0xFFFFFFFF00000000L) >> 32);
    }

    static int intervalEnd(long interval) {
        return (int)(interval & 0xFFFFFFFFL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2PostOrderNumber";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postOrderNumber2Node";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intervals";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ReachabilityIndexImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ReachabilityIndexImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createReachablePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReachable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReachable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createReachablePredicate";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPostOrderNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasIntervalContaining";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

