/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.BFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import org.jetbrains.annotations.NotNull;

public class ReachabilityPredicate {
    private static final Comparator<DepthFirstSearch<Long>> DFS_START_COMPARATOR = new Comparator<DepthFirstSearch<Long>>(){

        @Override
        public int compare(DepthFirstSearch<Long> left, DepthFirstSearch<Long> right) {
            return left.getStart().compareTo(right.getStart());
        }
    };
    private final DAG<Long> myDag;
    private final TLongHashSet myUninteresting;
    private final List<DepthFirstSearch<Long>> mySearches;
    private final DFSVisitor<Long> myCollectUninteresting;

    ReachabilityPredicate(@NotNull DAG<Long> dag) {
        if (dag == null) {
            ReachabilityPredicate.$$$reportNull$$$0(0);
        }
        this.myUninteresting = new TLongHashSet();
        this.mySearches = new ArrayList<DepthFirstSearch<Long>>();
        this.myDag = dag;
        this.myCollectUninteresting = new DFSVisitorAdapter<Long>(){

            @Override
            public boolean discover(@NotNull Long node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ReachabilityPredicate.this.myUninteresting.add(node.longValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/ReachabilityPredicate$2", "discover"));
            }
        };
    }

    public boolean isInteresting(final Long node) {
        if (this.myUninteresting.contains(node.longValue())) {
            return false;
        }
        for (DepthFirstSearch<Long> search : this.mySearches) {
            if (search.getStart() < node) continue;
            search.runWhile(new DepthFirstSearch.Predicate<Long>(){

                @Override
                public boolean apply(@NotNull Long uninteresting) {
                    if (uninteresting == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return uninteresting >= node;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uninteresting", "jetbrains/buildServer/util/graph/ReachabilityPredicate$3", "apply"));
                }
            });
            if (!this.myUninteresting.contains(node.longValue())) continue;
            return false;
        }
        return !this.myUninteresting.contains(node.longValue());
    }

    public void markUninteresting(long node) {
        DepthFirstSearch<Long> search;
        int index;
        if (!this.myUninteresting.contains(node) && (index = Collections.binarySearch(this.mySearches, search = this.myDag.getDepthFirstSearch(node, this.myCollectUninteresting), DFS_START_COMPARATOR)) < 0) {
            this.mySearches.add(-(index + 1), search);
        }
    }

    @NotNull
    public BFSVisitor<Long> createBfsVisitor(final @NotNull BFSVisitor<Long> delegate) {
        if (delegate == null) {
            ReachabilityPredicate.$$$reportNull$$$0(1);
        }
        BFSVisitorAdapter<Long> bFSVisitorAdapter = new BFSVisitorAdapter<Long>(){

            @Override
            public boolean discover(@NotNull Long node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (ReachabilityPredicate.this.isInteresting(node)) {
                    return delegate.discover(node);
                }
                return false;
            }

            @Override
            public void searchFinished() {
                delegate.searchFinished();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/ReachabilityPredicate$4", "discover"));
            }
        };
        if (bFSVisitorAdapter == null) {
            ReachabilityPredicate.$$$reportNull$$$0(2);
        }
        return bFSVisitorAdapter;
    }

    @NotNull
    public DFSVisitor<Long> createDfsVisitor(final @NotNull DFSVisitor<Long> delegate) {
        if (delegate == null) {
            ReachabilityPredicate.$$$reportNull$$$0(3);
        }
        DFSVisitorAdapter<Long> dFSVisitorAdapter = new DFSVisitorAdapter<Long>(){

            @Override
            public boolean discover(@NotNull Long node) {
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (ReachabilityPredicate.this.isInteresting(node)) {
                    return delegate.discover(node);
                }
                return false;
            }

            @Override
            public void finish(@NotNull Long node) {
                if (node == null) {
                    5.$$$reportNull$$$0(1);
                }
                delegate.finish(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "jetbrains/buildServer/util/graph/ReachabilityPredicate$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "discover";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "finish";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dFSVisitorAdapter == null) {
            ReachabilityPredicate.$$$reportNull$$$0(4);
        }
        return dFSVisitorAdapter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/ReachabilityPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/ReachabilityPredicate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBfsVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDfsVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBfsVisitor";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDfsVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

