/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.ChildrenFirstSearch;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.EmptyDAG;
import jetbrains.buildServer.util.graph.EmptyLinearDag;
import jetbrains.buildServer.util.graph.LinearDag;
import jetbrains.buildServer.util.graph.LinearModificationDag;
import jetbrains.buildServer.util.graph.LinearModificationDagInt;
import jetbrains.buildServer.util.graph.ModificationDAG;
import jetbrains.buildServer.util.graph.ModificationDAGInt;
import jetbrains.buildServer.util.graph.ModificationDagConfig;
import jetbrains.buildServer.util.graph.ReachabilityPredicate;
import org.jetbrains.annotations.NotNull;

public class VcsDAGs {
    static final int NEW_GRAPH_IN_CHAIN_THRESHOLD = 500;
    static final int NEW_LINEAR_GRAPH_IN_CHAIN_THRESHOLD = 1000;

    @NotNull
    public static DAG<Long> emptyDAG() {
        EmptyDAG<Long> emptyDAG = new EmptyDAG<Long>();
        if (emptyDAG == null) {
            VcsDAGs.$$$reportNull$$$0(0);
        }
        return emptyDAG;
    }

    @NotNull
    public static DAG<Long> createFromEdges(@NotNull Collection<? extends Pair<Long, Long>> edges) {
        if (edges == null) {
            VcsDAGs.$$$reportNull$$$0(1);
        }
        if (VcsDAGs.integerRangeNodes(edges)) {
            ModificationDAGInt modificationDAGInt = new ModificationDAGInt(new EmptyDAG<Long>(), edges, VcsDAGs.createConfig());
            if (modificationDAGInt == null) {
                VcsDAGs.$$$reportNull$$$0(2);
            }
            return modificationDAGInt;
        }
        ModificationDAG modificationDAG = new ModificationDAG(new EmptyDAG<Long>(), edges, VcsDAGs.createConfig());
        if (modificationDAG == null) {
            VcsDAGs.$$$reportNull$$$0(3);
        }
        return modificationDAG;
    }

    public static DAG<Long> createLinearDag(@NotNull List<Long> nodes) {
        if (nodes == null) {
            VcsDAGs.$$$reportNull$$$0(4);
        }
        if (nodes.isEmpty()) {
            return new LinearModificationDagInt(new EmptyLinearDag(), nodes, VcsDAGs.getLinearModificationDagLoadFactor());
        }
        Long maxNode = nodes.get(0);
        return VcsDAGs.createLinearDag(new EmptyLinearDag(), nodes, maxNode);
    }

    @NotNull
    public static DAG<Long> addEdges(@NotNull DAG<Long> dag, @NotNull Collection<? extends Pair<Long, Long>> edges) {
        if (dag == null) {
            VcsDAGs.$$$reportNull$$$0(5);
        }
        if (edges == null) {
            VcsDAGs.$$$reportNull$$$0(6);
        }
        if (edges.isEmpty()) {
            DAG<Long> dAG = dag;
            if (dAG == null) {
                VcsDAGs.$$$reportNull$$$0(7);
            }
            return dAG;
        }
        if (dag.selfSize() > VcsDAGs.getDagChunkSize()) {
            if (VcsDAGs.integerRangeNodes(edges)) {
                ModificationDAGInt modificationDAGInt = new ModificationDAGInt(dag, edges, VcsDAGs.createConfig());
                if (modificationDAGInt == null) {
                    VcsDAGs.$$$reportNull$$$0(8);
                }
                return modificationDAGInt;
            }
            ModificationDAG modificationDAG = new ModificationDAG(dag, edges, VcsDAGs.createConfig());
            if (modificationDAG == null) {
                VcsDAGs.$$$reportNull$$$0(9);
            }
            return modificationDAG;
        }
        ArrayList<Object> edgesUnion = new ArrayList<Object>(edges.size() + dag.selfSize());
        edgesUnion.addAll(edges);
        edgesUnion.addAll(dag.getInitialEdges());
        if (VcsDAGs.integerRangeNodes(edges)) {
            ModificationDAGInt modificationDAGInt = new ModificationDAGInt(dag.getTail(), edgesUnion, VcsDAGs.createConfig());
            if (modificationDAGInt == null) {
                VcsDAGs.$$$reportNull$$$0(10);
            }
            return modificationDAGInt;
        }
        ModificationDAG modificationDAG = new ModificationDAG(dag.getTail(), edgesUnion, VcsDAGs.createConfig());
        if (modificationDAG == null) {
            VcsDAGs.$$$reportNull$$$0(11);
        }
        return modificationDAG;
    }

    public static DAG<Long> addNodes(@NotNull DAG<Long> dag, @NotNull List<Long> nodes) {
        if (dag == null) {
            VcsDAGs.$$$reportNull$$$0(12);
        }
        if (nodes == null) {
            VcsDAGs.$$$reportNull$$$0(13);
        }
        if (!(dag instanceof LinearDag)) {
            throw new IllegalArgumentException("Linear dag expected");
        }
        LinearDag ldag = (LinearDag)dag;
        if (nodes.isEmpty()) {
            return dag;
        }
        if (ldag.selfSize() > VcsDAGs.getLinearDagChunkSize()) {
            return VcsDAGs.createLinearDag(ldag, nodes, nodes.get(0));
        }
        ArrayList<Long> nodesUnion = new ArrayList<Long>(nodes.size() + ldag.selfSize());
        nodesUnion.addAll(nodes);
        nodesUnion.addAll(ldag.getInitialNodes());
        return VcsDAGs.createLinearDag((LinearDag)ldag.getTail(), nodesUnion, nodes.get(0));
    }

    public static void childrenFirstSearch(@NotNull DAG<Long> dag, @NotNull BFSVisitor<Long> visitor, @NotNull Set<Long> starts) {
        if (dag == null) {
            VcsDAGs.$$$reportNull$$$0(14);
        }
        if (visitor == null) {
            VcsDAGs.$$$reportNull$$$0(15);
        }
        if (starts == null) {
            VcsDAGs.$$$reportNull$$$0(16);
        }
        for (Long start : starts) {
            dag.ensureContainsNode(start);
        }
        new ChildrenFirstSearch(dag, starts, visitor).run();
    }

    private static DAG<Long> createLinearDag(@NotNull LinearDag tail, @NotNull List<Long> nodes, @NotNull Long maxNode) {
        if (tail == null) {
            VcsDAGs.$$$reportNull$$$0(17);
        }
        if (nodes == null) {
            VcsDAGs.$$$reportNull$$$0(18);
        }
        if (maxNode == null) {
            VcsDAGs.$$$reportNull$$$0(19);
        }
        if (maxNode < Integer.MAX_VALUE) {
            return new LinearModificationDagInt(tail, nodes, VcsDAGs.getLinearModificationDagLoadFactor());
        }
        return new LinearModificationDag(tail, nodes, VcsDAGs.getLinearModificationDagLoadFactor());
    }

    private static int getDagChunkSize() {
        return TeamCityProperties.getInteger((String)"teamcity.dag.dagChunkSize", (int)500);
    }

    private static int getLinearDagChunkSize() {
        return TeamCityProperties.getInteger((String)"teamcity.dag.linearDagChunkSize", (int)1000);
    }

    private static float getModificationDagLoadFactor() {
        return TeamCityProperties.getFloat((String)"teamcity.dag.load.factor", (float)0.95f);
    }

    private static int getPrecalculatedNodesWithoutChildrenPercent() {
        return TeamCityProperties.getInteger((String)"teamcity.dag.precalculatedNodesWithoutChildrenPercent", (int)10);
    }

    private static float getLinearModificationDagLoadFactor() {
        return TeamCityProperties.getFloat((String)"teamcity.linear.dag.load.factor", (float)0.95f);
    }

    private static boolean integerRangeNodes(@NotNull Collection<? extends Pair<Long, Long>> edges) {
        if (edges == null) {
            VcsDAGs.$$$reportNull$$$0(20);
        }
        if (!TeamCityProperties.getBooleanOrTrue((String)"teamcity.dag.useIntDags")) {
            return false;
        }
        for (Pair<Long, Long> pair : edges) {
            if (pair.first != null && ((Long)pair.first < Integer.MIN_VALUE || (Long)pair.first > Integer.MAX_VALUE)) {
                return false;
            }
            if (pair.second == null || (Long)pair.second >= Integer.MIN_VALUE && (Long)pair.second <= Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static ModificationDagConfig createConfig() {
        ModificationDagConfig modificationDagConfig = new ModificationDagConfig(VcsDAGs.getModificationDagLoadFactor(), VcsDAGs.getPrecalculatedNodesWithoutChildrenPercent());
        if (modificationDagConfig == null) {
            VcsDAGs.$$$reportNull$$$0(21);
        }
        return modificationDagConfig;
    }

    @NotNull
    public static ReachabilityPredicate createReachabilityPredicate(@NotNull DAG<Long> dag) {
        if (dag == null) {
            VcsDAGs.$$$reportNull$$$0(22);
        }
        ReachabilityPredicate reachabilityPredicate = new ReachabilityPredicate(dag);
        if (reachabilityPredicate == null) {
            VcsDAGs.$$$reportNull$$$0(23);
        }
        return reachabilityPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/VcsDAGs";
                break;
            }
            case 1: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 4: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyDAG";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/VcsDAGs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromEdges";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addEdges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfig";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createReachabilityPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFromEdges";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLinearDag";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "childrenFirstSearch";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "integerRangeNodes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createReachabilityPredicate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

