/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.util.graph.Edge;
import jetbrains.buildServer.util.graph.GenericDAG;
import org.jetbrains.annotations.NotNull;

final class Vertex<T> {
    private final GenericDAG<T> myGraph;
    private final T myValue;

    public Vertex(@NotNull GenericDAG<T> graph, @NotNull T value) {
        if (graph == null) {
            Vertex.$$$reportNull$$$0(0);
        }
        if (value == null) {
            Vertex.$$$reportNull$$$0(1);
        }
        this.myGraph = graph;
        this.myValue = value;
    }

    @NotNull
    public T getValue() {
        T t = this.myValue;
        if (t == null) {
            Vertex.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public List<Vertex<T>> getParents() {
        List<Vertex<T>> list = this.myGraph.getAdjList(this);
        if (list == null) {
            Vertex.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<Vertex<T>> getChildren() {
        List<Vertex<T>> list = this.myGraph.getChildrenList(this);
        if (list == null) {
            Vertex.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Edge<T>> getEdgesToParents() {
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        for (Vertex<T> parent : this.getParents()) {
            edges.add(Edge.createEdge(this.myValue, parent.getValue()));
        }
        if (edges.isEmpty()) {
            edges.add(Edge.createEdge(this.myValue, null));
        }
        ArrayList<Edge<T>> arrayList = edges;
        if (arrayList == null) {
            Vertex.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)o;
        return this.myValue.equals(other.myValue);
    }

    public int hashCode() {
        return this.myValue.hashCode();
    }

    public String toString() {
        return this.myValue.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/Vertex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/Vertex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgesToParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

