/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.Credentials;
import jetbrains.buildServer.vcs.VcsUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenVcsUrl
extends VcsUrl {
    public static final String SCM_DELIM = ":";
    public static final String MISSING_VCS_PROVIDER_NAME_ERROR_MSG = "Missing VCS (SCM) provider name";
    @NotNull
    private final String myProviderSchema;
    @NotNull
    private final String myProviderSpecificPart;
    @Nullable
    private Integer myLastDelim;
    private static final String SCM_PREFIX = "scm:";
    private static final String VCS_PREFIX = "vcs:";
    private static final Set<String> NON_VCS_SCHEMATA = new HashSet<String>(Arrays.asList("http", "ftp", "https", "file"));

    public MavenVcsUrl(@NotNull String url, @Nullable Credentials credentials) throws MalformedURLException {
        if (url == null) {
            MavenVcsUrl.$$$reportNull$$$0(0);
        }
        super(url, credentials);
        String tmpUrl = MavenVcsUrl.stripPrefix(this.myUrl);
        this.myProviderSchema = MavenVcsUrl.extractProviderSchema(tmpUrl);
        String providerSpecificPart = tmpUrl.substring(this.myProviderSchema.length() + 1);
        if (StringUtil.isEmptyOrSpaces((String)providerSpecificPart)) {
            throw new MalformedURLException("Missing provider specific part");
        }
        if (providerSpecificPart.startsWith("//")) {
            providerSpecificPart = this.myProviderSchema + SCM_DELIM + providerSpecificPart;
        }
        this.myProviderSpecificPart = providerSpecificPart;
    }

    public MavenVcsUrl(@NotNull String url) throws MalformedURLException {
        if (url == null) {
            MavenVcsUrl.$$$reportNull$$$0(1);
        }
        this(url, null);
    }

    @NotNull
    public String getProviderSchema() {
        String string = this.myProviderSchema;
        if (string == null) {
            MavenVcsUrl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getProviderSpecificPart() {
        String string = this.myProviderSpecificPart;
        if (string == null) {
            MavenVcsUrl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String stripPrefix(@NotNull String s) {
        if (s == null) {
            MavenVcsUrl.$$$reportNull$$$0(4);
        }
        if (s.startsWith(SCM_PREFIX)) {
            s = s.substring(SCM_PREFIX.length());
        }
        if (s.startsWith(VCS_PREFIX)) {
            s = s.substring(VCS_PREFIX.length());
        }
        return s;
    }

    private static int indexOfDelim(String str) {
        int delimIndex = str.indexOf(124);
        if (delimIndex == -1) {
            delimIndex = str.indexOf(SCM_DELIM);
        }
        return delimIndex;
    }

    @NotNull
    private static String extractProviderSchema(String url) throws MalformedURLException {
        int delimIndex = MavenVcsUrl.indexOfDelim(url);
        if (delimIndex == -1) {
            throw new MalformedURLException(MISSING_VCS_PROVIDER_NAME_ERROR_MSG);
        }
        String schema = url.substring(0, delimIndex);
        if (StringUtil.isEmptyOrSpaces((String)schema)) {
            throw new MalformedURLException(MISSING_VCS_PROVIDER_NAME_ERROR_MSG);
        }
        if (NON_VCS_SCHEMATA.contains(schema)) {
            throw new MalformedURLException(MISSING_VCS_PROVIDER_NAME_ERROR_MSG);
        }
        if (schema.indexOf(64) != -1) {
            throw new MalformedURLException(MISSING_VCS_PROVIDER_NAME_ERROR_MSG);
        }
        String string = schema;
        if (string == null) {
            MavenVcsUrl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public MavenVcsUrl getParent() {
        String path = StringUtil.removeTailingSlash((String)this.myProviderSpecificPart);
        if (this.myLastDelim == null) {
            this.myLastDelim = MavenVcsUrl.findLastDelim(path);
        }
        try {
            return this.myLastDelim >= 0 ? new MavenVcsUrl(this.myProviderSchema + SCM_DELIM + path.substring(0, this.myLastDelim), this.getCredentials()) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Nullable
    public String getLastPathElement() {
        String path = StringUtil.removeTailingSlash((String)this.myProviderSpecificPart);
        if (this.myLastDelim == null) {
            this.myLastDelim = MavenVcsUrl.findLastDelim(path);
        }
        return this.myLastDelim >= 0 ? path.substring(this.myLastDelim + 1) : null;
    }

    private static int findLastDelim(String path) {
        int lastDoubleDelim;
        int lastDelim = path.lastIndexOf(47);
        if (lastDelim != -1 && lastDelim != path.length() - 1 && (lastDoubleDelim = path.lastIndexOf("//")) != -1 && lastDelim - lastDoubleDelim == 1) {
            lastDelim = -1;
        }
        return lastDelim;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenVcsUrl)) {
            return super.equals(o);
        }
        MavenVcsUrl vcsUrl = (MavenVcsUrl)o;
        if (this.myCredentials != null ? !this.myCredentials.equals((Object)vcsUrl.myCredentials) : vcsUrl.myCredentials != null) {
            return false;
        }
        if (!this.myProviderSchema.equals(vcsUrl.myProviderSchema)) {
            return false;
        }
        return this.myProviderSpecificPart.equals(vcsUrl.myProviderSpecificPart);
    }

    @Override
    public int hashCode() {
        int result = this.myProviderSchema.hashCode();
        result = 31 * result + this.myProviderSpecificPart.hashCode();
        result = 31 * result + (this.myCredentials != null ? this.myCredentials.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/MavenVcsUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/MavenVcsUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderSchema";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderSpecificPart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractProviderSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

