/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.vcs.patches.AbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.FSPatcherCallbackImpl;
import jetbrains.buildServer.vcs.patches.InterruptablePatcherBase;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.PatchListener;
import jetbrains.buildServer.vcs.patches.Patcher;
import jetbrains.buildServer.vcs.patches.PatcherErrorHandler;
import jetbrains.buildServer.vcs.patches.PatcherEventDispatcher;
import jetbrains.buildServer.vcs.patches.store.FileKey;
import jetbrains.buildServer.vcs.patches.store.FileStorageReader;
import jetbrains.buildServer.vcs.patches.store.FileStorageWriter;
import org.jetbrains.annotations.NotNull;

public class FSUndoPatchBuilder {
    private static final Logger LOG = Logger.getInstance((String)FSUndoPatchBuilder.class.getName());
    private final List<Action> myActions;
    private final FileStorageWriter myFilesWriter;
    private boolean myPreserveTimestamp;
    private boolean myPreserveFileAttributes;

    public FSUndoPatchBuilder(@NotNull FileStorageWriter filesWriter) {
        if (filesWriter == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(0);
        }
        this.myActions = new ArrayList<Action>();
        this.myPreserveTimestamp = true;
        this.myPreserveFileAttributes = true;
        this.myFilesWriter = filesWriter;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.myPreserveTimestamp = preserveTimestamp;
    }

    public void setPreverseReadonlyAttribute(boolean preverseFileAttributes) {
        this.myPreserveFileAttributes = preverseFileAttributes;
    }

    public void writeFinished() throws IOException {
        this.myFilesWriter.closeWriter();
    }

    public Patcher createUndoPatcher(final @NotNull PatcherErrorHandler errorHandler) throws IOException {
        if (errorHandler == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(1);
        }
        FileStorageReader reader = this.myFilesWriter.closeOpenReader();
        Collections.reverse(this.myActions);
        FSPatcherCallbackImpl cb = new FSPatcherCallbackImpl(){

            @Override
            public PatcherErrorHandler getErrorHandler() {
                return errorHandler;
            }
        };
        return new RevertPatcher(cb, reader);
    }

    protected void revertPatchClosed() {
    }

    private void postAction(@NotNull Action action) {
        if (action == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(2);
        }
        this.myActions.add(action);
    }

    public void recordDelete(final @NotNull File file) throws IOException {
        if (file == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(3);
        }
        this.postAction(new Action(){

            @Override
            public void apply(@NotNull AbstractFSPatcherCallback callback, @NotNull FileStorageReader reader, @NotNull PatchListener event) throws IOException {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                event.fileOrDirectoryDeleted(file);
                if (file.exists()) {
                    callback.deleteFile(file, false, file.isFile());
                }
            }

            public String toString() {
                return "Delete " + file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$2";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void recordDirectory(final @NotNull File dir) throws IOException {
        if (dir == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(4);
        }
        this.postAction(new Action(){

            @Override
            public void apply(@NotNull AbstractFSPatcherCallback callback, @NotNull FileStorageReader reader, @NotNull PatchListener event) throws IOException {
                if (callback == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                event.fileOrDirectoryAdded(dir);
                callback.addDirectory(dir);
            }

            public String toString() {
                return "Add directory " + dir;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$3";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void recordReadonlyAttribute(final @NotNull File file) {
        if (file == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(5);
        }
        if (!this.myPreserveFileAttributes) {
            return;
        }
        final boolean isReadonly = FileUtil.isReadonly((File)file);
        this.postAction(new Action(){

            @Override
            public void apply(@NotNull AbstractFSPatcherCallback callback, @NotNull FileStorageReader reader, @NotNull PatchListener event) throws IOException {
                if (callback == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    4.$$$reportNull$$$0(2);
                }
                callback.setReadonlyAttribute(file, isReadonly);
            }

            public String toString() {
                return String.format("Set attributes for %s. Readonly: %s", file, isReadonly);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$4";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void recordTimestamp(final @NotNull File file) throws IOException {
        if (file == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(6);
        }
        if (!this.myPreserveTimestamp) {
            return;
        }
        final long timeStamp = file.lastModified();
        this.postAction(new Action(){

            @Override
            public void apply(@NotNull AbstractFSPatcherCallback callback, @NotNull FileStorageReader reader, @NotNull PatchListener event) throws IOException {
                if (callback == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    5.$$$reportNull$$$0(2);
                }
                callback.setTimeStamp(file, timeStamp);
            }

            public String toString() {
                return "Set timestamp " + file + " to " + timeStamp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$5";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void recordFile(final @NotNull File file) throws IOException {
        if (file == null) {
            FSUndoPatchBuilder.$$$reportNull$$$0(7);
        }
        this.recordTimestamp(file);
        this.recordReadonlyAttribute(file);
        final FileKey key = this.myFilesWriter.writeFile(file);
        this.postAction(new Action(){

            @Override
            public void apply(@NotNull AbstractFSPatcherCallback callback, final @NotNull FileStorageReader reader, @NotNull PatchListener event) throws IOException {
                if (callback == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    6.$$$reportNull$$$0(2);
                }
                event.fileOrDirectoryChanged(file);
                callback.replaceBinary(file, key.getSize(), false, new LowLevelPatcherListener.ReadFileContent(){

                    @Override
                    @NotNull
                    public InputStream getInputStream() throws IOException {
                        InputStream inputStream = reader.readFile(key);
                        if (inputStream == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return inputStream;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$6$1", "getInputStream"));
                    }
                });
            }

            public String toString() {
                return "Write " + file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$6";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWriter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createUndoPatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "postAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "recordDelete";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "recordDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "recordReadonlyAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "recordTimestamp";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "recordFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface Action {
        public void apply(@NotNull AbstractFSPatcherCallback var1, @NotNull FileStorageReader var2, @NotNull PatchListener var3) throws IOException;
    }

    private class RevertPatcher
    extends InterruptablePatcherBase
    implements Patcher,
    PatcherEventDispatcher {
        private final AbstractFSPatcherCallback myCb;
        private final FileStorageReader myReader;
        private final EventDispatcher<PatchListener> myListener = EventDispatcher.create(PatchListener.class);

        public RevertPatcher(AbstractFSPatcherCallback cb, FileStorageReader reader) {
            this.myCb = cb;
            this.myReader = reader;
        }

        public void applyPatch() throws IOException {
            try {
                for (Action action : FSUndoPatchBuilder.this.myActions) {
                    this.checkInterrupted();
                    action.apply(this.myCb, this.myReader, (PatchListener)this.myListener.getMulticaster());
                }
                ((PatchListener)this.myListener.getMulticaster()).patchFinished("");
            }
            catch (IOException e) {
                ((PatchListener)this.myListener.getMulticaster()).patchFailed(e.getMessage());
                throw e;
            }
        }

        public void close() {
            try {
                this.myReader.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close FileStorageReader.", (Throwable)e);
            }
            FSUndoPatchBuilder.this.revertPatchClosed();
        }

        @Override
        public void addListener(@NotNull PatchListener listener) {
            if (listener == null) {
                RevertPatcher.$$$reportNull$$$0(0);
            }
            this.myListener.addListener((EventListener)listener);
        }

        @Override
        public void removeListener(@NotNull PatchListener listener) {
            if (listener == null) {
                RevertPatcher.$$$reportNull$$$0(1);
            }
            this.myListener.removeListener((EventListener)listener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "listener";
            objectArray2[1] = "jetbrains/buildServer/vcs/patches/FSUndoPatchBuilder$RevertPatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

