/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.vcs.patches.AbstractFSPatcher;
import jetbrains.buildServer.vcs.patches.AbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.FSUndoPatchBuilder;
import jetbrains.buildServer.vcs.patches.Patcher;
import jetbrains.buildServer.vcs.patches.PatcherErrorHandler;
import jetbrains.buildServer.vcs.patches.UndoAbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.store.RandomAccessFileStoreWriter;
import org.jetbrains.annotations.NotNull;

public class FSUndoSupportingPatcher
extends AbstractFSPatcher {
    private static final Logger LOG = Logger.getInstance((String)FSUndoSupportingPatcher.class.getName());
    private final FSUndoPatchBuilder myUndo;
    private final PatcherErrorHandler myErrorHandler;

    public FSUndoSupportingPatcher(@NotNull InputStream input, @NotNull File dir, @NotNull File undoPatchTmp, @NotNull PatcherErrorHandler errorHander) throws IOException {
        if (input == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(1);
        }
        if (undoPatchTmp == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(2);
        }
        if (errorHander == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(3);
        }
        super(new DataInputStream(new BufferedInputStream(input)), dir);
        this.myErrorHandler = errorHander;
        this.myUndo = new FSUndoPatchBuilder(new RandomAccessFileStoreWriter(undoPatchTmp)){

            @Override
            protected void revertPatchClosed() {
                super.revertPatchClosed();
                FSUndoSupportingPatcher.this.undoPatcherClosed();
            }
        };
    }

    @Override
    public void close() {
        super.close();
        try {
            this.myUndo.writeFinished();
        }
        catch (IOException e) {
            LOG.warn("Failed to close undo patched with application error. " + e.getMessage(), (Throwable)e);
        }
    }

    protected void undoPatcherClosed() {
    }

    public Patcher getUndoPatcher(@NotNull PatcherErrorHandler errors) throws IOException {
        if (errors == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(4);
        }
        return this.myUndo.createUndoPatcher(errors);
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.myUndo.setPreserveTimestamp(preserveTimestamp);
    }

    public void setPreverseReadonlyAttribute(boolean preverseReadonlyAttribute) {
        this.myUndo.setPreverseReadonlyAttribute(preverseReadonlyAttribute);
    }

    @Override
    @NotNull
    protected final AbstractFSPatcherCallback createCallback() {
        UndoAbstractFSPatcherCallback undoAbstractFSPatcherCallback = new UndoAbstractFSPatcherCallback(this.myUndo, this.myErrorHandler);
        if (undoAbstractFSPatcherCallback == null) {
            FSUndoSupportingPatcher.$$$reportNull$$$0(5);
        }
        return undoAbstractFSPatcherCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoPatchTmp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHander";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/FSUndoSupportingPatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/FSUndoSupportingPatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUndoPatcher";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

