/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.AbstractPatchBuilder;
import jetbrains.buildServer.vcs.patches.LowLevelPatchBuilder;
import jetbrains.buildServer.vcs.patches.LowLevelPatchBuilderImpl;
import jetbrains.buildServer.vcs.patches.PatchBuilderContentInputStream;
import jetbrains.buildServer.vcs.patches.PatchBuilderEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchBuilderImpl
extends AbstractPatchBuilder
implements PatchBuilderEx {
    private static final byte[] SYSTEM_DEFINED_SEPARATOR = new byte[0];
    private final LowLevelPatchBuilder myBuilder;
    private boolean myIsInterrupted;
    private boolean myIsClosed;

    public PatchBuilderImpl(@NotNull OutputStream output) {
        if (output == null) {
            PatchBuilderImpl.$$$reportNull$$$0(0);
        }
        this(new LowLevelPatchBuilderImpl(new DataOutputStream(new BufferedOutputStream(output))));
    }

    public PatchBuilderImpl(@NotNull LowLevelPatchBuilder builder) {
        if (builder == null) {
            PatchBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myIsInterrupted = false;
        this.myIsClosed = false;
        this.myBuilder = builder;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void changeOrCreateTextFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        void lineSeparator;
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(2);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(3);
        }
        this.checkIsInterrupted();
        this.changeOrCreateTextFile(false, (byte[])lineSeparator, this.getStringPathInCurrentWorkingDirectory(localFile), length, input, fileMode);
    }

    @NotNull
    private String getStringPathInCurrentWorkingDirectory(@NotNull File localFile) {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(4);
        }
        String string = this.getPathInCurrentWorkingDirectory(localFile).getPath();
        if (string == null) {
            PatchBuilderImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void checkIsInterrupted() throws IOException {
        if (this.myIsInterrupted) {
            throw new IOException("Patch process has been interrupted");
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void createTextFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        void lineSeparator;
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(6);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(7);
        }
        this.checkIsInterrupted();
        this.changeOrCreateTextFile(true, (byte[])lineSeparator, this.getStringPathInCurrentWorkingDirectory(localFile), length, input, fileMode);
    }

    public synchronized void setLastModified(@NotNull File localFile, long time) throws IOException {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(8);
        }
        this.checkIsInterrupted();
        this.myBuilder.setTimeStamp(this.getStringPathInCurrentWorkingDirectory(localFile), time);
    }

    public synchronized boolean isInterrupted() {
        return this.myIsInterrupted;
    }

    /*
     * WARNING - void declaration
     */
    private void changeOrCreateTextFile(boolean create, @Nullable byte[] lineSeparator, @NotNull String localFile, long length, @NotNull InputStream input, @Nullable String string) throws IOException {
        void fileMode;
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(9);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(10);
        }
        byte[] usingSep = lineSeparator == null ? SYSTEM_DEFINED_SEPARATOR : lineSeparator;
        this.myBuilder.changeTextUsingBytes(localFile, usingSep, length, PatchBuilderImpl.createContent(input, length), create);
        this.setFileMode(localFile, (String)fileMode);
    }

    private void setFileMode(@Nullable String localFilePath, @Nullable String fileMode) throws IOException {
        if (localFilePath != null && fileMode != null && fileMode.contains("x")) {
            this.myBuilder.setFileMode(localFilePath, fileMode);
        }
    }

    @Override
    @NotNull
    public synchronized LowLevelPatchBuilder getLowLevelBuilder() {
        LowLevelPatchBuilder lowLevelPatchBuilder = this.myBuilder;
        if (lowLevelPatchBuilder == null) {
            PatchBuilderImpl.$$$reportNull$$$0(11);
        }
        return lowLevelPatchBuilder;
    }

    public synchronized void renameFile(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderImpl.$$$reportNull$$$0(12);
        }
        if (newFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(13);
        }
        this.rename(this.getStringPathInCurrentWorkingDirectory(file), this.getStringPathInCurrentWorkingDirectory(newFile), deleteParentDirectoryIfEmpty, true);
    }

    private void rename(@NotNull String localFile, @NotNull String newFile, boolean emptyParent, boolean isFile) throws IOException {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(14);
        }
        if (newFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(15);
        }
        this.checkIsInterrupted();
        this.myBuilder.rename(localFile, newFile, isFile, emptyParent);
    }

    public synchronized void renameDirectory(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderImpl.$$$reportNull$$$0(16);
        }
        if (newFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(17);
        }
        this.rename(this.getStringPathInCurrentWorkingDirectory(file), this.getStringPathInCurrentWorkingDirectory(newFile), deleteParentDirectoryIfEmpty, false);
    }

    public synchronized void deleteFile(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderImpl.$$$reportNull$$$0(18);
        }
        this.delete(this.getStringPathInCurrentWorkingDirectory(file), deleteParentDirectoryIfEmpty, true);
    }

    private void delete(String localFile, boolean deleteParentDirectoryIfEmpty, boolean isFile) throws IOException {
        this.checkIsInterrupted();
        this.myBuilder.delete(localFile, isFile, deleteParentDirectoryIfEmpty);
    }

    public synchronized void deleteDirectory(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            PatchBuilderImpl.$$$reportNull$$$0(19);
        }
        this.delete(this.getStringPathInCurrentWorkingDirectory(file), deleteParentDirectoryIfEmpty, false);
    }

    public synchronized void changeOrCreateBinaryFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length) throws IOException {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(20);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(21);
        }
        this.checkIsInterrupted();
        this.changeOrCreateBinaryFile(false, this.getStringPathInCurrentWorkingDirectory(localFile), length, input, fileMode);
    }

    public synchronized void createBinaryFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length) throws IOException {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(22);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(23);
        }
        this.checkIsInterrupted();
        this.changeOrCreateBinaryFile(true, this.getStringPathInCurrentWorkingDirectory(localFile), length, input, fileMode);
    }

    /*
     * WARNING - void declaration
     */
    private void changeOrCreateBinaryFile(boolean create, @NotNull String file, long length, @NotNull InputStream input, @Nullable String string) throws IOException {
        void fileMode;
        if (file == null) {
            PatchBuilderImpl.$$$reportNull$$$0(24);
        }
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(25);
        }
        this.myBuilder.changeBinary(file, length, PatchBuilderImpl.createContent(input, length), create);
        this.setFileMode(file, (String)fileMode);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.myIsClosed) {
            this.myBuilder.exit("");
        }
        this.myBuilder.close();
    }

    @Override
    public synchronized void fail(@NotNull String errorMessage) throws IOException {
        if (errorMessage == null) {
            PatchBuilderImpl.$$$reportNull$$$0(26);
        }
        try {
            this.myBuilder.fail(StringUtil.truncateStringValueWithDotsAtEnd((String)errorMessage, (int)20000));
        }
        finally {
            this.myIsClosed = true;
        }
    }

    public synchronized void createDirectory(@NotNull File localFile) throws IOException {
        if (localFile == null) {
            PatchBuilderImpl.$$$reportNull$$$0(27);
        }
        this.checkIsInterrupted();
        this.myBuilder.addDirectory(this.getStringPathInCurrentWorkingDirectory(localFile));
    }

    public synchronized void interrupt() throws IOException {
        try {
            this.myBuilder.interrupt();
            this.close();
        }
        finally {
            this.myIsInterrupted = true;
        }
    }

    public synchronized void flush() throws IOException {
        this.myBuilder.flush();
    }

    @NotNull
    public static StreamWriteFileContent createContent(@NotNull InputStream input, long length) {
        if (input == null) {
            PatchBuilderImpl.$$$reportNull$$$0(28);
        }
        if (input instanceof PatchBuilderContentInputStream) {
            StreamWriteFileContentWithExtensions streamWriteFileContentWithExtensions = new StreamWriteFileContentWithExtensions(input, (PatchBuilderContentInputStream)input, length);
            if (streamWriteFileContentWithExtensions == null) {
                PatchBuilderImpl.$$$reportNull$$$0(29);
            }
            return streamWriteFileContentWithExtensions;
        }
        StreamWriteFileContent streamWriteFileContent = new StreamWriteFileContent(input, length);
        if (streamWriteFileContent == null) {
            PatchBuilderImpl.$$$reportNull$$$0(30);
        }
        return streamWriteFileContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 5: 
            case 11: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/PatchBuilderImpl";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/PatchBuilderImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPathInCurrentWorkingDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowLevelBuilder";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeOrCreateTextFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringPathInCurrentWorkingDirectory";
                break;
            }
            case 5: 
            case 11: 
            case 29: 
            case 30: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTextFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLastModified";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "renameDirectory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteDirectory";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "changeOrCreateBinaryFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StreamWriteFileContentWithExtensions
    extends StreamWriteFileContent
    implements PatchBuilderContentInputStream,
    LowLevelPatchBuilder.WriteFileContent {
        private final PatchBuilderContentInputStream myInfo;

        public StreamWriteFileContentWithExtensions(@NotNull InputStream input, @NotNull PatchBuilderContentInputStream info, long length) {
            if (input == null) {
                StreamWriteFileContentWithExtensions.$$$reportNull$$$0(0);
            }
            if (info == null) {
                StreamWriteFileContentWithExtensions.$$$reportNull$$$0(1);
            }
            super(input, length);
            this.myInfo = info;
        }

        @Nullable
        public String getContentHash() {
            return this.myInfo.getContentHash();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "input";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/vcs/patches/PatchBuilderImpl$StreamWriteFileContentWithExtensions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StreamWriteFileContent
    implements LowLevelPatchBuilder.WriteFileContent {
        private final InputStream myInput;
        private final long myLength;

        public StreamWriteFileContent(@NotNull InputStream input, long length) {
            if (input == null) {
                StreamWriteFileContent.$$$reportNull$$$0(0);
            }
            this.myInput = input;
            this.myLength = length;
        }

        @Override
        public void write(@NotNull OutputStream output) throws IOException {
            if (output == null) {
                StreamWriteFileContent.$$$reportNull$$$0(1);
            }
            TCStreamUtil.writeBinary((InputStream)this.myInput, (long)this.myLength, (OutputStream)output);
            output.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/vcs/patches/PatchBuilderImpl$StreamWriteFileContent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

