/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import com.intellij.openapi.util.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.EventListener;
import java.util.List;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.vcs.patches.FSUndoPatchBuilder;
import jetbrains.buildServer.vcs.patches.LocalFileUtil;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.PatchException;
import jetbrains.buildServer.vcs.patches.PatchListener;
import jetbrains.buildServer.vcs.patches.Patcher;
import jetbrains.buildServer.vcs.patches.PatcherErrorHandler;
import jetbrains.buildServer.vcs.patches.PatcherEventDispatcher;
import jetbrains.buildServer.vcs.patches.UndoAbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.UndoSupportingPatcher;
import jetbrains.buildServer.vcs.patches.diff.BinaryFilePatch;
import jetbrains.buildServer.vcs.patches.diff.FilePatch;
import jetbrains.buildServer.vcs.patches.diff.PatchReader;
import jetbrains.buildServer.vcs.patches.diff.PatchSyntaxException;
import jetbrains.buildServer.vcs.patches.diff.TextFilePatch;
import jetbrains.buildServer.vcs.patches.diff.apply.ApplyPatchStatus;
import jetbrains.buildServer.vcs.patches.diff.apply.GenericPatchApplier;
import jetbrains.buildServer.vcs.patches.store.RandomAccessFileStoreWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffUndoSupportingPatcher
implements UndoSupportingPatcher,
PatcherEventDispatcher {
    public static final String SERVER_FAIL_PATCH_CLUE = "SERVER_FAIL: ";
    private final EventDispatcher<PatchListener> myDispatcher;
    private final InputStream myStream;
    private final FSUndoPatchBuilder myUndo;
    private final LocalFileUtil myLocalFile;
    private final PatcherErrorHandlerFactory myErrorHandler;
    private final UndoAbstractFSPatcherCallback myCallback;
    private volatile boolean interrupted;

    public UnifiedDiffUndoSupportingPatcher(@NotNull InputStream stream, @NotNull File undoPatchTmp, @NotNull File workingDirectory, @NotNull PatcherErrorHandlerFactory errorHandler, final @NotNull Closeable undoClosableResource) throws IOException {
        if (stream == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(0);
        }
        if (undoPatchTmp == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(2);
        }
        if (errorHandler == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(3);
        }
        if (undoClosableResource == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(4);
        }
        this.myDispatcher = EventDispatcher.create(PatchListener.class);
        this.interrupted = false;
        this.myStream = stream;
        this.myLocalFile = new LocalFileUtil(workingDirectory);
        this.myErrorHandler = errorHandler;
        this.myUndo = new FSUndoPatchBuilder(new RandomAccessFileStoreWriter(undoPatchTmp)){

            @Override
            protected void revertPatchClosed() {
                super.revertPatchClosed();
                try {
                    undoClosableResource.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.myCallback = new UndoAbstractFSPatcherCallback(this.myUndo, this.myErrorHandler.create());
    }

    @Override
    @NotNull
    public Patcher createUndoPatcher() throws IOException {
        Patcher patcher = this.myUndo.createUndoPatcher(this.myErrorHandler.create());
        if (patcher == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(5);
        }
        return patcher;
    }

    @Override
    public boolean needUndoAfterPatchFail() {
        return true;
    }

    public void applyPatch() throws IOException {
        List<FilePatch> patchers;
        String resourceText = null;
        try {
            resourceText = StreamUtil.readText((InputStream)this.myStream);
            PatchReader patchReader = new PatchReader(resourceText, true);
            patchReader.parseAllPatches();
            patchers = patchReader.getAllPatches();
        }
        catch (PatchSyntaxException e) {
            if (resourceText.startsWith(SERVER_FAIL_PATCH_CLUE)) {
                String msg = "Cannot apply patch: " + resourceText.substring(SERVER_FAIL_PATCH_CLUE.length());
                this.patchFailed(msg);
                throw new PatchException(msg);
            }
            this.patchFailed("Couldn't read unified diff patches: " + e.getMessage());
            throw new PatchException("Couldn't read unified diff patches", e);
        }
        finally {
            this.myStream.close();
        }
        try {
            for (FilePatch patcher : patchers) {
                boolean moved;
                GenericPatchApplier.AppliedPatch apply;
                if (this.interrupted) {
                    return;
                }
                File file = this.myLocalFile.getFile(patcher.getBeforeName());
                if (patcher.isDeletedFile()) {
                    this.myCallback.deleteFile(file, false, file.exists() && file.isFile());
                    ((PatchListener)this.myDispatcher.getMulticaster()).fileOrDirectoryDeleted(file);
                    continue;
                }
                if (patcher.isNewFile()) {
                    apply = this.applyAndCheck(null, patcher);
                    this.myCallback.replaceBinary(file, apply.patchedText.length(), true, this.content(apply.patchedText));
                    ((PatchListener)this.myDispatcher.getMulticaster()).fileOrDirectoryChanged(file);
                    continue;
                }
                if (!file.exists()) {
                    throw new PatchException("modified file " + patcher.getBeforeName() + " does not exist");
                }
                if (file.isDirectory()) {
                    throw new PatchException("modified file " + patcher.getBeforeName() + " is a directory");
                }
                apply = this.applyAndCheck(file, patcher);
                File newFile = this.myLocalFile.getFile(patcher.getAfterName());
                boolean bl = moved = !file.getPath().equals(newFile.getPath());
                if (moved) {
                    this.myCallback.deleteFile(file, false, true);
                    ((PatchListener)this.myDispatcher.getMulticaster()).fileOrDirectoryRenamed(file);
                }
                this.myCallback.replaceBinary(newFile, apply.patchedText.length(), moved, this.content(apply.patchedText));
                ((PatchListener)this.myDispatcher.getMulticaster()).fileOrDirectoryChanged(newFile);
            }
        }
        catch (IOException e) {
            this.patchFailed("Couldn't apply unified diff patches: " + e.getMessage());
            throw e;
        }
        this.patchSucceeded();
    }

    private void patchFailed(@NotNull String message) {
        if (message == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(6);
        }
        ((PatchListener)this.myDispatcher.getMulticaster()).patchFailed(message);
    }

    private void patchSucceeded() {
        ((PatchListener)this.myDispatcher.getMulticaster()).patchFinished("");
    }

    private GenericPatchApplier.AppliedPatch applyAndCheck(@Nullable File file, @NotNull FilePatch patcher) throws IOException {
        if (patcher == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(7);
        }
        if (patcher instanceof BinaryFilePatch) {
            BinaryFilePatch binary = (BinaryFilePatch)patcher;
            if (binary.getAfterContent() == null) {
                throw new PatchException("binary patch content is null for file " + patcher.getBeforeName());
            }
            return new GenericPatchApplier.AppliedPatch(new String(binary.getAfterContent()), ApplyPatchStatus.SUCCESS);
        }
        if (patcher instanceof TextFilePatch) {
            TextFilePatch text;
            String beforeText = file != null ? FileUtil.readText((File)file) : "";
            GenericPatchApplier.AppliedPatch apply = GenericPatchApplier.apply(beforeText, (text = (TextFilePatch)patcher).getHunks());
            if (apply == null || apply.status != ApplyPatchStatus.SUCCESS) {
                throw new PatchException(this.failApplyStatusMessage(apply, patcher.getBeforeName()));
            }
            return apply;
        }
        throw new PatchException("unified diff patch applier met empty text patch");
    }

    private LowLevelPatcherListener.ReadFileContent content(final @NotNull String content) {
        if (content == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(8);
        }
        return new LowLevelPatcherListener.ReadFileContent(){

            @Override
            @NotNull
            public InputStream getInputStream() {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes(Charset.defaultCharset()));
                if (byteArrayInputStream == null) {
                    2.$$$reportNull$$$0(0);
                }
                return byteArrayInputStream;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/patches/UnifiedDiffUndoSupportingPatcher$2", "getInputStream"));
            }
        };
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void close() {
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.myUndo.setPreserveTimestamp(preserveTimestamp);
    }

    public void setPreverseReadonlyAttribute(boolean preverseReadonlyAttribute) {
        this.myUndo.setPreverseReadonlyAttribute(preverseReadonlyAttribute);
    }

    @Override
    public void addListener(@NotNull PatchListener listener) {
        if (listener == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeListener(@NotNull PatchListener listener) {
        if (listener == null) {
            UnifiedDiffUndoSupportingPatcher.$$$reportNull$$$0(10);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private String failApplyStatusMessage(GenericPatchApplier.AppliedPatch applied, String fileName) {
        if (applied == null) {
            return "Can not calculate a status for patch for " + fileName;
        }
        ApplyPatchStatus status = applied.status;
        switch (status) {
            case ALREADY_APPLIED: {
                return "The patch for " + fileName + " is already applied";
            }
            case FAILURE: {
                return "Fail to apply the patch for " + fileName;
            }
            case PARTIAL: {
                return "Can not apply the full path for " + fileName;
            }
        }
        return "Status of applying patch on file " + fileName + " is " + (Object)((Object)status);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoPatchTmp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoClosableResource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/UnifiedDiffUndoSupportingPatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/UnifiedDiffUndoSupportingPatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUndoPatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchFailed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyAndCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "content";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PatcherErrorHandlerFactory {
        public PatcherErrorHandler create();
    }
}

