/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff;

import java.io.ByteArrayOutputStream;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.patches.diff.BinaryEncoder;
import jetbrains.buildServer.vcs.patches.diff.BinaryFilePatch;
import jetbrains.buildServer.vcs.patches.diff.FilePatch;
import jetbrains.buildServer.vcs.patches.diff.FileStatus;
import jetbrains.buildServer.vcs.patches.diff.PatchSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BinaryPatchContentParser {
    @NonNls
    private static final Pattern ourGitBinaryLineSize = Pattern.compile("literal\\s+(\\d+)\\s*");

    public static FilePatch readGitBinaryFormatPatch(@NotNull ListIterator<String> iterator, @NotNull FileStatus parsedStatus) throws PatchSyntaxException {
        if (iterator == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(0);
        }
        if (parsedStatus == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream afterStream = new ByteArrayOutputStream();
        ByteArrayOutputStream beforeStream = new ByteArrayOutputStream();
        BinaryPatchContentParser.checkNotEOF(iterator);
        try {
            String next = iterator.next();
            Matcher literalMatcher = ourGitBinaryLineSize.matcher(next);
            if (literalMatcher.matches()) {
                BinaryPatchContentParser.getContent(iterator, afterStream, literalMatcher.group(1));
            }
            if (iterator.hasNext() && parsedStatus != FileStatus.ADDED) {
                next = iterator.next();
                if (StringUtil.isEmptyOrSpaces((String)next) && iterator.hasNext()) {
                    next = iterator.next();
                }
                if (literalMatcher.reset(next).matches()) {
                    BinaryPatchContentParser.getContent(iterator, beforeStream, literalMatcher.group(1));
                } else {
                    iterator.previous();
                }
            }
            return new BinaryFilePatch(parsedStatus == FileStatus.ADDED ? null : beforeStream.toByteArray(), parsedStatus == FileStatus.DELETED ? null : afterStream.toByteArray());
        }
        catch (Exception e) {
            throw new PatchSyntaxException(iterator.previousIndex(), e.getMessage());
        }
    }

    private static void getContent(@NotNull ListIterator<String> iterator, @NotNull ByteArrayOutputStream afterStream, @NotNull String lenFromLiteral) throws EofBinaryPatchSyntaxException, BinaryEncoder.BinaryPatchException {
        if (iterator == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(2);
        }
        if (afterStream == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(3);
        }
        if (lenFromLiteral == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(4);
        }
        long afterSize = Long.parseLong(lenFromLiteral);
        BinaryPatchContentParser.checkNotEOF(iterator);
        BinaryEncoder.decode(iterator, afterSize, afterStream);
    }

    private static void checkNotEOF(@NotNull ListIterator<String> iterator) throws EofBinaryPatchSyntaxException {
        if (iterator == null) {
            BinaryPatchContentParser.$$$reportNull$$$0(5);
        }
        if (!iterator.hasNext()) {
            throw new EofBinaryPatchSyntaxException(iterator.previousIndex());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lenFromLiteral";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/patches/diff/BinaryPatchContentParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readGitBinaryFormatPatch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNotEOF";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class EofBinaryPatchSyntaxException
    extends PatchSyntaxException {
        public EofBinaryPatchSyntaxException(int line) {
            super(line, "Unexpected end of binary patch");
        }
    }
}

