/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.vcs.patches.diff.PatchFileHeaderInfo;
import jetbrains.buildServer.vcs.patches.diff.VcsUserImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PatchFileHeaderParser {
    @NonNls
    private static final Pattern ourBaseRevisionPattern = Pattern.compile("From\\s+([0-9a-fA-F]+)\\s+.*");
    @NonNls
    private static final Pattern ourAuthorPattern = Pattern.compile("From:\\s+(.*?)\\s*(?:<(.*)>\\s*)?");
    @NonNls
    private static final Pattern ourSubjectPattern = Pattern.compile("Subject:(?:\\s+\\[PATCH.*])?\\s*(.+)");
    @NonNls
    private static final Pattern ourHeaderEndMarker = Pattern.compile("---\\s*");

    public static PatchFileHeaderInfo parseHeader(Iterator<String> iterator, int maxElements) {
        String lineSeparator = "\n";
        StringBuilder message = new StringBuilder();
        VcsUserImpl author = null;
        String revision = null;
        boolean treatAllAsMessageLine = false;
        int i = 0;
        while (iterator.hasNext() && i++ < maxElements) {
            String curLine = iterator.next();
            Matcher revisionMatcher = ourBaseRevisionPattern.matcher(curLine);
            Matcher authorMatcher = ourAuthorPattern.matcher(curLine);
            Matcher subjectMatcher = ourSubjectPattern.matcher(curLine);
            Matcher endHeaderMatcher = ourHeaderEndMarker.matcher(curLine);
            if (endHeaderMatcher.matches()) break;
            if (treatAllAsMessageLine) {
                message.append(lineSeparator).append(curLine);
                continue;
            }
            if (revisionMatcher.matches()) {
                revision = revisionMatcher.group(1);
                continue;
            }
            if (authorMatcher.matches()) {
                author = new VcsUserImpl(authorMatcher.group(1), PatchFileHeaderParser.chooseNotNull(authorMatcher.group(2), ""));
                continue;
            }
            if (!subjectMatcher.matches()) continue;
            message.append(subjectMatcher.group(1));
            treatAllAsMessageLine = true;
        }
        return new PatchFileHeaderInfo(message.toString().trim(), author, revision);
    }

    private static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }
}

