/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.helpers;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.vcs.patches.LowLevelPatcher;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import org.jetbrains.annotations.NotNull;

public class ListPatchCommands {
    public static void main(String[] args) {
        System.out.println("TeamCity extract files from patch utility ");
        System.out.println();
        System.out.println("Usage: program <path to patch file>");
        if (args.length != 1) {
            System.exit(-1);
            return;
        }
        File patch = new File(args[0]);
        if (!patch.exists() || !patch.isFile()) {
            System.out.println("Failed to read file " + args[0]);
            System.exit(-2);
            return;
        }
        try {
            ListPatchCommands.dumpFiles(patch);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public static void dumpFiles(@NotNull File patch) throws IOException {
        if (patch == null) {
            ListPatchCommands.$$$reportNull$$$0(0);
        }
        System.out.println("Opening file: " + patch);
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(patch));
        LowLevelPatcher patcher = new LowLevelPatcher(dataInputStream);
        try {
            patcher.applyPatch(new LowLevelPatcherListener(){

                private void log(String s) {
                    System.out.println(s);
                }

                @Override
                public void delete(@NotNull String file, boolean isFile, boolean emptyParent) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.log("delete: " + file + ", isFile: " + isFile + ", emptyParent: " + emptyParent);
                }

                @Override
                public void rename(@NotNull String oldName, @NotNull String newName, boolean isFile, boolean emptyParent) {
                    if (oldName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (newName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.log("rename: " + oldName + " to  " + newName + ", isFile: " + isFile + ", emptyParent: " + emptyParent);
                }

                @Override
                public void setTimeStamp(@NotNull String file, long timestamp) {
                    if (file == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.log("timestamp: " + file + ", timestamp: " + timestamp);
                }

                @Override
                public void setFileMode(@NotNull String file, @NotNull String mode) {
                    if (file == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (mode == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    this.log("set file mode: " + file + ", mode: " + mode);
                }

                @Override
                public void addDirectory(@NotNull String file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    this.log("add dir: " + file);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void changeBinary(@NotNull String file, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) {
                    void create;
                    if (file == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (content == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    this.log("change binary: " + file + ", length: " + length + ", create: " + (boolean)create);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void changeTextUsingBytes(@NotNull String file, @NotNull byte[] lineSeparator, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) {
                    void create;
                    if (file == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    if (lineSeparator == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    if (content == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    this.log("change text: " + file + ", length: " + length + ", create: " + (boolean)create);
                }

                @Override
                public void exit(@NotNull String message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    this.log("exit: " + message);
                }

                @Override
                public void fail(@NotNull String message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    this.log("fail: " + message);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldName";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newName";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "mode";
                            break;
                        }
                        case 8: 
                        case 11: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "content";
                            break;
                        }
                        case 10: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "lineSeparator";
                            break;
                        }
                        case 12: 
                        case 13: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                    }
                    objectArray2[1] = "jetbrains/buildServer/vcs/patches/helpers/ListPatchCommands$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "delete";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "rename";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setTimeStamp";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setFileMode";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addDirectory";
                            break;
                        }
                        case 7: 
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "changeBinary";
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "changeTextUsingBytes";
                            break;
                        }
                        case 12: {
                            objectArray = objectArray2;
                            objectArray2[2] = "exit";
                            break;
                        }
                        case 13: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fail";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        finally {
            FileUtil.close((Closeable)dataInputStream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "jetbrains/buildServer/vcs/patches/helpers/ListPatchCommands", "dumpFiles"));
    }
}

