/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.BuildPatchByIncludeRules;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.CollectChangesByIncludeRules;
import jetbrains.buildServer.vcs.CollectSingleStateChangesByIncludeRules;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.IncludeRuleChangeCollector;
import jetbrains.buildServer.vcs.IncludeRulePatchBuilder;
import jetbrains.buildServer.vcs.ModificationData;
import jetbrains.buildServer.vcs.PatchBuilderFileNamesCorrector;
import jetbrains.buildServer.vcs.VcsChange;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import jetbrains.buildServer.vcs.VcsException;
import jetbrains.buildServer.vcs.VcsIncludeRulesException;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.patches.PatchBuilder;
import jetbrains.vcs.api.data.VcsRepositoryState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPluginUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ModificationData> collectBuildChanges(@NotNull VcsRoot root, @NotNull String fromVersion, @Nullable String toVersion, @NotNull CheckoutRules commonRule, @NotNull CollectChangesByIncludeRules collector) throws VcsException {
        if (root == null) {
            VcsPluginUtil.$$$reportNull$$$0(0);
        }
        if (fromVersion == null) {
            VcsPluginUtil.$$$reportNull$$$0(1);
        }
        if (commonRule == null) {
            VcsPluginUtil.$$$reportNull$$$0(2);
        }
        if (collector == null) {
            VcsPluginUtil.$$$reportNull$$$0(3);
        }
        final IncludeRuleChangeCollector changeCollector = collector.getChangeCollector(root, fromVersion, toVersion);
        final ArrayList<ModificationData> dataList = new ArrayList<ModificationData>();
        try {
            VcsPluginUtil.processIncludeRules(commonRule, new IncludeRuleHandler(){

                @Override
                public void handle(IncludeRule includeRule) throws VcsException {
                    for (ModificationData change : changeCollector.collectChanges(includeRule)) {
                        dataList.add(VcsPluginUtil.processRelativePaths(change, includeRule));
                    }
                }
            });
        }
        finally {
            changeCollector.dispose();
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ModificationData> collectBuildChanges(@NotNull VcsRoot root, @NotNull String fromVersion, @Nullable String toVersion, @NotNull CheckoutRules commonRule, @NotNull CollectSingleStateChangesByIncludeRules collector) throws VcsException {
        if (root == null) {
            VcsPluginUtil.$$$reportNull$$$0(4);
        }
        if (fromVersion == null) {
            VcsPluginUtil.$$$reportNull$$$0(5);
        }
        if (commonRule == null) {
            VcsPluginUtil.$$$reportNull$$$0(6);
        }
        if (collector == null) {
            VcsPluginUtil.$$$reportNull$$$0(7);
        }
        final IncludeRuleChangeCollector changeCollector = collector.getChangeCollector(root, fromVersion, toVersion);
        final ArrayList<ModificationData> dataList = new ArrayList<ModificationData>();
        try {
            VcsPluginUtil.processIncludeRules(commonRule, new IncludeRuleHandler(){

                @Override
                public void handle(IncludeRule includeRule) throws VcsException {
                    for (ModificationData change : changeCollector.collectChanges(includeRule)) {
                        dataList.add(VcsPluginUtil.processRelativePaths(change, includeRule));
                    }
                }
            });
        }
        finally {
            changeCollector.dispose();
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processIncludeRules(CheckoutRules rules, IncludeRuleHandler processor) throws VcsIncludeRulesException {
        VcsIncludeRulesException problem = null;
        List rootIncludeRules = rules.getRootIncludeRules();
        int includeRulesCount = rootIncludeRules.size();
        for (int i = 0; i < includeRulesCount; ++i) {
            IncludeRule includeRule = (IncludeRule)rootIncludeRules.get(i);
            Disposable threadNameCookie = NamedThreadFactory.patchThreadName((String)String.format("Processing include rule: \"%s\" (%d of %d)", includeRule, i + 1, includeRulesCount));
            try {
                processor.handle(includeRule);
                continue;
            }
            catch (VcsException e) {
                Loggers.VCS.infoAndDebugDetails(String.format("Problem collecting changes for include rule %s: %s, will be skipped next time.", includeRule, e.getMessage()), (Throwable)e);
                if (problem == null) {
                    problem = new VcsIncludeRulesException(includeRule, e);
                    continue;
                }
                problem.addProblem(includeRule, e);
                continue;
            }
            finally {
                threadNameCookie.dispose();
            }
        }
        if (problem != null) {
            throw problem;
        }
    }

    @NotNull
    public static ModificationData processRelativePaths(@NotNull ModificationData change, @NotNull IncludeRule includeRule) {
        if (change == null) {
            VcsPluginUtil.$$$reportNull$$$0(8);
        }
        if (includeRule == null) {
            VcsPluginUtil.$$$reportNull$$$0(9);
        }
        ArrayList<VcsChange> fileChanges = new ArrayList<VcsChange>();
        for (VcsChangeInfo vcsChangeInfo : change.getChanges()) {
            fileChanges.add(new VcsChange(vcsChangeInfo.getType(), vcsChangeInfo.getChangeTypeName(), vcsChangeInfo.getFileName(), includeRule.createFullPath(vcsChangeInfo.getRelativeFileName()), vcsChangeInfo.getBeforeChangeRevisionNumber(), vcsChangeInfo.getAfterChangeRevisionNumber()));
        }
        ModificationData modificationData = ModificationData.substituteFiles(change, fileChanges);
        if (modificationData == null) {
            VcsPluginUtil.$$$reportNull$$$0(10);
        }
        return modificationData;
    }

    @Nullable
    public static String removeFromAddTo(@NotNull String path, @NotNull IncludeRule includeRule) {
        if (path == null) {
            VcsPluginUtil.$$$reportNull$$$0(11);
        }
        if (includeRule == null) {
            VcsPluginUtil.$$$reportNull$$$0(12);
        }
        if (path.startsWith(includeRule.getFrom())) {
            return includeRule.map(path);
        }
        path = StringUtil.removeLeadingSlash((String)path);
        if (includeRule.getTo().length() > 0) {
            path = includeRule.getTo() + "/" + path;
        }
        path = StringUtil.removeTailingSlash((String)path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildPatch(@NotNull VcsRoot root, @Nullable String fromVersion, @NotNull String toVersion, @NotNull PatchBuilder builder, @NotNull CheckoutRules checkoutRules, @NotNull BuildPatchByIncludeRules patcher) throws IOException, VcsException {
        if (root == null) {
            VcsPluginUtil.$$$reportNull$$$0(13);
        }
        if (toVersion == null) {
            VcsPluginUtil.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            VcsPluginUtil.$$$reportNull$$$0(15);
        }
        if (checkoutRules == null) {
            VcsPluginUtil.$$$reportNull$$$0(16);
        }
        if (patcher == null) {
            VcsPluginUtil.$$$reportNull$$$0(17);
        }
        IncludeRulePatchBuilder patchBuilder = patcher.getPatchBuilder(root, fromVersion, toVersion);
        try {
            PatchBuilderFileNamesCorrector fileNamesCorrector = new PatchBuilderFileNamesCorrector(builder);
            for (IncludeRule rule : checkoutRules.getRootIncludeRules()) {
                fileNamesCorrector.setWorkingMode_WithIncludeRule(rule);
                fileNamesCorrector.setWorkingDirectory(new File("."), false);
                patchBuilder.buildPatch((PatchBuilder)fileNamesCorrector, rule);
            }
        }
        finally {
            patchBuilder.dispose();
        }
    }

    @NotNull
    public static String getRepositoryVersion(@NotNull VcsRepositoryState state) {
        if (state == null) {
            VcsPluginUtil.$$$reportNull$$$0(18);
        }
        if (state.getBranchRevisions().size() > 1) {
            throw new IllegalArgumentException("Incorrect repository state " + state + ", single version repository state is required");
        }
        if (state.isEmpty()) {
            throw new IllegalArgumentException("Repository state has no branches");
        }
        String string = state.getBranchRevisions().entrySet().iterator().next().getValue();
        if (string == null) {
            VcsPluginUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static boolean shouldDebugVcsCallsFor(@NotNull String fullPath) {
        if (fullPath == null) {
            VcsPluginUtil.$$$reportNull$$$0(20);
        }
        if (!Loggers.VCS.isDebugEnabled()) {
            return false;
        }
        String pathToDebug = TeamCityProperties.getPropertyOrNull((String)"teamcity.vcs.debug.path");
        return pathToDebug != null && fullPath.contains(pathToDebug);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromVersion";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonRule";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRule";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/utils/VcsPluginUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toVersion";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutRules";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/utils/VcsPluginUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processRelativePaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildChanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processRelativePaths";
                break;
            }
            case 10: 
            case 19: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFromAddTo";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldDebugVcsCallsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IncludeRuleHandler {
        public void handle(IncludeRule var1) throws VcsException;
    }
}

