/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.io.UnsupportedEncodingException;
import jetbrains.buildServer.util.ExceptionUtil;
import org.apache.commons.codec.binary.Base64;

public class BuildAuthUtil {
    private static final String TEAM_CITY_BUILD_ID_PREFIX = "TeamCityBuildId=";

    private BuildAuthUtil() {
    }

    public static String makeUserId(long buildId) {
        return TEAM_CITY_BUILD_ID_PREFIX + buildId;
    }

    public static long getBuildId(String userId) {
        if (userId.length() < TEAM_CITY_BUILD_ID_PREFIX.length()) {
            return -1L;
        }
        String buildIdStr = userId.substring(TEAM_CITY_BUILD_ID_PREFIX.length());
        try {
            return Long.parseLong(buildIdStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean isAuthenticationByBuildId(String userId) {
        return userId.startsWith(TEAM_CITY_BUILD_ID_PREFIX);
    }

    public static String makeAuthorizationHeaderValue(long buildId, String accessCode) {
        String userId = BuildAuthUtil.makeUserId(buildId);
        try {
            byte[] authorization = Base64.encodeBase64((byte[])(userId + ":" + accessCode).getBytes("US-ASCII"));
            return "Basic " + new String(authorization, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            ExceptionUtil.rethrowAsRuntimeException(e);
            return null;
        }
    }
}

