/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.BuildProblemTypes;
import jetbrains.buildServer.messages.ObjectSizeEstimate;

public class BuildProblemData
implements BuildProblemTypes,
ObjectSizeEstimate {
    public static final int MAX_IDENTITY_LENGTH = 60;
    public static final int MAX_TYPE_LENGTH = 80;
    public static final int MAX_DESCRIPTION_LENGTH = 4000;
    public static final int MAX_ATTR_NAME_LENGTH = 60;
    public static final int MAX_ATTR_VALUE_LENGTH = 2000;
    public static final String ADDITIONAL_DATA_KEY = "additionalData";
    public static final String INIT_ERROR_PREFIX = "Error adding build problem, build problem ignored: ";
    private final String myIdentity;
    private final String myType;
    private final String myDescription;
    private final Map myAttributes;

    public static BuildProblemData createBuildProblem(String identity, String type, String description, String additionalData) {
        return new BuildProblemData(identity, type, description, additionalData);
    }

    public static BuildProblemData createBuildProblem(String identity, String type, String description) {
        return BuildProblemData.createBuildProblem(identity, type, description, null);
    }

    public long getEstimatedSize() {
        long res = this.myIdentity.length() + this.myType.length() + this.myDescription.length();
        if (this.myAttributes != null) {
            for (Object value : this.myAttributes.values()) {
                if (!(value instanceof String)) continue;
                res += (long)((String)value).length();
            }
        }
        return res;
    }

    BuildProblemData(String identity, String type, String description, Map attributes) throws IllegalArgumentException {
        if (identity == null) {
            this.throwException("identity mustn't be null");
        }
        if (type == null) {
            this.throwException("type mustn't be null");
        }
        if (description == null) {
            this.throwException("description mustn't be null");
        }
        if (identity.length() == 0) {
            this.throwException("identity mustn't be empty");
        }
        if (type.length() == 0) {
            this.throwException("type mustn't be empty");
        }
        if (identity.length() > 60) {
            this.throwException("identity mustn't be longer than 60 characters: " + identity);
        }
        if (type.length() > 80) {
            this.throwException("type mustn't be longer than 80 characters: " + type);
        }
        this.checkAttributes(attributes);
        this.myIdentity = identity;
        this.myType = type;
        this.myDescription = description;
        this.myAttributes = attributes == null ? new HashMap(0) : new HashMap(attributes);
    }

    private BuildProblemData(String identity, String type, String description, String additionalData) throws IllegalArgumentException {
        this(identity, type, description, additionalData == null ? null : Collections.singletonMap(ADDITIONAL_DATA_KEY, additionalData));
    }

    private void checkAttributes(Map attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry e : attributes.entrySet()) {
            String name = (String)e.getKey();
            String value = (String)e.getValue();
            if (name == null) {
                this.throwException("attribute name mustn't be null");
            }
            if (value == null) {
                this.throwException("attribute value mustn't be null");
            }
            if (name.length() == 0) {
                this.throwException("attribute name mustn't be empty");
            }
            if (name.length() > 60) {
                this.throwException("attribute name mustn't be longer than 2000 characters: " + name);
            }
            if (value.length() <= 2000) continue;
            this.throwException("attribute value mustn't be longer than 2000 characters: " + value);
        }
    }

    private void throwException(String message) throws IllegalArgumentException {
        throw new IllegalArgumentException(INIT_ERROR_PREFIX + message);
    }

    public String getType() {
        return this.myType;
    }

    public String getIdentity() {
        return this.myIdentity;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getAdditionalData() {
        return (String)this.myAttributes.get(ADDITIONAL_DATA_KEY);
    }

    Map getAttributes() {
        return this.myAttributes;
    }

    public String toString() {
        return BuildProblemData.asString(this.myIdentity, this.myType, this.myDescription);
    }

    public static String asString(String identity, String type, String description) {
        return "BuildProblemData{myIdentity=" + identity + ", myType='" + type + '\'' + ", myDescription='" + description + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildProblemData)) {
            return false;
        }
        BuildProblemData that = (BuildProblemData)o;
        return this.myIdentity.equals(that.myIdentity);
    }

    public int hashCode() {
        return this.myIdentity.hashCode();
    }
}

