/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.ProcessTimeoutException;
import jetbrains.buildServer.SimpleCommandLineProcessRunner;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.TimedExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineExecutor {
    @NotNull
    private static final TimedExecutor ourExecutor = TimedExecutor.withCachedThreadPool("CommandLineExecutor pooled thread", 0L);
    @NotNull
    private final ExecResult myRetVal;
    @NotNull
    private final GeneralCommandLine myCommandLine;
    private volatile Process myProc;
    private volatile StreamGobbler myErrorGobbler;
    private volatile StreamGobbler myOutputGobbler;
    private volatile OutputStream myOutputStream;
    private static final Logger LOG = Logger.getInstance((String)CommandLineExecutor.class.getName());

    private static int getTimeOutValue() {
        return TeamCityProperties.getInteger("teamcity.execution.timeout", 90);
    }

    public CommandLineExecutor(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            CommandLineExecutor.$$$reportNull$$$0(0);
        }
        this.myCommandLine = commandLine;
        this.myRetVal = new ExecResult(SimpleCommandLineProcessRunner.getCharset(commandLine));
    }

    @Nullable
    public ExecResult runProcess(int executionTimeoutSeconds) throws ExecutionException {
        return ourExecutor.execute((long)executionTimeoutSeconds * Dates.ONE_SECOND, new Callable<ExecResult>(){

            @Override
            public ExecResult call() throws Exception {
                return CommandLineExecutor.this.runProcess();
            }
        });
    }

    @NotNull
    public ExecResult runProcess() throws ExecutionException {
        ExecResult execResult = this.runProcess(null, CommandLineExecutor.getTimeOutValue());
        if (execResult == null) {
            CommandLineExecutor.$$$reportNull$$$0(1);
        }
        return execResult;
    }

    @NotNull
    public ExecResult runProcess(@Nullable byte[] processInput, int idleTimeout) throws ExecutionException {
        ExecResult execResult = this.runProcess(processInput, idleTimeout, new ByteArrayOutputStream(), new ByteArrayOutputStream());
        if (execResult == null) {
            CommandLineExecutor.$$$reportNull$$$0(2);
        }
        return execResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecResult runProcess(@Nullable byte[] processInput, int idleTimeout, @NotNull ByteArrayOutputStream stdoutBuffer, @NotNull ByteArrayOutputStream stderrBuffer) throws ExecutionException {
        if (stdoutBuffer == null) {
            CommandLineExecutor.$$$reportNull$$$0(3);
        }
        if (stderrBuffer == null) {
            CommandLineExecutor.$$$reportNull$$$0(4);
        }
        long start = System.nanoTime();
        this.myProc = this.myCommandLine.createProcess();
        String commandDetails = this.myCommandLine.getCommandLineString();
        this.myErrorGobbler = new StreamGobbler(this.myProc.getErrorStream(), null, "StdErr for " + commandDetails, stderrBuffer);
        this.myOutputGobbler = new StreamGobbler(this.myProc.getInputStream(), null, "StdOut for " + commandDetails, stdoutBuffer);
        this.myErrorGobbler.start();
        this.myOutputGobbler.start();
        if (processInput != null) {
            try {
                try {
                    this.getOutputStream().write(processInput);
                }
                finally {
                    this.getOutputStream().close();
                }
            }
            catch (Throwable e) {
                this.myRetVal.setException(e);
                this.destroyProcess();
            }
        }
        ExecResult execResult = this.waitFor(idleTimeout);
        execResult.setElapsedTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        ExecResult execResult2 = execResult;
        if (execResult2 == null) {
            CommandLineExecutor.$$$reportNull$$$0(5);
        }
        return execResult2;
    }

    public OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            this.myOutputStream = this.myProc.getOutputStream();
        }
        return this.myOutputStream;
    }

    @NotNull
    public ExecResult waitFor() {
        ExecResult execResult = this.waitFor(CommandLineExecutor.getTimeOutValue());
        if (execResult == null) {
            CommandLineExecutor.$$$reportNull$$$0(6);
        }
        return execResult;
    }

    @NotNull
    private ExecResult waitFor(int idleTimeoutSeconds) {
        String commandDetails = this.myCommandLine.getCommandLineString();
        try {
            this.myRetVal.setOutputGobbler(this.myOutputGobbler);
            this.myRetVal.setErrorGobbler(this.myErrorGobbler);
            this.myRetVal.setExitCode(CommandLineExecutor.waitForProcess(this.myProc, commandDetails, this.myErrorGobbler, this.myOutputGobbler, idleTimeoutSeconds));
        }
        catch (Throwable e) {
            if (e instanceof ProcessTimeoutException) {
                ((ProcessTimeoutException)e).setProcessName(commandDetails);
            }
            this.myRetVal.setException(e);
        }
        ExecResult execResult = this.myRetVal;
        if (execResult == null) {
            CommandLineExecutor.$$$reportNull$$$0(7);
        }
        return execResult;
    }

    public Process getProcess() {
        return this.myProc;
    }

    public void destroyProcess() {
        if (this.myOutputGobbler != null) {
            this.myOutputGobbler.notifyProcessExit();
        }
        if (this.myErrorGobbler != null) {
            this.myErrorGobbler.notifyProcessExit();
        }
        if (this.myProc != null) {
            try {
                FileUtil.closeAll(this.myProc.getInputStream(), this.myProc.getErrorStream(), this.myProc.getOutputStream());
            }
            finally {
                CommandLineExecutor.destroySilently(this.myProc, this.myCommandLine.getCommandLineString());
            }
        }
    }

    public static void finalizeAll(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        CommandLineExecutor.finalizeAll(proc, errorGobbler, outputGobbler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeAll(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler, @Nullable String actionDetails) throws InterruptedException {
        errorGobbler.notifyProcessExit();
        outputGobbler.notifyProcessExit();
        try {
            try {
                FileUtil.close(proc.getOutputStream());
                CommandLineExecutor.shutdownGobbler(outputGobbler, "stdout", proc.getInputStream());
            }
            finally {
                CommandLineExecutor.shutdownGobbler(errorGobbler, "stderr", proc.getErrorStream());
            }
        }
        finally {
            CommandLineExecutor.destroySilently(proc, actionDetails);
        }
    }

    private static void shutdownGobbler(StreamGobbler gobbler, String name, Closeable stream) throws InterruptedException {
        try {
            LOG.debug("Start waiting for " + name + " collector thread");
            gobbler.join();
            LOG.debug("Finished waiting for " + name + " collector thread");
        }
        finally {
            FileUtil.close(stream);
        }
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, "Wait for process for thread: " + Thread.currentThread().getName(), errorGobbler, outputGobbler, CommandLineExecutor.getTimeOutValue());
    }

    public static int waitForProcess(Process proc, String actionDetails, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, actionDetails, errorGobbler, outputGobbler, CommandLineExecutor.getTimeOutValue());
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler, int idleTimeoutSeconds) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, "Wait for process for thread: " + Thread.currentThread().getName(), errorGobbler, outputGobbler, idleTimeoutSeconds);
    }

    public static int waitForProcess(Process proc, String actionDetails, StreamGobbler errorGobbler, StreamGobbler outputGobbler, int idleTimeoutSeconds) throws InterruptedException {
        AtomicReference<Integer> result = new AtomicReference<Integer>();
        AtomicReference<InterruptedException> ex = new AtomicReference<InterruptedException>();
        LOG.debug("Start waiting for process finishing (" + actionDetails + ")");
        Thread waitThread = CommandLineExecutor.createWaitForProcessThread(proc, actionDetails, errorGobbler, outputGobbler, result, ex);
        waitThread.start();
        long lastReadErr = errorGobbler.getLastActivityTimestamp();
        long lastReadOut = outputGobbler.getLastActivityTimestamp();
        while (true) {
            boolean hasNewOutput = false;
            for (int i = 0; i < 100; ++i) {
                try {
                    waitThread.join(idleTimeoutSeconds * 10);
                }
                catch (InterruptedException e) {
                    waitThread.interrupt();
                    throw e;
                }
                if (ex.get() != null) {
                    throw ex.get();
                }
                if (result.get() != null || (hasNewOutput = CommandLineExecutor.hasNewOutput(errorGobbler, outputGobbler, lastReadErr, lastReadOut))) break;
            }
            if (result.get() != null) break;
            if (!hasNewOutput) {
                waitThread.interrupt();
                throw new ProcessTimeoutException("Timeout exception: the process did not produce output longer than " + idleTimeoutSeconds + " seconds");
            }
            lastReadErr = errorGobbler.getLastActivityTimestamp();
            lastReadOut = outputGobbler.getLastActivityTimestamp();
        }
        LOG.debug("Stop waiting for process finishing (" + actionDetails + ")");
        return result.get();
    }

    private static void destroySilently(@NotNull Process proc, @Nullable String actionDetails) {
        if (proc == null) {
            CommandLineExecutor.$$$reportNull$$$0(8);
        }
        try {
            proc.destroy();
        }
        catch (Throwable e) {
            LOG.warn("Failed to destroy process: " + e.toString() + "(" + actionDetails + ")", e);
        }
    }

    private static boolean hasNewOutput(StreamGobbler errorGobbler, StreamGobbler outputGobbler, long lastReadErr, long lastReadOut) {
        return lastReadErr != errorGobbler.getLastActivityTimestamp() || lastReadOut != outputGobbler.getLastActivityTimestamp();
    }

    private static Thread createWaitForProcessThread(final Process proc, final String actionDetails, final StreamGobbler errorGobbler, final StreamGobbler outputGobbler, final AtomicReference<Integer> result, final AtomicReference<InterruptedException> ex) {
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Integer execResult = null;
                try {
                    execResult = proc.waitFor();
                    LOG.debug("Process.waitFor() finished (" + actionDetails + ")");
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn("Process.waitFor() was interrupted (" + actionDetails + ")");
                    ex.set(e);
                    return;
                }
                finally {
                    try {
                        CommandLineExecutor.finalizeAll(proc, errorGobbler, outputGobbler, actionDetails);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Process finalization was interrupted, abandoned gobbler threads can remain (" + actionDetails + ")");
                    }
                    finally {
                        result.set(execResult);
                    }
                }
            }
        }, NamedThreadUtil.getTcThreadPrefix() + "Wait for process for " + actionDetails);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/CommandLineExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdoutBuffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderrBuffer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/CommandLineExecutor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "waitFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "destroySilently";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

