/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jetbrains.buildServer.ComparisonFailureData;

public class ComparisonFailureUtil {
    private static final String JUNIT_COMPARISON_FAILURE_PREFIX = "expected:<";
    private static final String JUNIT_BUT_WAS = "> but was:<";
    private static final String TNG66_EXPECTED = "expected [";
    private static final String TNG66_BUT_FOUND = "] but found [";
    private static final String TNG66_END = "]";

    public static ComparisonFailureData extractComparisonFailure(Throwable t) {
        Class[] comparisonFailureClasses = ComparisonFailureUtil.getComparisonFailureClasses(t);
        for (int i = 0; i < comparisonFailureClasses.length; ++i) {
            Class cl = comparisonFailureClasses[i];
            if (!cl.isInstance(t)) continue;
            return ComparisonFailureUtil.extractComparisonFailureData(t, cl);
        }
        ComparisonFailureData extracted = ComparisonFailureUtil.getComparisonFailureFromCause(t, comparisonFailureClasses);
        if (extracted != null) {
            return extracted;
        }
        String message = t.getLocalizedMessage();
        if (message != null) {
            extracted = ComparisonFailureUtil.extractComparisonFailureFromAssertionError(message);
            if (extracted != null) {
                return extracted;
            }
            extracted = ComparisonFailureUtil.extractComparisonFailureFromAssertionErrorTestNG6_6(message);
            if (extracted != null) {
                return extracted;
            }
        }
        return null;
    }

    private static ComparisonFailureData extractComparisonFailureFromAssertionError(String message) {
        int expectedIdx = message.indexOf(JUNIT_COMPARISON_FAILURE_PREFIX);
        if (expectedIdx == -1) {
            return null;
        }
        int butWasIdx = message.indexOf(JUNIT_BUT_WAS, expectedIdx + JUNIT_COMPARISON_FAILURE_PREFIX.length());
        if (butWasIdx == -1) {
            return null;
        }
        int endIdx = message.lastIndexOf(62);
        if (endIdx == -1) {
            return null;
        }
        String expected = message.substring(expectedIdx + JUNIT_COMPARISON_FAILURE_PREFIX.length(), butWasIdx);
        String actual = message.substring(butWasIdx + JUNIT_BUT_WAS.length(), endIdx);
        return new ComparisonFailureData(expected, actual);
    }

    private static ComparisonFailureData extractComparisonFailureFromAssertionErrorTestNG6_6(String message) {
        int expectedIndex = message.indexOf(TNG66_EXPECTED);
        if (expectedIndex == -1) {
            return null;
        }
        int butIndex = message.indexOf(TNG66_BUT_FOUND, expectedIndex + TNG66_EXPECTED.length());
        if (butIndex == -1) {
            return null;
        }
        int endIndex = message.lastIndexOf(TNG66_END);
        if (endIndex == -1) {
            return null;
        }
        String expected = message.substring(expectedIndex + TNG66_EXPECTED.length(), butIndex);
        String actual = message.substring(butIndex + TNG66_BUT_FOUND.length(), endIndex);
        return new ComparisonFailureData(expected, actual);
    }

    private static String getActual(Throwable comparisonFailure, Class cl) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureUtil.getFieldValue(comparisonFailure, "fActual", cl);
    }

    private static String getExpected(Throwable comparisonFailure, Class cl) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureUtil.getFieldValue(comparisonFailure, "fExpected", cl);
    }

    private static String getFieldValue(Throwable comparisonFailure, String fieldName, Class cl) throws NoSuchFieldException, IllegalAccessException {
        Field expectedField = cl.getDeclaredField(fieldName);
        expectedField.setAccessible(true);
        return (String)expectedField.get(comparisonFailure);
    }

    private static Class[] getComparisonFailureClasses(Throwable t) {
        Collection classLoaders = ComparisonFailureUtil.getClassLoaders(t);
        if (classLoaders == null || classLoaders.size() == 0) {
            return new Class[0];
        }
        ArrayList classes = new ArrayList(2);
        ArrayList<String> names = new ArrayList<String>(2);
        names.add("org.junit.ComparisonFailure");
        names.add("junit.framework.ComparisonFailure");
        Iterator iterator = classLoaders.iterator();
        while (iterator.hasNext() && names.size() > 0) {
            ClassLoader next = (ClassLoader)iterator.next();
            if (next == null) continue;
            Iterator jit = names.iterator();
            while (jit.hasNext()) {
                String name = (String)jit.next();
                try {
                    classes.add(next.loadClass(name));
                    jit.remove();
                }
                catch (Throwable throwable) {}
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static ComparisonFailureData getComparisonFailureFromCause(Throwable t, Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            ComparisonFailureData extracted;
            Class cl = classes[i];
            Throwable cause = ComparisonFailureUtil.getCause(t, cl);
            if (cause == null || (extracted = ComparisonFailureUtil.extractComparisonFailureData(cause, cl)) == null) continue;
            return extracted;
        }
        return null;
    }

    private static ComparisonFailureData extractComparisonFailureData(Throwable t, Class cl) {
        try {
            String expected = ComparisonFailureUtil.getExpected(t, cl);
            String actual = ComparisonFailureUtil.getActual(t, cl);
            return new ComparisonFailureData(expected, actual);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Throwable getCause(Throwable e, Class clazz) {
        if (e == null) {
            return null;
        }
        LinkedHashSet<Throwable> visitedCauses = new LinkedHashSet<Throwable>();
        Throwable cause = e;
        do {
            if (clazz.isInstance(cause)) {
                return cause;
            }
            visitedCauses.add(cause);
        } while ((cause = cause.getCause()) != null && !visitedCauses.contains(cause));
        return null;
    }

    private static Collection getClassLoaders(Throwable e) {
        if (e == null) {
            return null;
        }
        LinkedHashSet<Throwable> visitedCauses = new LinkedHashSet<Throwable>();
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
        Throwable cause = e;
        do {
            visitedCauses.add(cause);
            classLoaders.add(cause.getClass().getClassLoader());
        } while ((cause = cause.getCause()) != null && !visitedCauses.contains(cause));
        return classLoaders;
    }
}

