/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.nio.charset.Charset;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NotNull;

public final class ExecResult {
    private int myExitCode = -1;
    private String myStdout = "";
    private String myStderr = "";
    private StreamGobbler myOutputGobbler;
    private StreamGobbler myErrorGobbler;
    private Throwable myException = null;
    private final Charset myEncoding;
    private long myElapsedTimeMs = -1L;

    public ExecResult() {
        this(Charset.defaultCharset());
    }

    public ExecResult(Charset charset) {
        this.myEncoding = charset;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ErrCode=");
        buf.append(this.getExitCode());
        if (this.myElapsedTimeMs != -1L) {
            buf.append("ElapsedTime=");
            buf.append(TimePrinter.createMillisecondsFormatter().formatTime(this.myElapsedTimeMs));
        }
        buf.append("\nStdOut:------------\n");
        buf.append(this.getStdout());
        buf.append("\nStdErr:------------\n");
        buf.append(this.getStderr());
        if (this.getException() != null) {
            buf.append("\nException----------\n");
            buf.append(this.getException());
        }
        buf.append("\nEnd----------------\n");
        return buf.toString();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void setStdout(String stdout) {
        this.myStdout = stdout;
    }

    public void setStderr(String stderr) {
        this.myStderr = stderr;
    }

    @NotNull
    public String getStdout() {
        if (this.myOutputGobbler != null) {
            String string = this.myOutputGobbler.getReadString(this.myEncoding);
            if (string == null) {
                ExecResult.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.myStdout;
        if (string == null) {
            ExecResult.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String[] getOutLines() {
        return this.getStdout().split("\\r?\\n");
    }

    public void setOutputGobbler(StreamGobbler outputGobbler) {
        this.myOutputGobbler = outputGobbler;
    }

    public void setErrorGobbler(StreamGobbler errorGobbler) {
        this.myErrorGobbler = errorGobbler;
    }

    @NotNull
    public String getStderr() {
        if (this.myErrorGobbler != null) {
            String string = this.myErrorGobbler.getReadString(this.myEncoding);
            if (string == null) {
                ExecResult.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.myStderr;
        if (string == null) {
            ExecResult.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Throwable getException() {
        return this.myException;
    }

    public void setException(Throwable exception) {
        this.myException = exception;
    }

    public void setElapsedTime(long milliseconds) {
        this.myElapsedTimeMs = milliseconds;
    }

    public long getElapsedTime() {
        return this.myElapsedTimeMs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/buildServer/ExecResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

