/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class LineAwareByteArrayOutputStream
extends ByteArrayOutputStream {
    private final Charset myCharset;
    private final LineListener myListener;
    private final boolean myAccumulateBytes;
    private byte[] myPendingLine;
    private boolean myCREndsLine;

    public LineAwareByteArrayOutputStream(@NotNull Charset charset, @NotNull LineListener listener) {
        if (charset == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(1);
        }
        this(charset, listener, true);
    }

    public LineAwareByteArrayOutputStream(@NotNull Charset charset, @NotNull LineListener listener, boolean accumulateBytes) {
        if (charset == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(3);
        }
        this.myCREndsLine = false;
        this.myCharset = charset;
        this.myListener = listener;
        this.myAccumulateBytes = accumulateBytes;
    }

    public void setCREndsLine(boolean CREndsLine) {
        this.myCREndsLine = CREndsLine;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (this.myAccumulateBytes) {
            super.write(b, off, len);
        }
        this.detectLines(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reportPendingLine();
    }

    private void detectLines(byte[] buf, int off, int len) {
        int lineStart = -1;
        int c = -1;
        int prevC = -1;
        int i = 0;
        while (i < len) {
            if (lineStart == -1) {
                lineStart = off;
            }
            if (c != -1) {
                prevC = c;
            }
            if ((c = buf[off]) == 10) {
                int end = prevC != 13 ? off : off - 1;
                this.reportNewLine(buf, lineStart, end, i == 0);
                lineStart = -1;
            } else if (this.myCREndsLine && c == 13) {
                boolean beforeLF;
                boolean bl = beforeLF = i < len - 1 && buf[off + 1] == 10;
                if (!beforeLF) {
                    this.reportNewLine(buf, lineStart, off, false);
                    lineStart = -1;
                }
            }
            ++i;
            ++off;
        }
        if (lineStart != -1) {
            if (this.myPendingLine == null) {
                this.myPendingLine = new byte[off - lineStart];
                System.arraycopy(buf, lineStart, this.myPendingLine, 0, off - lineStart);
            } else {
                byte[] expandedLine = new byte[off - lineStart + this.myPendingLine.length];
                System.arraycopy(this.myPendingLine, 0, expandedLine, 0, this.myPendingLine.length);
                System.arraycopy(buf, lineStart, expandedLine, this.myPendingLine.length, off - lineStart);
                this.myPendingLine = expandedLine;
            }
        }
    }

    private void reportPendingLine() {
        if (this.myPendingLine != null) {
            this.reportNewLine(new String(this.myPendingLine, 0, this.myPendingLine.length, this.myCharset));
        }
    }

    private void reportNewLine(@NotNull byte[] buf, int start, int end, boolean stripPendingLineCR) {
        if (buf == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(4);
        }
        if (this.myPendingLine == null) {
            this.reportNewLine(new String(buf, start, end - start, this.myCharset));
        } else {
            int pendingLen = this.myPendingLine.length;
            if (stripPendingLineCR && pendingLen > 0 && this.myPendingLine[pendingLen - 1] == 13) {
                --pendingLen;
            }
            byte[] fullLine = new byte[pendingLen + end - start];
            System.arraycopy(this.myPendingLine, 0, fullLine, 0, pendingLen);
            System.arraycopy(buf, start, fullLine, pendingLen, end - start);
            this.reportNewLine(new String(fullLine, 0, fullLine.length, this.myCharset));
            this.myPendingLine = null;
        }
    }

    private void reportNewLine(@NotNull String line) {
        if (line == null) {
            LineAwareByteArrayOutputStream.$$$reportNull$$$0(5);
        }
        this.myListener.newLineDetected(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/LineAwareByteArrayOutputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportNewLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface LineListener {
        public void newLineDetected(@NotNull String var1);
    }
}

