/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkUtil {
    private static final Logger LOG = Logger.getInstance((String)NetworkUtil.class.getName());

    private NetworkUtil() {
    }

    @NotNull
    public static InetAddress[] getSelfAddresses() throws SocketException {
        InetAddress[] inetAddressArray = NetworkUtil.getSelfAddresses(new Filter<InetAddress>(){

            @Override
            public boolean accept(@NotNull InetAddress data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return data instanceof Inet4Address;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/NetworkUtil$1", "accept"));
            }
        });
        if (inetAddressArray == null) {
            NetworkUtil.$$$reportNull$$$0(0);
        }
        return inetAddressArray;
    }

    @NotNull
    public static InetAddress[] getSelfAddresses(@Nullable Filter<InetAddress> filter) throws SocketException {
        ArrayList<InetAddress> selfAddresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || filter != null && !filter.accept(inetAddress)) continue;
                selfAddresses.add(inetAddress);
            }
        }
        if (selfAddresses.size() == 0) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                if (filter == null || filter.accept(localHost)) {
                    selfAddresses.add(localHost);
                }
            }
            catch (UnknownHostException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.debug("Found Network Interfaces: " + selfAddresses);
        InetAddress[] inetAddressArray = selfAddresses.toArray(new InetAddress[selfAddresses.size()]);
        if (inetAddressArray == null) {
            NetworkUtil.$$$reportNull$$$0(1);
        }
        return inetAddressArray;
    }

    public static boolean isPortBusy(int port) {
        return NetworkUtil.isPortBusy("localhost", port, 20, false);
    }

    public static boolean isPortBusy(int port, boolean showThreadDump) {
        return NetworkUtil.isPortBusy("localhost", port, 20, showThreadDump);
    }

    public static boolean isPortBusy(String host, int port, int connectTimeoutMsecs) {
        return NetworkUtil.isPortBusy(host, port, connectTimeoutMsecs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortBusy(String host, int port, int connectTimeoutMsecs, boolean showThreadDump) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), connectTimeoutMsecs);
        }
        catch (IOException e) {
            if (showThreadDump) {
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return true;
    }

    public static int getFreePort(int i) {
        int numIterations = 0;
        int port = i;
        while (NetworkUtil.isPortBusy(port) && numIterations < 3) {
            if (port == 65535) {
                port = 1025;
                ++numIterations;
            }
            ++port;
        }
        if (numIterations == 3) {
            throw new IllegalStateException("Unable to find free port, tried range: 1025 - 65535");
        }
        return port;
    }

    @NotNull
    public static String getHostAddressWithoutScope(@NotNull Inet6Address ipv6Address) {
        String hostAddr;
        int scopeIdStart;
        if (ipv6Address == null) {
            NetworkUtil.$$$reportNull$$$0(2);
        }
        if ((scopeIdStart = (hostAddr = ipv6Address.getHostAddress()).indexOf(37)) != -1) {
            String string = hostAddr.substring(0, scopeIdStart);
            if (string == null) {
                NetworkUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = hostAddr;
        if (string == null) {
            NetworkUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isLocalHost(@NotNull String hostname) {
        if (hostname == null) {
            NetworkUtil.$$$reportNull$$$0(5);
        }
        try {
            InetAddress address = InetAddress.getByName(hostname);
            if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(address) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static String hostAndPort(@NotNull String ipOrHost, @Nullable Integer portNumber) {
        if (ipOrHost == null) {
            NetworkUtil.$$$reportNull$$$0(6);
        }
        String host = ipOrHost;
        if (!ipOrHost.startsWith("[") && ipOrHost.contains(":")) {
            host = "[" + ipOrHost + "]";
        }
        if (portNumber == null || portNumber < 0) {
            return host;
        }
        return host + ":" + portNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/NetworkUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipv6Address";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostname";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipOrHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfAddresses";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/NetworkUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostAddressWithoutScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHostAddressWithoutScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLocalHost";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hostAndPort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

