/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.io.File;
import java.net.URL;

public class ResourceUtil {
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final String JAR_DELIMITER = "!";
    private static final String PROTOCOL_DELIMITER = ":";

    public static String getResourceRoot(Class context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        if (url == null) {
            return null;
        }
        return ResourceUtil.extractRoot(url, path);
    }

    private static String extractRoot(URL resourceURL, String resourcePath) {
        String archivePath;
        String fullPath;
        int delimiter;
        if (!resourcePath.startsWith("/") && !resourcePath.startsWith("\\")) {
            System.err.println("precondition failed");
            return null;
        }
        String protocol = resourceURL.getProtocol();
        String resultPath = null;
        if (FILE.equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/').toLowerCase();
            if (testPath.endsWith(testResourcePath = resourcePath.replace('\\', '/').toLowerCase())) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if (JAR.equals(protocol) && (delimiter = (fullPath = resourceURL.getFile()).indexOf(JAR_DELIMITER)) >= 0 && (archivePath = fullPath.substring(0, delimiter)).startsWith("file:")) {
            resultPath = archivePath.substring(FILE.length() + PROTOCOL_DELIMITER.length());
        }
        if (resultPath != null && resultPath.endsWith(File.separator)) {
            resultPath = resultPath.substring(0, resultPath.length() - 1);
        }
        resultPath = ResourceUtil.replaceAll(resultPath, "%20", " ");
        if ((resultPath = ResourceUtil.replaceAll(resultPath, "%23", "#")).startsWith("/") && resultPath.indexOf(PROTOCOL_DELIMITER) == 2) {
            resultPath = resultPath.substring(1);
        }
        return resultPath;
    }

    private static String replaceAll(String text, String pattern, String replacement) {
        if (pattern.length() == 0 || text.length() < pattern.length()) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int currentTextIndex = 0;
        while (currentTextIndex < text.length()) {
            int startOfPattern = text.indexOf(pattern, currentTextIndex);
            if (startOfPattern < 0) {
                if (currentTextIndex == 0) {
                    return text;
                }
                buf.append(text.substring(currentTextIndex));
                return buf.toString();
            }
            buf.append(text, currentTextIndex, startOfPattern);
            buf.append(replacement);
            currentTextIndex = startOfPattern + pattern.length();
        }
        return buf.toString();
    }

    public static String getResourceRoot(Class aClass) {
        return ResourceUtil.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
    }
}

