/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.CommandLineExecutor;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.ProcessTimeoutException;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCommandLineProcessRunner {
    private static final Logger LOG = Logger.getInstance((String)SimpleCommandLineProcessRunner.class.getName());
    public static final String TEAMCITY_COMMANDLINE_STDSTREAMS_ENCODING = "teamcity.commandline.stdstreams.encoding";

    private SimpleCommandLineProcessRunner() {
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(0);
        }
        return SimpleCommandLineProcessRunner.runCommand(commandLine, input, new RunCommandEventsAdapter());
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(1);
        }
        if (eventHandler == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(2);
        }
        return SimpleCommandLineProcessRunner.runCommandSecure(commandLine, commandLine.getCommandLineString(), input, eventHandler);
    }

    public static ExecResult runCommandSecure(@NotNull GeneralCommandLine commandLine, @NotNull String commandLineToLog, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(3);
        }
        if (commandLineToLog == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(4);
        }
        if (eventHandler == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(5);
        }
        return SimpleCommandLineProcessRunner.runCommandSecure(commandLine, commandLineToLog, input, eventHandler, new ByteArrayOutputStream(), new ByteArrayOutputStream());
    }

    public static ExecResult runCommandSecure(final @NotNull GeneralCommandLine commandLine, final @NotNull String commandLineToLog, final @Nullable byte[] input, final @NotNull RunCommandEvents eventHandler, final @NotNull ByteArrayOutputStream stdoutBuffer, final @NotNull ByteArrayOutputStream stderrBuffer) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(6);
        }
        if (commandLineToLog == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(7);
        }
        if (eventHandler == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(8);
        }
        if (stdoutBuffer == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(9);
        }
        if (stderrBuffer == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(10);
        }
        Charset charset = SimpleCommandLineProcessRunner.getCharset(commandLine);
        final ExecResult retVal = new ExecResult(charset);
        if (LOG.isDebugEnabled()) {
            File workDirectory = commandLine.getWorkDirectory();
            LOG.debug("Start process [" + commandLineToLog + "]" + (workDirectory != null ? " in \"" + workDirectory + "\"" : "") + (charset != null ? " with charset \"" + charset.name() + "\"" : ""));
        }
        NamedThreadFactory.executeWithNewThreadName("Running child process: " + SimpleCommandLineProcessRunner.getThreadNameCommandLine(commandLineToLog), new Runnable(){

            @Override
            public void run() {
                SimpleCommandLineProcessRunner.runCommandInternal(commandLine, commandLineToLog, input, eventHandler, retVal, stdoutBuffer, stderrBuffer);
            }
        });
        return retVal;
    }

    public static Charset getCharset(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(11);
        }
        String overridenCharsetName = SimpleCommandLineProcessRunner.getOverridenCharsetName(commandLine);
        try {
            if (overridenCharsetName != null) {
                return Charset.forName(overridenCharsetName);
            }
        }
        catch (UnsupportedCharsetException e) {
            LOG.warn("Failed to find charset with name \"" + overridenCharsetName + "\" for process output and will use default. Check value of the \"" + TEAMCITY_COMMANDLINE_STDSTREAMS_ENCODING + "\" property");
        }
        return commandLine.getCharset();
    }

    @Nullable
    private static String getOverridenCharsetName(@NotNull GeneralCommandLine commandLine) {
        String overridenExeSpecificCharset;
        String name;
        String overridenCharset;
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(12);
        }
        if ((overridenCharset = TeamCityProperties.getPropertyOrNull(TEAMCITY_COMMANDLINE_STDSTREAMS_ENCODING)) == null) {
            return null;
        }
        try {
            name = new File(commandLine.getExePath()).getName();
        }
        catch (Exception ignore) {
            name = null;
        }
        if (name != null && (overridenExeSpecificCharset = TeamCityProperties.getPropertyOrNull("teamcity.commandline.stdstreams.encoding." + name)) != null) {
            return overridenExeSpecificCharset;
        }
        return StringUtil.isEmpty((String)overridenCharset) ? null : overridenCharset;
    }

    @NotNull
    public static String getThreadNameCommandLine(@NotNull String commandLineText) {
        if (commandLineText == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(13);
        }
        int commandLineStrLimit = TeamCityProperties.getInteger("teamcity.externalProcessRunner.limitCommandLineLengthInThreadName", 1000);
        String string = StringUtil.truncateStringValueWithDotsAtCenter(commandLineText, commandLineStrLimit);
        if (string == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommandInternal(@NotNull GeneralCommandLine commandLine, @NotNull String commandLineToLog, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler, @NotNull ExecResult retVal, @NotNull ByteArrayOutputStream stdoutBuffer, @NotNull ByteArrayOutputStream stderrBuffer) {
        if (commandLine == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(15);
        }
        if (commandLineToLog == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(16);
        }
        if (eventHandler == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(17);
        }
        if (retVal == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(18);
        }
        if (stdoutBuffer == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(19);
        }
        if (stderrBuffer == null) {
            SimpleCommandLineProcessRunner.$$$reportNull$$$0(20);
        }
        long start = System.nanoTime();
        try {
            Process proc = commandLine.createProcess();
            Integer maxOutputSize = eventHandler instanceof ProcessRunCallback ? ((ProcessRunCallback)eventHandler).getMaxAcceptedOutputSize() : null;
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), maxOutputSize, "StdErr for " + commandLineToLog, stderrBuffer);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), maxOutputSize, "StdOut for " + commandLineToLog, stdoutBuffer);
            errorGobbler.start();
            outputGobbler.start();
            if (input != null) {
                try (OutputStream out = proc.getOutputStream();){
                    out.write(input);
                }
                catch (Throwable e) {
                    retVal.setException(e);
                    proc.destroy();
                }
            }
            eventHandler.onProcessStarted(proc);
            retVal.setOutputGobbler(outputGobbler);
            retVal.setErrorGobbler(errorGobbler);
            Integer timeout = eventHandler.getOutputIdleSecondsTimeout();
            if (timeout == null) {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, commandLineToLog, errorGobbler, outputGobbler));
            } else {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, commandLineToLog, errorGobbler, outputGobbler, timeout));
            }
            eventHandler.onProcessFinished(proc);
        }
        catch (Throwable e) {
            if (e instanceof ProcessTimeoutException) {
                ((ProcessTimeoutException)e).setProcessName(commandLineToLog);
            }
            retVal.setException(e);
        }
        finally {
            retVal.setElapsedTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 4: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineToLog";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdoutBuffer";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderrBuffer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/SimpleCommandLineProcessRunner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retVal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/SimpleCommandLineProcessRunner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadNameCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runCommandSecure";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOverridenCharsetName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getThreadNameCommandLine";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runCommandInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoOutputTimeoutProcessRunCallbackAdapter
    extends NoOutputTimeoutRunCommandEventsAdapter {
        @Override
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class ProcessRunCallbackAdapter
    extends RunCommandEventsAdapter {
    }

    public static class NoOutputTimeoutRunCommandEventsAdapter
    extends RunCommandEventsAdapter {
        @Override
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class RunCommandEventsAdapter
    implements ProcessRunCallback {
        @Override
        public void onProcessStarted(@NotNull Process ps) {
            if (ps == null) {
                RunCommandEventsAdapter.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void onProcessFinished(@NotNull Process ps) {
            if (ps == null) {
                RunCommandEventsAdapter.$$$reportNull$$$0(1);
            }
        }

        @Override
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return null;
        }

        @Override
        @Nullable
        public Integer getMaxAcceptedOutputSize() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "ps";
            objectArray2[1] = "jetbrains/buildServer/SimpleCommandLineProcessRunner$RunCommandEventsAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onProcessStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onProcessFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ProcessRunCallback
    extends RunCommandEvents {
        @Nullable
        public Integer getMaxAcceptedOutputSize();
    }

    public static interface RunCommandEvents {
        public void onProcessStarted(@NotNull Process var1);

        public void onProcessFinished(@NotNull Process var1);

        @Nullable
        public Integer getOutputIdleSecondsTimeout();
    }
}

