/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import jetbrains.buildServer.TCNonValidatedSAXParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TCNonValidatedSAXParserWithDebug
extends TCNonValidatedSAXParser {
    private static final Logger LOG = Logger.getInstance((String)TCNonValidatedSAXParserWithDebug.class.getName());
    private String myMessageText = null;

    public TCNonValidatedSAXParserWithDebug() {
        this.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                TCNonValidatedSAXParserWithDebug.this.Throw(exception);
            }

            @Override
            public void error(SAXParseException exception) {
                TCNonValidatedSAXParserWithDebug.this.Throw(exception);
            }

            @Override
            public void fatalError(SAXParseException exception) {
                TCNonValidatedSAXParserWithDebug.this.Throw(exception);
            }
        });
    }

    @Override
    public void parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource.getByteStream() != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamUtil.copyStreamContent((InputStream)inputSource.getByteStream(), (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            this.myMessageText = new String(bytes, "utf-8");
            inputSource = new InputSource(new ByteArrayInputStream(bytes));
        } else if (inputSource.getCharacterStream() != null) {
            int v;
            StringBuilder sb = new StringBuilder();
            char[] buff = new char[2028];
            while ((v = inputSource.getCharacterStream().read(buff)) > 0) {
                sb.append(buff, 0, v);
            }
            this.myMessageText = sb.toString();
            inputSource = new InputSource(new StringReader(this.myMessageText));
        }
        try {
            super.parse(inputSource);
        }
        catch (SAXException e) {
            this.Throw(e);
            throw e;
        }
    }

    private void Throw(SAXException e) {
        if (this.myMessageText != null) {
            LOG.error(this.myMessageText, (Throwable)e);
        } else {
            LOG.error("No xml content available", (Throwable)e);
        }
    }
}

