/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import jetbrains.buildServer.agent.ChangedFiles;
import jetbrains.buildServer.agent.IOUtil;
import jetbrains.buildServer.agent.VcsChange;

public class FirstTestsToRunProvider {
    private final List myRecentlyFailedTestCases = new ArrayList();
    private final ChangedFiles myBuildVcsChanges = ChangedFiles.create();

    private FirstTestsToRunProvider() {
    }

    public static FirstTestsToRunProvider create() {
        FirstTestsToRunProvider firstTestsToRunProvider = new FirstTestsToRunProvider();
        if (firstTestsToRunProvider.isGroupIncluded("recentlyFailed")) {
            firstTestsToRunProvider.loadRecentlyFailedTests();
        }
        return firstTestsToRunProvider;
    }

    public boolean isAvailable() {
        return this.getRiskGroupTestsParamValue() != null;
    }

    public ChangedFiles getBuildVcsChanges() {
        return this.myBuildVcsChanges;
    }

    public List getRecentlyFailedTestCases() {
        return this.myRecentlyFailedTestCases;
    }

    public VcsChange getCorrespondingChange(String className) {
        List changes = this.myBuildVcsChanges.getNewOrModifiedFiles();
        return this.findRelatedVcsChange(changes, className);
    }

    private VcsChange findRelatedVcsChange(List changes, String className) {
        for (int i = 0; i < changes.size(); ++i) {
            VcsChange change = (VcsChange)changes.get(i);
            if (!change.isRelatedToClass(className)) continue;
            return change;
        }
        return null;
    }

    public void sortTestClasses(List testClasses, ClassObjectDescriptor classObjectDescriptor) {
        VcsChange change;
        String className;
        LinkedHashMap classNameToObjectsList = new LinkedHashMap();
        for (Object obj : testClasses) {
            String className2 = classObjectDescriptor.getName(obj);
            ArrayList objects = (ArrayList)classNameToObjectsList.get(className2);
            if (objects == null) {
                objects = new ArrayList(1);
                classNameToObjectsList.put(className2, objects);
            }
            objects.add(obj);
        }
        ArrayList<VcsChange> personalChanges = new ArrayList<VcsChange>();
        ArrayList<VcsChange> changes = new ArrayList<VcsChange>();
        List allChanges = this.myBuildVcsChanges.getNewOrModifiedFiles();
        for (int i = 0; i < allChanges.size(); ++i) {
            VcsChange change2 = (VcsChange)allChanges.get(i);
            if (change2.isPersonal()) {
                personalChanges.add(change2);
                continue;
            }
            changes.add(change2);
        }
        testClasses.clear();
        if (!personalChanges.isEmpty()) {
            Iterator it = classNameToObjectsList.keySet().iterator();
            while (it.hasNext()) {
                className = (String)it.next();
                change = this.findRelatedVcsChange(personalChanges, className);
                if (change == null) continue;
                testClasses.addAll((Collection)classNameToObjectsList.get(className));
                it.remove();
            }
        }
        if (!changes.isEmpty()) {
            Iterator it = classNameToObjectsList.keySet().iterator();
            while (it.hasNext()) {
                className = (String)it.next();
                change = this.findRelatedVcsChange(changes, className);
                if (change == null) continue;
                testClasses.addAll((Collection)classNameToObjectsList.get(className));
                it.remove();
            }
        }
        for (String name : this.getRecentlyFailedTestCases()) {
            List objects = (List)classNameToObjectsList.remove(name);
            if (objects == null) continue;
            testClasses.addAll(objects);
        }
        Iterator<Object> it = classNameToObjectsList.values().iterator();
        while (it.hasNext()) {
            testClasses.addAll((Collection)it.next());
        }
    }

    public boolean isGroupIncluded(String groupName) {
        return this.getTestsGroupOrder(groupName) != -1;
    }

    private String getRiskGroupTestsParamValue() {
        String property = System.getProperty("teamcity.tests.runRiskGroupTestsFirst");
        if (property == null || property.length() == 0 || property.trim().length() == 0) {
            return null;
        }
        return property;
    }

    private int getTestsGroupOrder(String value) {
        String riskGroupTestsParamValue = this.getRiskGroupTestsParamValue();
        if (riskGroupTestsParamValue == null) {
            return -1;
        }
        ArrayList<String> order = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(riskGroupTestsParamValue, ",");
        while (st.hasMoreElements()) {
            String val = st.nextToken();
            if (val == null) continue;
            val = val.trim();
            order.add(val);
        }
        return order.indexOf(value);
    }

    private void loadRecentlyFailedTests() {
        String filePath = System.getProperty("teamcity.tests.recentlyFailedTests.file");
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file.exists()) {
            this.myRecentlyFailedTestCases.addAll(IOUtil.readLines(file));
        }
    }

    public static interface ClassObjectDescriptor {
        public String getName(Object var1);
    }
}

