/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.security.SecureRandom;

public class FlowGenerator {
    public static String generateNewFlow() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(String.valueOf(System.class.getMethod("nanoTime", new Class[0]).invoke(System.class, new Object[0])));
        }
        catch (Throwable e) {
            try {
                buf.append(SecureRandom.getInstance("SHA1PRNG").nextInt());
            }
            catch (Throwable e2) {
                buf.append(System.currentTimeMillis());
            }
        }
        return buf.toString();
    }

    public static String[] getFlowId() {
        String parentFlowId;
        String flowId = FlowGenerator.readValue("teamcity.process.flow.id", "TEAMCITY_PROCESS_FLOW_ID");
        if (flowId == null || flowId.length() == 0) {
            flowId = FlowGenerator.generateNewFlow();
        }
        if ((parentFlowId = FlowGenerator.readEnvVar("TEAMCITY_PROCESS_PARENT_FLOW_ID")) == null) {
            parentFlowId = "";
        }
        return new String[]{parentFlowId, flowId};
    }

    public static boolean isFlowStarted() {
        String flowId = FlowGenerator.readValue("teamcity.process.flow.id", "TEAMCITY_PROCESS_FLOW_ID");
        return flowId != null && flowId.length() > 0;
    }

    private static String readValue(String systemPropertyKey, String environmentVariableName) {
        String value = System.getProperty(systemPropertyKey);
        return value == null ? FlowGenerator.readEnvVar(environmentVariableName) : value;
    }

    private static String readEnvVar(String name) {
        try {
            return System.getenv(name);
        }
        catch (Error e) {
            return null;
        }
    }
}

