/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class RuntimeProperties {
    private static RuntimeProperties ourInstance;
    private final Properties myProperties;

    public RuntimeProperties(Properties properties) {
        this.myProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeProperties getInstance() {
        if (ourInstance != null) {
            return ourInstance;
        }
        String propsPath = RuntimeProperties.getPropsFilePath();
        if (propsPath == null) {
            return new RuntimeProperties(new Properties());
        }
        Properties props = new Properties();
        File propsFile = new File(propsPath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propsFile);
            props.load(fis);
        }
        catch (IOException e) {
            System.err.println("Runtime properties path is provided but corresponding file was not found: " + propsFile);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ourInstance = new RuntimeProperties(props);
        return ourInstance;
    }

    public static boolean isAvailable() {
        return RuntimeProperties.getPropsFilePath() != null;
    }

    private static String getPropsFilePath() {
        return System.getProperty("teamcity.runtime.props.file");
    }

    public String getRuntimeClasspath() {
        return this.getPropertyValue("agent.classpath");
    }

    private String getPropertyValue(String propName) {
        String value = (String)this.myProperties.get(propName);
        return value != null ? value : System.getProperty(propName);
    }

    public String getAntTaskExtensions() {
        return this.getPropertyValue("ant.task.extensions");
    }
}

