/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import jetbrains.buildServer.agent.AgentRuntimeProperties;
import jetbrains.buildServer.agent.impl.XmlRpcAgentLogListener;
import jetbrains.buildServer.agentServer.AgentLogListener;
import jetbrains.buildServer.messages.XStreamUtil;

public class ServerLogger {
    private static ServerLogger ourInstance;
    private final AgentLogListener myLoggingAgent;
    private static final String DEBUG_OUTPUT_DIR;
    private static final boolean DO_OUTPUT;
    private final String myBuildId;
    private final PrintStream myStdErrStream = System.err;
    private final List myMessagesBuf = new ArrayList();
    private static final int BUF_SIZE;
    private static final ThreadLocal ourInsideLogEvent;

    private ServerLogger(String buildId, AgentLogListener server) {
        this.myLoggingAgent = server;
        this.myBuildId = buildId;
        XStreamUtil.createXStream();
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId) {
        return ServerLogger.getLoggerInstance(buildId, AgentRuntimeProperties.getOwnPort());
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId, int port) {
        return ServerLogger.getLoggerInstance(buildId, new XmlRpcAgentLogListener(port));
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId, AgentLogListener agentLogger) {
        if (ourInstance == null) {
            ourInstance = new ServerLogger(buildId, agentLogger);
        }
        return ourInstance;
    }

    public void log(String messageXml) {
        this.addMessageToBuffer(messageXml);
        this.flushBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer(boolean force) {
        if (!this.setInsideLogEvent()) {
            return;
        }
        try {
            Vector messagesToSend = new Vector(BUF_SIZE);
            List list = this.myMessagesBuf;
            synchronized (list) {
                block15: {
                    if (this.myMessagesBuf.size() >= BUF_SIZE || force) break block15;
                    return;
                }
                messagesToSend.addAll(this.myMessagesBuf);
                this.myMessagesBuf.clear();
            }
            this.myLoggingAgent.log(this.myBuildId, messagesToSend);
            if (DO_OUTPUT) {
                String thName = Thread.currentThread().getName();
                ServerLogger.debug("Sent", thName + ": " + messagesToSend);
            }
        }
        catch (Throwable e) {
            try {
                if (DO_OUTPUT) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(out);
                    e.printStackTrace(printStream);
                    printStream.close();
                    ServerLogger.debug("Error", new String(out.toByteArray()));
                    ServerLogger.debug("Error", e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            e.printStackTrace(this.myStdErrStream);
        }
        finally {
            this.clearInsideLogEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToBuffer(String messageXml) {
        List list = this.myMessagesBuf;
        synchronized (list) {
            this.myMessagesBuf.add(messageXml);
        }
    }

    public void flush() {
        this.flushBuffer(true);
    }

    private void clearInsideLogEvent() {
        ourInsideLogEvent.set(null);
    }

    private boolean setInsideLogEvent() {
        Boolean current = (Boolean)ourInsideLogEvent.get();
        if (current != null && current.booleanValue()) {
            return false;
        }
        ourInsideLogEvent.set(Boolean.TRUE);
        return true;
    }

    public static synchronized void reset() {
        ourInstance = null;
    }

    public static void debug(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String prefix, String s) {
        File myFile = new File(new File(DEBUG_OUTPUT_DIR), prefix + AgentRuntimeProperties.getBuildId());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(myFile.getAbsolutePath(), true);
            fileWriter.write(new Date().getTime() + ": " + s + "\n");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return "ServerLogger: " + this.myLoggingAgent;
    }

    static {
        DEBUG_OUTPUT_DIR = System.getProperty("teamcity.debug.out.dir");
        DO_OUTPUT = DEBUG_OUTPUT_DIR != null;
        BUF_SIZE = Integer.parseInt(System.getProperty("teamcity.runtimeLogger.bufSize", "1"));
        ourInsideLogEvent = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

