/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent.impl;

import java.security.KeyStore;
import java.util.Date;
import java.util.Vector;
import jetbrains.buildServer.agentServer.AgentLogListener;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcFactory;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;

public class XmlRpcAgentLogListener
implements AgentLogListener {
    protected volatile XmlRpcTarget myTarget;
    protected final String myMethodPrefix;
    private final boolean myUseApacheCommonsTransport;
    private final KeyStore myTrustStore;

    public XmlRpcAgentLogListener(int localPort) {
        this("http://localhost:" + localPort, "buildAgent", false, 0, null);
    }

    protected XmlRpcAgentLogListener(String serverUrl, int connectionTimeout, KeyStore trustStore) {
        this(serverUrl, "buildServer", true, connectionTimeout, trustStore);
    }

    private XmlRpcAgentLogListener(String serverUrl, String xmlRpcPrefix, boolean useApacheCommonsTransport, int connectionTimeout, KeyStore trustStore) {
        this.myMethodPrefix = xmlRpcPrefix;
        this.myUseApacheCommonsTransport = useApacheCommonsTransport;
        this.myTrustStore = trustStore;
        this.myTarget = this.createTarget(serverUrl, connectionTimeout, this.myTrustStore);
    }

    private XmlRpcTarget createTarget(String serverUrl, int connectionTimeout, KeyStore trustStore) {
        return XmlRpcFactory.getInstance().create(serverUrl, "TeamCity Agent", XmlRpcAgentLogListener.isUnitTest() ? 60000 : connectionTimeout * 1000, this.myUseApacheCommonsTransport, trustStore);
    }

    private static boolean isUnitTest() {
        return "yes".equals(System.getProperty("jetbrains.unit.test"));
    }

    public boolean log(final String buildId, final Vector messagesXml) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                Boolean result = (Boolean)XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".log", new Object[]{buildId, messagesXml});
                return result;
            }
        });
    }

    public boolean buildFinished(final String buildId, final Date finishDate, final boolean buildFailed) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".buildFinished", new Object[]{buildId, finishDate, buildFailed ? Boolean.TRUE : Boolean.FALSE});
                return true;
            }
        });
    }

    public boolean buildDetachedFromAgent(final String buildId, final String lastStepId) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".buildDetachedFromAgent", new Object[]{buildId, lastStepId});
                return true;
            }
        });
    }

    public boolean buildInterrupted(String buildId) {
        return this.buildInterrupted(buildId, "", true);
    }

    public boolean buildInterrupted(final String buildId, final String comment, final boolean needRequeue) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".buildInterrupted", new Object[]{buildId, comment, needRequeue});
                return true;
            }
        });
    }

    public boolean isBuildFailing(final String buildId) throws InterruptedException {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                return (Boolean)XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".isBuildFailing", new Object[]{buildId});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSendRequest(RemoteCall call) {
        try {
            return call.invoke();
        }
        catch (RemoteCallException e) {
            if (e.getMessage().indexOf("403") != -1) {
                XmlRpcTarget oldTarget = this.myTarget;
                try {
                    this.myTarget = this.createTarget(this.myTarget.getServerURL(), 0, this.myTrustStore);
                }
                finally {
                    if (oldTarget != null) {
                        oldTarget.dispose();
                    }
                }
                return call.invoke();
            }
            throw e;
        }
    }

    public String toString() {
        return this.myMethodPrefix + " " + this.myTarget;
    }

    static interface RemoteCall {
        public boolean invoke();
    }
}

