/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jetbrains.buildServer.BuildAuthUtil;
import jetbrains.buildServer.agentServer.BuildFeatureInfo;
import jetbrains.buildServer.agentServer.BuildRunnerData;
import jetbrains.buildServer.agentServer.StringTreeMap;
import jetbrains.buildServer.agentServer.StringTreeMapConverter;
import jetbrains.buildServer.agentServer.VcsChangeConverter;
import jetbrains.buildServer.agentServer.VcsRootEntryConverter;
import jetbrains.buildServer.artifacts.ArtifactDependencyInfo;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.util.Option;
import jetbrains.buildServer.util.XmlUtil;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentBuild
implements Loggable {
    private final long myBuildId;
    private String myCheckoutDir;
    @NotNull
    private String myBuildTypeId;
    @NotNull
    private String myBuildTypeExternalId;
    private String myArtifactPaths;
    private boolean myPersonal;
    private boolean myPersonalPatchAvailable;
    private long myCleanCheckoutEnforcedBuildId = -1L;
    private String myAccessCode;
    private CheckoutType myCheckoutType = CheckoutType.MANUAL;
    private final Map<String, String> myServerParameters = new StringTreeMap();
    @NotNull
    private final Map<String, String> myParametersSpecs = new StringTreeMap();
    private final List<VcsRootEntry> myVcsRootEntries = new ArrayList<VcsRootEntry>();
    private final List<String> myFullCheckoutReasons = new ArrayList<String>();
    private final Map<Long, String> myVcsRootOldRevisions = new TreeMap<Long, String>();
    private final Map<Long, String> myVcsRootCurrentRevisions = new TreeMap<Long, String>();
    private final List<ArtifactDependencyInfo> myArtifactDependencies = new ArrayList<ArtifactDependencyInfo>();
    private final List<VcsChangeInfo> myVcsChanges = new ArrayList<VcsChangeInfo>();
    private final List<VcsChangeInfo> myPersonalVcsChanges = new ArrayList<VcsChangeInfo>();
    private final List<String> myUserBuildParameters = new ArrayList<String>();
    private final Map<Option, Object> myBuildTypeOptions = new HashMap<Option, Object>();
    private String myVcsSettingsHashForServerCheckout;
    private String myVcsSettingsHashForAgentCheckout;
    private String myVcsSettingsHashForManualCheckout;
    private final List<BuildRunnerData> myBuildRunners = new ArrayList<BuildRunnerData>();
    private int myDefaultExecutionTimeout = 0;
    private final List<BuildFeatureInfo> myBuildFeatures = new ArrayList<BuildFeatureInfo>();
    private final List<String> myRequiredTools = new ArrayList<String>();
    @NotNull
    private final Map<String, String> myArtifactStorageSettings = new HashMap<String, String>();
    private String myOwnerNodeId;

    public AgentBuild(long buildId) {
        this.myBuildId = buildId;
    }

    public long getBuildId() {
        return this.myBuildId;
    }

    @NotNull
    public String getBuildTypeId() {
        String string = this.myBuildTypeId;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setBuildTypeId(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            AgentBuild.$$$reportNull$$$0(1);
        }
        this.myBuildTypeId = buildTypeId;
    }

    @NotNull
    public String getBuildTypeExternalId() {
        String string = this.myBuildTypeExternalId;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setBuildTypeExternalId(@NotNull String buildTypeExternalId) {
        if (buildTypeExternalId == null) {
            AgentBuild.$$$reportNull$$$0(3);
        }
        this.myBuildTypeExternalId = buildTypeExternalId;
    }

    public void setCheckoutDirectory(@Nullable String checkoutDirectory) {
        this.myCheckoutDir = checkoutDirectory;
    }

    public void setArtifactPaths(String artifactPaths) {
        this.myArtifactPaths = artifactPaths;
    }

    @Nullable
    public String getArtifactPaths() {
        return this.myArtifactPaths;
    }

    public boolean isPersonal() {
        return this.myPersonal;
    }

    public boolean isPersonalPatchAvailable() {
        return this.myPersonalPatchAvailable;
    }

    public void setPersonal(boolean personal) {
        this.myPersonal = personal;
    }

    public void setPersonalPatchAvailable(boolean personalPatchAvailable) {
        this.myPersonalPatchAvailable = personalPatchAvailable;
    }

    public void setBuildTypeOptions(@NotNull Map<Option, Object> options) {
        if (options == null) {
            AgentBuild.$$$reportNull$$$0(4);
        }
        this.myBuildTypeOptions.clear();
        this.myBuildTypeOptions.putAll(options);
    }

    public long getCleanCheckoutEnforcedBuildId() {
        return this.myCleanCheckoutEnforcedBuildId;
    }

    public void setCleanCheckoutEnforcedBuildId(long cleanCheckoutEnforcedBuildId) {
        this.myCleanCheckoutEnforcedBuildId = cleanCheckoutEnforcedBuildId;
    }

    public void setDefaultExecutionTimeout(int executionTimeout) {
        this.myDefaultExecutionTimeout = executionTimeout;
    }

    public int getDefaultExecutionTimeout() {
        return this.myDefaultExecutionTimeout;
    }

    @NotNull
    public String getAccessUser() {
        String string = BuildAuthUtil.makeUserId(this.myBuildId);
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getAccessCode() {
        String string = this.myAccessCode;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setAccessCode(@NotNull String accessCode) {
        if (accessCode == null) {
            AgentBuild.$$$reportNull$$$0(7);
        }
        this.myAccessCode = accessCode;
    }

    @NotNull
    public CheckoutType getCheckoutType() {
        CheckoutType checkoutType = this.myCheckoutType;
        if (checkoutType == null) {
            AgentBuild.$$$reportNull$$$0(8);
        }
        return checkoutType;
    }

    public void setCheckoutType(@NotNull CheckoutType checkoutType) {
        if (checkoutType == null) {
            AgentBuild.$$$reportNull$$$0(9);
        }
        this.myCheckoutType = checkoutType;
    }

    @NotNull
    public Map<String, String> getServerParameters() {
        Map<String, String> map = this.myServerParameters;
        if (map == null) {
            AgentBuild.$$$reportNull$$$0(10);
        }
        return map;
    }

    public void setServerParameters(@NotNull Map<String, String> serverParameters) {
        if (serverParameters == null) {
            AgentBuild.$$$reportNull$$$0(11);
        }
        this.myServerParameters.clear();
        this.myServerParameters.putAll(serverParameters);
    }

    public void setParametersSpecMap(Map<String, String> parametersSpecs) {
        this.myParametersSpecs.clear();
        this.myParametersSpecs.putAll(parametersSpecs);
    }

    public void setRequiredTools(Collection<String> requiredTools) {
        this.myRequiredTools.clear();
        this.myRequiredTools.addAll(requiredTools);
    }

    public List<String> getRequiredTools() {
        return this.myRequiredTools;
    }

    @NotNull
    public Map<String, String> getParametersSpecMap() {
        Map<String, String> map = this.myParametersSpecs;
        if (map == null) {
            AgentBuild.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public List<VcsRootEntry> getVcsRootEntries() {
        List<VcsRootEntry> list = this.myVcsRootEntries;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setVcsRootEntries(@NotNull List<? extends VcsRootEntry> vcsRootEntries) {
        if (vcsRootEntries == null) {
            AgentBuild.$$$reportNull$$$0(14);
        }
        this.myVcsRootEntries.clear();
        this.myVcsRootEntries.addAll(vcsRootEntries);
    }

    @Deprecated
    @Nullable
    public String getPreviousRevision(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            AgentBuild.$$$reportNull$$$0(15);
        }
        return this.myVcsRootOldRevisions.get(vcsRoot.getId());
    }

    @Deprecated
    public void setPreviousRevision(long vcsRootId, @Nullable String oldRevision) {
        if (oldRevision != null) {
            this.myVcsRootOldRevisions.put(vcsRootId, oldRevision);
        } else {
            this.myVcsRootOldRevisions.remove(vcsRootId);
        }
    }

    @Nullable
    public String getCurrentRevision(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            AgentBuild.$$$reportNull$$$0(16);
        }
        return this.myVcsRootCurrentRevisions.get(vcsRoot.getId());
    }

    public void setCurrentRevision(long vcsRootId, @Nullable String currentRevision) {
        if (currentRevision != null) {
            this.myVcsRootCurrentRevisions.put(vcsRootId, currentRevision);
        } else {
            this.myVcsRootCurrentRevisions.remove(vcsRootId);
        }
    }

    @NotNull
    public List<String> getFullCheckoutReasons() {
        List<String> list = this.myFullCheckoutReasons;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void addFullCheckoutReason(@NotNull String reason) {
        if (reason == null) {
            AgentBuild.$$$reportNull$$$0(18);
        }
        this.myFullCheckoutReasons.add(reason);
    }

    @NotNull
    public List<ArtifactDependencyInfo> getArtifactDependencies() {
        List<ArtifactDependencyInfo> list = this.myArtifactDependencies;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(19);
        }
        return list;
    }

    public void setArtifactDependencies(@NotNull List<ArtifactDependencyInfo> artifactDependencies) {
        if (artifactDependencies == null) {
            AgentBuild.$$$reportNull$$$0(20);
        }
        this.myArtifactDependencies.clear();
        this.myArtifactDependencies.addAll(artifactDependencies);
    }

    @Deprecated
    public void setDefaultCheckoutDirectory(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            AgentBuild.$$$reportNull$$$0(21);
        }
        this.setVcsSettingsHashForAgentCheckout(defaultDirNameRelativeToWorkingDir);
        this.setVcsSettingsHashForServerCheckout(defaultDirNameRelativeToWorkingDir);
        this.setVcsSettingsHashForManualCheckout(defaultDirNameRelativeToWorkingDir);
    }

    public void setVcsSettingsHashForAgentCheckout(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            AgentBuild.$$$reportNull$$$0(22);
        }
        this.myVcsSettingsHashForAgentCheckout = this.prepareDefaultCheckoutDir(defaultDirNameRelativeToWorkingDir);
    }

    public void setVcsSettingsHashForServerCheckout(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            AgentBuild.$$$reportNull$$$0(23);
        }
        this.myVcsSettingsHashForServerCheckout = this.prepareDefaultCheckoutDir(defaultDirNameRelativeToWorkingDir);
    }

    public void setVcsSettingsHashForManualCheckout(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            AgentBuild.$$$reportNull$$$0(24);
        }
        this.myVcsSettingsHashForManualCheckout = this.prepareDefaultCheckoutDir(defaultDirNameRelativeToWorkingDir);
    }

    @NotNull
    private String prepareDefaultCheckoutDir(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            AgentBuild.$$$reportNull$$$0(25);
        }
        String string = defaultDirNameRelativeToWorkingDir.replace(' ', '_').replace(':', ' ');
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getVcsSettingsHashForServerCheckout() {
        String string = this.myVcsSettingsHashForServerCheckout;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public String getVcsSettingsHashForAgentCheckout() {
        String string = this.myVcsSettingsHashForAgentCheckout;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String getVcsSettingsHashForManualCheckout() {
        String string = this.myVcsSettingsHashForManualCheckout;
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public String getCheckoutDirectory() {
        return this.myCheckoutDir;
    }

    @NotNull
    public List<BuildRunnerData> getBuildRunners() {
        List<BuildRunnerData> list = this.myBuildRunners;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(30);
        }
        return list;
    }

    public void setBuildRunners(@NotNull List<BuildRunnerData> settings) {
        if (settings == null) {
            AgentBuild.$$$reportNull$$$0(31);
        }
        this.myBuildRunners.clear();
        this.myBuildRunners.addAll(settings);
    }

    public List<BuildFeatureInfo> getBuildFeatures() {
        return this.myBuildFeatures;
    }

    public void setBuildFeatures(@NotNull List<BuildFeatureInfo> infos) {
        if (infos == null) {
            AgentBuild.$$$reportNull$$$0(32);
        }
        this.myBuildFeatures.clear();
        this.myBuildFeatures.addAll(infos);
    }

    @Nullable
    public <T> T getOptionValue(@NotNull Option<T> option) {
        Object value;
        if (option == null) {
            AgentBuild.$$$reportNull$$$0(33);
        }
        if ((value = this.myBuildTypeOptions.get(option)) == null) {
            return option.getDefaultValue();
        }
        return (T)value;
    }

    @NotNull
    public List<VcsChangeInfo> getVcsChanges() {
        List<VcsChangeInfo> list = this.myVcsChanges;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(34);
        }
        return list;
    }

    public void setVcsChanges(@NotNull List<VcsChangeInfo> vcsChanges) {
        if (vcsChanges == null) {
            AgentBuild.$$$reportNull$$$0(35);
        }
        this.myVcsChanges.clear();
        this.myVcsChanges.addAll(vcsChanges);
    }

    public void setPersonalVcsChanges(@NotNull List<VcsChangeInfo> vcsChanges) {
        if (vcsChanges == null) {
            AgentBuild.$$$reportNull$$$0(36);
        }
        this.myPersonalVcsChanges.clear();
        this.myPersonalVcsChanges.addAll(vcsChanges);
    }

    public void setUserBuildParameters(@NotNull Collection<String> userDefinedKeys) {
        if (userDefinedKeys == null) {
            AgentBuild.$$$reportNull$$$0(37);
        }
        this.myUserBuildParameters.clear();
        this.myUserBuildParameters.addAll(userDefinedKeys);
    }

    @NotNull
    public List<String> getUserBuildParameters() {
        List<String> list = Collections.unmodifiableList(this.myUserBuildParameters);
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public Collection<String> getUserDefinedReferences() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getReferences(this.myCheckoutDir));
        for (BuildRunnerData runner : this.myBuildRunners) {
            if (runner.isDisabled()) continue;
            for (Map.Entry<String, String> pe : runner.getRunnerParameters().entrySet()) {
                if (XmlUtil.isSecureParameter(pe.getKey())) continue;
                result.addAll(this.getReferences(pe.getValue()));
            }
        }
        for (ArtifactDependencyInfo adi : this.myArtifactDependencies) {
            result.addAll(adi.getReferences());
        }
        result.addAll(this.myUserBuildParameters);
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            AgentBuild.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @NotNull
    private Collection<String> getReferences(String value) {
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AgentBuild.$$$reportNull$$$0(40);
            }
            return list;
        }
        Set<String> set = ReferencesResolverUtil.getReferences(value);
        if (set == null) {
            AgentBuild.$$$reportNull$$$0(41);
        }
        return set;
    }

    public void setOwnerNodeId(String ownerNodeId) {
        this.myOwnerNodeId = ownerNodeId;
    }

    public String getOwnerNodeId() {
        return this.myOwnerNodeId;
    }

    @NotNull
    public Map<String, String> getArtifactStorageSettings() {
        Map<String, String> map = Collections.unmodifiableMap(this.myArtifactStorageSettings);
        if (map == null) {
            AgentBuild.$$$reportNull$$$0(42);
        }
        return map;
    }

    public void setArtifactStorageSettings(@NotNull Map<String, String> storageSettings) {
        if (storageSettings == null) {
            AgentBuild.$$$reportNull$$$0(43);
        }
        this.myArtifactStorageSettings.clear();
        this.myArtifactStorageSettings.putAll(storageSettings);
    }

    @NotNull
    public List<VcsChangeInfo> getPersonalVcsChanges() {
        List<VcsChangeInfo> list = this.myPersonalVcsChanges;
        if (list == null) {
            AgentBuild.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public String serialize() {
        String string = XStreamWrapper.serializeObject(this, AgentBuild.createXStreamHolder());
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static AgentBuild deserialize(@NotNull String serialized) {
        if (serialized == null) {
            AgentBuild.$$$reportNull$$$0(46);
        }
        AgentBuild agentBuild = (AgentBuild)XStreamWrapper.deserializeObject(serialized, AgentBuild.createXStreamHolder());
        if (agentBuild == null) {
            AgentBuild.$$$reportNull$$$0(47);
        }
        return agentBuild;
    }

    @NotNull
    private static XStreamHolder createXStreamHolder() {
        XStreamHolder xStreamHolder = new XStreamHolder(){

            @Override
            protected void configureXStream(XStream xStream) {
                xStream.alias("AgentBuild", AgentBuild.class);
                xStream.aliasType("VcsRootEntry", VcsRootEntry.class);
                xStream.alias("ArtifactDependency", ArtifactDependencyInfo.class);
                xStream.aliasType("File", VcsChangeInfo.class);
                xStream.aliasType("StringTreeMap", StringTreeMap.class);
                xStream.registerConverter((Converter)new VcsRootEntryConverter());
                xStream.registerConverter((Converter)new VcsChangeConverter());
                xStream.registerConverter((Converter)new StringTreeMapConverter());
            }
        };
        if (xStreamHolder == null) {
            AgentBuild.$$$reportNull$$$0(48);
        }
        return xStreamHolder;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentBuild");
        sb.append("{myAccessCode='").append(this.myAccessCode).append('\'');
        sb.append(", myBuildId=").append(this.myBuildId);
        sb.append(", myCheckoutDir='").append(this.myCheckoutDir).append('\'');
        sb.append(", myBuildTypeId='").append(this.myBuildTypeId).append('\'');
        sb.append(", myBuildTypeExternalId='").append(this.myBuildTypeExternalId).append('\'');
        sb.append(", myArtifactPaths='").append(this.myArtifactPaths).append('\'');
        sb.append(", myPersonal=").append(this.myPersonal);
        sb.append(", myCheckoutType=").append((Object)this.myCheckoutType);
        sb.append(", myServerParameters=").append(this.myServerParameters);
        sb.append(", myParametersSpecs=").append(this.myParametersSpecs);
        sb.append(", myVcsRootEntries=").append(this.myVcsRootEntries);
        sb.append(", myVcsRootCurrentRevisions=").append(this.myVcsRootCurrentRevisions);
        sb.append(", myArtifactDependencies=").append(this.myArtifactDependencies);
        sb.append(", myVcsChanges=").append(this.myVcsChanges);
        sb.append(", myPersonalVcsChanges=").append(this.myPersonalVcsChanges);
        sb.append(", myUserBuildParameters=").append(this.myUserBuildParameters);
        sb.append(", myBuildTypeOptions=").append(this.myBuildTypeOptions);
        sb.append(", myDefaultExecutionTimeout=").append(this.myDefaultExecutionTimeout);
        sb.append(", myVcsSettingsHashForAgentCheckout='").append(this.myVcsSettingsHashForAgentCheckout).append('\'');
        sb.append(", myVcsSettingsHashForServerCheckout='").append(this.myVcsSettingsHashForServerCheckout).append('\'');
        sb.append(", myVcsSettingsHashForManualCheckout='").append(this.myVcsSettingsHashForManualCheckout).append('\'');
        sb.append(", myBuildRunners=").append(this.myBuildRunners);
        sb.append(", myBuildFeatures=").append(this.myBuildFeatures);
        sb.append(", myOwnerNodeId=").append(this.myOwnerNodeId);
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(49);
        }
        return string;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("Build {");
        sb.append("id=").append(this.myBuildId);
        sb.append(", buildTypeId='").append(this.myBuildTypeExternalId).append('\'');
        sb.append(", buildTypeInternalId='").append(this.myBuildTypeId).append('\'');
        if (verbose) {
            sb.append(", personal=").append(this.myPersonal);
            sb.append(", checkoutType=").append((Object)this.myCheckoutType);
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            AgentBuild.$$$reportNull$$$0(50);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/agentServer/AgentBuild";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeExternalId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessCode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRootEntries";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDependencies";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDirNameRelativeToWorkingDir";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsChanges";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDefinedKeys";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageSettings";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeId";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/agentServer/AgentBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeExternalId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessUser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessCode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckoutType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersSpecMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRootEntries";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullCheckoutReasons";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDefaultCheckoutDir";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsSettingsHashForServerCheckout";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsSettingsHashForAgentCheckout";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsSettingsHashForManualCheckout";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildRunners";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsChanges";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserBuildParameters";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedReferences";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactStorageSettings";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersonalVcsChanges";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createXStreamHolder";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBuildTypeId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBuildTypeExternalId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBuildTypeOptions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAccessCode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCheckoutType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setServerParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setVcsRootEntries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousRevision";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFullCheckoutReason";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setArtifactDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCheckoutDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setVcsSettingsHashForAgentCheckout";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setVcsSettingsHashForServerCheckout";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setVcsSettingsHashForManualCheckout";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "prepareDefaultCheckoutDir";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setBuildRunners";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setBuildFeatures";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setVcsChanges";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setPersonalVcsChanges";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setUserBuildParameters";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setArtifactStorageSettings";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CheckoutType {
        AUTO,
        ON_SERVER,
        ON_AGENT,
        MANUAL;

    }
}

