/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.XmlUtil;
import jetbrains.buildServer.vcs.CheckoutRules;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentCheckoutDirRevisionInfo {
    private final List<VcsRootInstanceState> myInstancesStates;
    private final String myCheckoutDirPath;
    private final Map<String, Long> myLastBuilds;
    private final String myVcsSettingsHash;

    public static AgentCheckoutDirRevisionInfo createEmptyState() {
        return new AgentCheckoutDirRevisionInfo();
    }

    @NotNull
    public static AgentCheckoutDirRevisionInfo parseXml(@NotNull Reader reader) throws IOException {
        Object object;
        if (reader == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(0);
        }
        try {
            Element state = FileUtil.parseDocument(reader, false);
            String checkoutDirPath = state.getChild("CheckoutDirPath").getText();
            String vcsSettingsHash = state.getChild("VcsSettingsHash").getText();
            HashMap<String, Long> buildsMap = new HashMap<String, Long>();
            Element buildHistory = state.getChild("BuildHistory");
            if (buildHistory != null) {
                List builds = buildHistory.getChildren("Build");
                for (Object buildObj : builds) {
                    Element build = (Element)buildObj;
                    buildsMap.put(build.getChild("BuildTypeId").getText(), Long.parseLong(build.getChild("BuildId").getText()));
                }
            }
            AgentCheckoutDirRevisionInfo result = new AgentCheckoutDirRevisionInfo(checkoutDirPath, vcsSettingsHash, buildsMap);
            List vcsRootsList = state.getChild("VcsRoots").getChildren("VcsRoot");
            for (Object elementObj : vcsRootsList) {
                Element vcsRoot = (Element)elementObj;
                result.addVcsRootInstanceState(vcsRoot.getChild("Revision").getText(), vcsRoot.getChild("VcsRootSettings").getText(), new CheckoutRules(vcsRoot.getChild("CheckoutRules").getText()));
            }
            AgentCheckoutDirRevisionInfo agentCheckoutDirRevisionInfo = result;
            object = agentCheckoutDirRevisionInfo;
        }
        catch (Exception e) {
            throw new IOException("An error occurred while trying to deserialize AgentCheckoutDirRevisionInfo", e);
        }
        finally {
            FileUtil.close(reader);
        }
        if (object == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(1);
        }
        return object;
    }

    private AgentCheckoutDirRevisionInfo() {
        this.myInstancesStates = Collections.emptyList();
        this.myCheckoutDirPath = "";
        this.myVcsSettingsHash = "";
        this.myLastBuilds = Collections.emptyMap();
    }

    private AgentCheckoutDirRevisionInfo(String checkoutDirPath, String vcsSettingsHash, Map<String, Long> lastBuilds) {
        this.myInstancesStates = new ArrayList<VcsRootInstanceState>();
        this.myCheckoutDirPath = checkoutDirPath;
        this.myVcsSettingsHash = vcsSettingsHash;
        this.myLastBuilds = lastBuilds;
    }

    public AgentCheckoutDirRevisionInfo(@NotNull File checkoutDir, @NotNull File agentWorkdir, @NotNull String vcsSettingsHash) {
        if (checkoutDir == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(2);
        }
        if (agentWorkdir == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(3);
        }
        if (vcsSettingsHash == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(4);
        }
        this(FileUtil.getNameOrAbsolutePath(agentWorkdir, checkoutDir), vcsSettingsHash, new HashMap<String, Long>());
    }

    /*
     * WARNING - void declaration
     */
    public AgentCheckoutDirRevisionInfo(@NotNull AgentCheckoutDirRevisionInfo oldInfo, @NotNull String vcsSettingsHash, @NotNull String buildTypeId, long buildId, boolean bl) {
        void fullCheckout;
        if (oldInfo == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(5);
        }
        if (vcsSettingsHash == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(6);
        }
        if (buildTypeId == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(7);
        }
        this(oldInfo.getCheckoutDirPath(), vcsSettingsHash, (Map<String, Long>)new HashMap<String, Long>((boolean)fullCheckout, vcsSettingsHash, oldInfo){
            final /* synthetic */ boolean val$fullCheckout;
            final /* synthetic */ String val$vcsSettingsHash;
            final /* synthetic */ AgentCheckoutDirRevisionInfo val$oldInfo;
            {
                this.val$fullCheckout = bl;
                this.val$vcsSettingsHash = string;
                this.val$oldInfo = agentCheckoutDirRevisionInfo;
                if (!this.val$fullCheckout && this.val$vcsSettingsHash.equals(this.val$oldInfo.getVcsSettingsHash())) {
                    this.putAll(this.val$oldInfo.myLastBuilds);
                }
            }
        });
        this.myLastBuilds.put(buildTypeId, buildId);
    }

    public List<VcsRootInstanceState> getInstancesStates() {
        return this.myInstancesStates;
    }

    public String getVcsSettingsHash() {
        return this.myVcsSettingsHash;
    }

    public long getLastBuildByType(@NotNull String buildTypeId) {
        Long value;
        if (buildTypeId == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(8);
        }
        return (value = this.myLastBuilds.get(buildTypeId)) == null ? 0L : value;
    }

    public long getFirstBuildId() {
        if (this.myLastBuilds.size() > 0) {
            return Collections.min(this.myLastBuilds.values());
        }
        return 0L;
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null ")
    public VcsRootInstanceState addVcsRootInstanceState(@Nullable String revision, @NotNull String vcsRootSettingsHash, @NotNull CheckoutRules checkoutRules) {
        if (vcsRootSettingsHash == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(9);
        }
        if (checkoutRules == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(10);
        }
        if (revision == null) {
            return null;
        }
        VcsRootInstanceState instanceState = new VcsRootInstanceState(vcsRootSettingsHash, revision, checkoutRules);
        this.myInstancesStates.add(instanceState);
        return instanceState;
    }

    private Document getDocument() {
        try {
            Document document = new Document();
            Element state = new Element("CheckoutDirectoryState");
            document.setRootElement(state);
            state.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("VcsSettingsHash", this.getVcsSettingsHash()));
            state.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("CheckoutDirPath", this.getCheckoutDirPath()));
            Element buildHistory = new Element("BuildHistory");
            state.addContent((Content)buildHistory);
            for (Map.Entry<String, Long> entry : this.myLastBuilds.entrySet()) {
                Element build = new Element("Build");
                build.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("BuildTypeId", entry.getKey()));
                build.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("BuildId", entry.getValue().toString()));
                buildHistory.addContent((Content)build);
            }
            Element revisions = new Element("VcsRoots");
            state.addContent((Content)revisions);
            for (VcsRootInstanceState instanceState : this.myInstancesStates) {
                Element revision = new Element("VcsRoot");
                revisions.addContent((Content)revision);
                revision.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("VcsRootSettings", String.valueOf(instanceState.getVcsRootSignature())));
                revision.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("Revision", instanceState.getRevision()));
                revision.addContent((Content)AgentCheckoutDirRevisionInfo.appendElementWithText("CheckoutRules", instanceState.getCheckoutRules().getAsString()));
            }
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred during serialization", e);
        }
    }

    public String serializeToXml() {
        return XmlUtil.toString(this.getDocument());
    }

    public void store(@NotNull File file) throws IOException {
        if (file == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(11);
        }
        FileUtil.saveDocument(this.getDocument(), file);
    }

    @NotNull
    public String getCheckoutDirPath() {
        String string = this.myCheckoutDirPath;
        if (string == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myInstancesStates.size() == 0;
    }

    public Map<String, String> createRevisionsMap() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (VcsRootInstanceState instancesState : this.myInstancesStates) {
            retVal.put(instancesState.getVcsRootSignature(), instancesState.getRevision());
        }
        return retVal;
    }

    public File getCheckoutDir(@NotNull File agentWorkDir) {
        if (agentWorkDir == null) {
            AgentCheckoutDirRevisionInfo.$$$reportNull$$$0(13);
        }
        if (FileUtil.isAbsolute((String)this.getCheckoutDirPath())) {
            return new File(this.getCheckoutDirPath());
        }
        return new File(agentWorkDir, this.getCheckoutDirPath());
    }

    private static Element appendElementWithText(String elementName, String elementValue) {
        return new Element(elementName).setText(elementValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentCheckoutDirRevisionInfo)) {
            return false;
        }
        AgentCheckoutDirRevisionInfo that = (AgentCheckoutDirRevisionInfo)o;
        if (!this.myCheckoutDirPath.equals(that.myCheckoutDirPath)) {
            return false;
        }
        if (!this.myInstancesStates.equals(that.myInstancesStates)) {
            return false;
        }
        if (!this.myLastBuilds.equals(that.myLastBuilds)) {
            return false;
        }
        return this.myVcsSettingsHash.equals(that.myVcsSettingsHash);
    }

    public int hashCode() {
        int result = this.myInstancesStates.hashCode();
        result = 31 * result + this.myCheckoutDirPath.hashCode();
        result = 31 * result + this.myLastBuilds.hashCode();
        result = 31 * result + this.myVcsSettingsHash.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentWorkdir";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettingsHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRootSettingsHash";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkoutRules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentWorkDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseXml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckoutDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseXml";
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastBuildByType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addVcsRootInstanceState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCheckoutDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VcsRootInstanceState {
        private final String myVcsRootSignature;
        private final String myRevision;
        private final CheckoutRules myCheckoutRules;

        public VcsRootInstanceState(@NotNull String vcsRootSignature, @NotNull String revision, @NotNull CheckoutRules checkoutRules) {
            if (vcsRootSignature == null) {
                VcsRootInstanceState.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                VcsRootInstanceState.$$$reportNull$$$0(1);
            }
            if (checkoutRules == null) {
                VcsRootInstanceState.$$$reportNull$$$0(2);
            }
            this.myVcsRootSignature = vcsRootSignature;
            this.myRevision = StringUtil.isEmpty((String)revision) ? null : revision;
            this.myCheckoutRules = checkoutRules;
        }

        public String getVcsRootSignature() {
            return this.myVcsRootSignature;
        }

        public String getRevision() {
            return this.myRevision;
        }

        public CheckoutRules getCheckoutRules() {
            return this.myCheckoutRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VcsRootInstanceState)) {
                return false;
            }
            VcsRootInstanceState that = (VcsRootInstanceState)o;
            if (!this.myVcsRootSignature.equals(that.myVcsRootSignature)) {
                return false;
            }
            if (!this.myCheckoutRules.getAsString().equals(that.myCheckoutRules.getAsString())) {
                return false;
            }
            return this.myRevision.equals(that.myRevision);
        }

        public int hashCode() {
            int result = this.myVcsRootSignature.hashCode();
            result = 31 * result + this.myRevision.hashCode();
            result = 31 * result + this.myCheckoutRules.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcsRootSignature";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "checkoutRules";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

