/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.buildServer.agentServer.DetailsSerializationUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentDetails {
    @NotNull
    private final String myAgentName;
    @Nullable
    private String myAgentAddress;
    private final int myAgentPort;
    private Integer myAgentId;
    @NotNull
    private String myAuthorizationToken;
    @NotNull
    private final String myPingCode;
    @Nullable
    private Long myBuildId;
    @Nullable
    private String myOsName;
    private final Collection<String> myAvailableRunners;
    private final Collection<String> myAvailableVcsPlugins;
    private final List<String> myAlternativeAddresses;
    private final Map<String, String> myConfigParameters;
    private final Map<String, String> myBuildParameters;
    private String myVersion;
    private String myPluginsVersion;

    public AgentDetails(@NotNull String agentName, @Nullable String agentAddress, int agentPort, @NotNull String authorizationToken, @NotNull String pingCode) {
        if (agentName == null) {
            AgentDetails.$$$reportNull$$$0(0);
        }
        if (authorizationToken == null) {
            AgentDetails.$$$reportNull$$$0(1);
        }
        if (pingCode == null) {
            AgentDetails.$$$reportNull$$$0(2);
        }
        this.myAvailableRunners = new ArrayList<String>();
        this.myAvailableVcsPlugins = new ArrayList<String>();
        this.myAlternativeAddresses = new ArrayList<String>();
        this.myConfigParameters = new TreeMap<String, String>();
        this.myBuildParameters = new TreeMap<String, String>();
        this.myVersion = "0";
        this.myPluginsVersion = "0";
        this.myAgentName = agentName;
        this.myAgentAddress = agentAddress;
        this.myAgentPort = agentPort;
        this.myAuthorizationToken = authorizationToken;
        this.myPingCode = pingCode;
    }

    public Integer getAgentId() {
        return this.myAgentId;
    }

    public void setAgentId(@Nullable Integer agentId) {
        this.myAgentId = agentId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    @NotNull
    public Map<String, String> getConfigParameters() {
        Map<String, String> map = Collections.unmodifiableMap(this.myConfigParameters);
        if (map == null) {
            AgentDetails.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getBuildParameters() {
        Map<String, String> map = Collections.unmodifiableMap(this.myBuildParameters);
        if (map == null) {
            AgentDetails.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setConfigParameters(@NotNull Map<String, String> configParameters) {
        if (configParameters == null) {
            AgentDetails.$$$reportNull$$$0(5);
        }
        this.myConfigParameters.clear();
        this.myConfigParameters.putAll(configParameters);
    }

    public void setBuildParameters(@NotNull Map<String, String> buildParameters) {
        if (buildParameters == null) {
            AgentDetails.$$$reportNull$$$0(6);
        }
        this.myBuildParameters.clear();
        this.myBuildParameters.putAll(buildParameters);
    }

    @NotNull
    public List<String> getAlternativeAddresses() {
        List<String> list = this.myAlternativeAddresses;
        if (list == null) {
            AgentDetails.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setAlternativeAddresses(@NotNull List<String> addresses) {
        if (addresses == null) {
            AgentDetails.$$$reportNull$$$0(8);
        }
        this.myAlternativeAddresses.clear();
        this.myAlternativeAddresses.addAll(addresses);
    }

    @NotNull
    public String getAgentName() {
        String string = this.myAgentName;
        if (string == null) {
            AgentDetails.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getAgentAddress() {
        return this.myAgentAddress;
    }

    public void setAgentAddress(@Nullable String agentAddress) {
        this.myAgentAddress = agentAddress;
    }

    public int getAgentPort() {
        return this.myAgentPort;
    }

    @NotNull
    public String getAuthorizationToken() {
        String string = this.myAuthorizationToken;
        if (string == null) {
            AgentDetails.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setAuthorizationToken(@NotNull String authorizationToken) {
        if (authorizationToken == null) {
            AgentDetails.$$$reportNull$$$0(11);
        }
        this.myAuthorizationToken = authorizationToken;
    }

    public void setServerInferredAgentAddress(@NotNull String address) {
        boolean exists;
        if (address == null) {
            AgentDetails.$$$reportNull$$$0(12);
        }
        if (exists = this.myAlternativeAddresses.remove(address)) {
            this.myAlternativeAddresses.add(0, address);
        } else {
            this.myAlternativeAddresses.add(address);
        }
    }

    @NotNull
    public String getPingCode() {
        String string = this.myPingCode;
        if (string == null) {
            AgentDetails.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public String getOsName() {
        return this.myOsName;
    }

    public int getCpuBenchmarkIndex() {
        try {
            String index = this.getBuildParameters().get("system.teamcity.agent.cpuBenchmark");
            return index == null ? -1 : Integer.parseInt(index);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setOsName(@Nullable String osName) {
        this.myOsName = osName;
    }

    @NotNull
    public String getAgentVersion() {
        String string = this.myVersion;
        if (string == null) {
            AgentDetails.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setAgentVersion(@NotNull String version) {
        if (version == null) {
            AgentDetails.$$$reportNull$$$0(15);
        }
        this.myVersion = version;
    }

    @NotNull
    public String getPluginsVersion() {
        String string = this.myPluginsVersion;
        if (string == null) {
            AgentDetails.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setPluginsVersion(@NotNull String pluginsVersion) {
        if (pluginsVersion == null) {
            AgentDetails.$$$reportNull$$$0(17);
        }
        this.myPluginsVersion = pluginsVersion;
    }

    @Nullable
    public Long getBuildId() {
        return this.myBuildId;
    }

    public void setBuildId(@Nullable Long buildId) {
        this.myBuildId = buildId;
    }

    @NotNull
    public Collection<String> getAvailableRunners() {
        Collection<String> collection = this.myAvailableRunners;
        if (collection == null) {
            AgentDetails.$$$reportNull$$$0(18);
        }
        return collection;
    }

    public void setAvailableRunners(@NotNull Collection<String> availableRunners) {
        if (availableRunners == null) {
            AgentDetails.$$$reportNull$$$0(19);
        }
        this.myAvailableRunners.clear();
        this.myAvailableRunners.addAll(availableRunners);
    }

    @NotNull
    public Collection<String> getAvailableVcsPlugins() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myAvailableVcsPlugins);
        if (collection == null) {
            AgentDetails.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public void setAvailableVcsPlugins(@NotNull Collection<String> available) {
        if (available == null) {
            AgentDetails.$$$reportNull$$$0(21);
        }
        this.myAvailableVcsPlugins.clear();
        this.myAvailableVcsPlugins.addAll(available);
    }

    public String serializeToOldString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try {
            XmlUtil.saveDocument(this.serializeToDocument(), bos);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return bos.toString();
    }

    public String serializeToString() {
        try {
            return DetailsSerializationUtil.saveDocument(this.serializeToDocument());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document serializeToDocument() {
        Element rootElement = new Element("agentDetails");
        Document document = new Document(rootElement);
        rootElement.setAttribute("agentName", this.myAgentName);
        if (this.myAgentAddress != null) {
            rootElement.setAttribute("agentAddress", this.myAgentAddress);
        }
        rootElement.setAttribute("agentPort", String.valueOf(this.myAgentPort));
        rootElement.setAttribute("authToken", this.myAuthorizationToken);
        rootElement.setAttribute("pingCode", this.myPingCode);
        if (this.myBuildId != null) {
            rootElement.setAttribute("buildId", this.myBuildId.toString());
        }
        if (this.myAgentId != null) {
            rootElement.setAttribute("agentId", this.myAgentId.toString());
        }
        Element alternativeAddresses = new Element("alternativeAddresses");
        for (String string : this.myAlternativeAddresses) {
            Element element = new Element("address");
            element.setText(string);
            alternativeAddresses.addContent((Content)element);
        }
        rootElement.addContent((Content)alternativeAddresses);
        Element runners = new Element("availableRunners");
        for (String string : this.myAvailableRunners) {
            Element runnerEl = new Element("runner");
            runnerEl.setAttribute("runType", string);
            runners.addContent((Content)runnerEl);
        }
        rootElement.addContent((Content)runners);
        Element element = new Element("availableVcs");
        for (String runner : this.myAvailableVcsPlugins) {
            Element runnerEl = new Element("vcs");
            runnerEl.setAttribute("name", runner);
            element.addContent((Content)runnerEl);
        }
        rootElement.addContent((Content)element);
        AgentDetails.mapToElement(this.myBuildParameters, "buildParameters", rootElement);
        AgentDetails.mapToElement(this.myConfigParameters, "configParameters", rootElement);
        if (this.myOsName != null) {
            rootElement.setAttribute("osName", this.myOsName);
        }
        if (this.myVersion != null || this.myPluginsVersion != null) {
            Element element2 = new Element("version");
            AgentDetails.saveAttribute(element2, "agent", this.myVersion);
            AgentDetails.saveAttribute(element2, "plugins", this.myPluginsVersion);
            rootElement.addContent((Content)element2);
        }
        return document;
    }

    private static void saveAttribute(Element rootElement, String key, String tok) {
        if (tok != null) {
            rootElement.setAttribute(key, tok);
        }
    }

    @NotNull
    public static AgentDetails deserializeFromOldString(@NotNull String serialized) {
        AgentDetails agentDetails;
        if (serialized == null) {
            AgentDetails.$$$reportNull$$$0(22);
        }
        try {
            agentDetails = AgentDetails.deserializeString(new String(serialized.getBytes("UTF-8"), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (agentDetails == null) {
            AgentDetails.$$$reportNull$$$0(23);
        }
        return agentDetails;
    }

    @NotNull
    public static AgentDetails deserializeString(@NotNull String serialized) {
        AgentDetails agentDetails;
        if (serialized == null) {
            AgentDetails.$$$reportNull$$$0(24);
        }
        try {
            agentDetails = AgentDetails.deserializeFromDocument(DetailsSerializationUtil.loadDocument(serialized));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (agentDetails == null) {
            AgentDetails.$$$reportNull$$$0(25);
        }
        return agentDetails;
    }

    private static AgentDetails deserializeFromDocument(Document doc) {
        Element altAddresses;
        String agentIdStr;
        Element rootElem = doc.getRootElement();
        AgentDetails ad = new AgentDetails(rootElem.getAttributeValue("agentName"), rootElem.getAttributeValue("agentAddress"), Integer.parseInt(rootElem.getAttributeValue("agentPort")), rootElem.getAttributeValue("authToken"), StringUtil.notNullize((String)rootElem.getAttributeValue("pingCode")));
        String buildIdStr = rootElem.getAttributeValue("buildId");
        if (buildIdStr != null) {
            ad.setBuildId(Long.parseLong(buildIdStr));
        }
        if ((agentIdStr = rootElem.getAttributeValue("agentId")) != null) {
            ad.setAgentId(Integer.parseInt(agentIdStr));
        }
        if ((altAddresses = rootElem.getChild("alternativeAddresses")) != null) {
            ArrayList<String> alternativeAddresses = new ArrayList<String>();
            for (Object o : altAddresses.getChildren("address")) {
                Element el = (Element)o;
                alternativeAddresses.add(el.getTextTrim());
            }
            ad.setAlternativeAddresses(alternativeAddresses);
        }
        Element availableRunners = rootElem.getChild("availableRunners");
        ArrayList<String> runners = new ArrayList<String>();
        if (availableRunners != null) {
            for (Object r : availableRunners.getChildren("runner")) {
                Element runnerEl = (Element)r;
                runners.add(runnerEl.getAttributeValue("runType"));
            }
        }
        ad.setAvailableRunners(runners);
        Element availableVcs = rootElem.getChild("availableVcs");
        ArrayList<String> vcses = new ArrayList<String>();
        if (availableVcs != null) {
            for (Object r : availableVcs.getChildren("vcs")) {
                Element runnerEl = (Element)r;
                vcses.add(runnerEl.getAttributeValue("name"));
            }
        }
        ad.setAvailableVcsPlugins(vcses);
        ad.setOsName(rootElem.getAttributeValue("osName"));
        Map<String, String> buildParameters = AgentDetails.elementToMap(rootElem, "buildParameters");
        Map<String, String> configParameters = AgentDetails.elementToMap(rootElem, "configParameters");
        if (buildParameters.size() == 0 && configParameters.size() == 0) {
            TreeMap<String, String> allMap = new TreeMap<String, String>();
            allMap.putAll(AgentDetails.elementToMap(rootElem, "definedParameters"));
            allMap.putAll(AgentDetails.elementToMap(rootElem, "availableParameters"));
            for (Map.Entry entry : allMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.startsWith("system.") || key.startsWith("env.")) {
                    buildParameters.put(key, value);
                    continue;
                }
                configParameters.put(key, value);
            }
        }
        ad.setBuildParameters(buildParameters);
        ad.setConfigParameters(configParameters);
        Element version = rootElem.getChild("version");
        if (version == null) {
            ad.setAgentVersion("pre5.0");
            ad.setPluginsVersion("pre5.0");
        } else {
            ad.setAgentVersion(version.getAttributeValue("agent"));
            ad.setPluginsVersion(version.getAttributeValue("plugins"));
        }
        return ad;
    }

    private static void mapToElement(@NotNull Map<String, String> map, @NotNull String elementName, @NotNull Element rootElement) {
        if (map == null) {
            AgentDetails.$$$reportNull$$$0(26);
        }
        if (elementName == null) {
            AgentDetails.$$$reportNull$$$0(27);
        }
        if (rootElement == null) {
            AgentDetails.$$$reportNull$$$0(28);
        }
        Element definedParams = new Element(elementName);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            XmlUtil.writeParameter(definedParams, entry.getKey(), entry.getValue());
        }
        rootElement.addContent((Content)definedParams);
    }

    @NotNull
    private static Map<String, String> elementToMap(@NotNull Element rootElem, @NotNull String elementName) {
        if (rootElem == null) {
            AgentDetails.$$$reportNull$$$0(29);
        }
        if (elementName == null) {
            AgentDetails.$$$reportNull$$$0(30);
        }
        Element availableParams = rootElem.getChild(elementName);
        TreeMap<String, String> availableParamsMap = new TreeMap<String, String>();
        if (availableParams != null) {
            for (Object p : availableParams.getChildren("param")) {
                Element paramEl = (Element)p;
                Pair<String, String> param = XmlUtil.readParameter(paramEl);
                availableParamsMap.put((String)param.getFirst(), (String)param.getSecond());
            }
        }
        TreeMap<String, String> treeMap = availableParamsMap;
        if (treeMap == null) {
            AgentDetails.$$$reportNull$$$0(31);
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentDetails");
        sb.append("{Name='").append(this.myAgentName).append('\'');
        sb.append(", AgentId=").append(this.myAgentId);
        sb.append(", BuildId=").append(this.myBuildId);
        sb.append(", AgentOwnAddress='").append(this.myAgentAddress).append('\'');
        sb.append(", AlternativeAddresses=").append(this.myAlternativeAddresses);
        sb.append(", Port=").append(this.myAgentPort);
        sb.append(", Version='").append(this.myVersion).append('\'');
        sb.append(", PluginsVersion='").append(this.myPluginsVersion).append('\'');
        sb.append(", AvailableRunners=").append(this.myAvailableRunners);
        sb.append(", AvailableVcs=").append(this.myAvailableVcsPlugins);
        sb.append(", AuthorizationToken='").append(this.myAuthorizationToken).append('\'');
        sb.append(", PingCode='").append(this.myPingCode).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentDetails that = (AgentDetails)o;
        if (this.myAgentPort != that.myAgentPort) {
            return false;
        }
        if (this.myAgentAddress != null ? !this.myAgentAddress.equals(that.myAgentAddress) : that.myAgentAddress != null) {
            return false;
        }
        if (this.myAgentId != null ? !this.myAgentId.equals(that.myAgentId) : that.myAgentId != null) {
            return false;
        }
        if (!this.myAgentName.equals(that.myAgentName)) {
            return false;
        }
        if (!this.myAlternativeAddresses.equals(that.myAlternativeAddresses)) {
            return false;
        }
        if (!this.myAuthorizationToken.equals(that.myAuthorizationToken)) {
            return false;
        }
        if (!this.myAvailableRunners.equals(that.myAvailableRunners)) {
            return false;
        }
        if (!this.myAvailableVcsPlugins.equals(that.myAvailableVcsPlugins)) {
            return false;
        }
        if (this.myBuildId != null ? !this.myBuildId.equals(that.myBuildId) : that.myBuildId != null) {
            return false;
        }
        if (!this.myBuildParameters.equals(that.myBuildParameters)) {
            return false;
        }
        if (!this.myConfigParameters.equals(that.myConfigParameters)) {
            return false;
        }
        if (this.myOsName != null ? !this.myOsName.equals(that.myOsName) : that.myOsName != null) {
            return false;
        }
        if (!this.myPingCode.equals(that.myPingCode)) {
            return false;
        }
        if (this.myPluginsVersion != null ? !this.myPluginsVersion.equals(that.myPluginsVersion) : that.myPluginsVersion != null) {
            return false;
        }
        return !(this.myVersion == null ? that.myVersion != null : !this.myVersion.equals(that.myVersion));
    }

    public int hashCode() {
        int result = this.myAgentName.hashCode();
        result = 31 * result + (this.myAgentAddress != null ? this.myAgentAddress.hashCode() : 0);
        result = 31 * result + this.myAgentPort;
        result = 31 * result + (this.myAgentId != null ? this.myAgentId.hashCode() : 0);
        result = 31 * result + this.myAuthorizationToken.hashCode();
        result = 31 * result + this.myPingCode.hashCode();
        result = 31 * result + (this.myBuildId != null ? this.myBuildId.hashCode() : 0);
        result = 31 * result + (this.myOsName != null ? this.myOsName.hashCode() : 0);
        result = 31 * result + this.myAvailableRunners.hashCode();
        result = 31 * result + this.myAvailableVcsPlugins.hashCode();
        result = 31 * result + this.myAlternativeAddresses.hashCode();
        result = 31 * result + this.myConfigParameters.hashCode();
        result = 31 * result + this.myBuildParameters.hashCode();
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myPluginsVersion != null ? this.myPluginsVersion.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentName";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorizationToken";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingCode";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/agentServer/AgentDetails";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addresses";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsVersion";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableRunners";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "available";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/agentServer/AgentDetails";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlternativeAddresses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorizationToken";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPingCode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRunners";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableVcsPlugins";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeFromOldString";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeString";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "elementToMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setConfigParameters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setBuildParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAlternativeAddresses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setAuthorizationToken";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setServerInferredAgentAddress";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAgentVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPluginsVersion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableRunners";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableVcsPlugins";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFromOldString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deserializeString";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mapToElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "elementToMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

