/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.io.File;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.agentServer.RemoteFileStructureUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileStructure {
    private static final long FETCHED_DIRECTORY_SIZE = -1L;
    private static final long NOT_FETCHED_DIRECTORY_SIZE = -2L;
    private final String myFullRemoteName;
    private long mySize;
    private List<RemoteFileStructure> myChildren;
    private RemoteFileStructureUpdater myRemoteUpdater;

    public RemoteFileStructure(@NotNull String fullRemoteName, @Nullable List<RemoteFileStructure> children, long size) {
        if (fullRemoteName == null) {
            RemoteFileStructure.$$$reportNull$$$0(0);
        }
        this.myFullRemoteName = fullRemoteName;
        this.mySize = size;
        this.myChildren = children;
    }

    @NotNull
    public static RemoteFileStructure createForFile(@NotNull File file) {
        if (file == null) {
            RemoteFileStructure.$$$reportNull$$$0(1);
        }
        RemoteFileStructure remoteFileStructure = new RemoteFileStructure(file.getAbsolutePath(), null, file.length());
        if (remoteFileStructure == null) {
            RemoteFileStructure.$$$reportNull$$$0(2);
        }
        return remoteFileStructure;
    }

    @NotNull
    public static RemoteFileStructure createForFetchedDirectory(@NotNull File directory, @NotNull List<RemoteFileStructure> children) {
        if (directory == null) {
            RemoteFileStructure.$$$reportNull$$$0(3);
        }
        if (children == null) {
            RemoteFileStructure.$$$reportNull$$$0(4);
        }
        RemoteFileStructure remoteFileStructure = new RemoteFileStructure(directory.getAbsolutePath(), children, -1L);
        if (remoteFileStructure == null) {
            RemoteFileStructure.$$$reportNull$$$0(5);
        }
        return remoteFileStructure;
    }

    public static RemoteFileStructure createForNotFetchedDirectory(@NotNull File directory) {
        if (directory == null) {
            RemoteFileStructure.$$$reportNull$$$0(6);
        }
        return new RemoteFileStructure(directory.getAbsolutePath(), null, -2L);
    }

    @NotNull
    public String getFullRemoteName() {
        String string = this.myFullRemoteName;
        if (string == null) {
            RemoteFileStructure.$$$reportNull$$$0(7);
        }
        return string;
    }

    public long getSize() {
        return this.mySize;
    }

    public boolean isDirectory() {
        return this.mySize < 0L;
    }

    @NotNull
    public List<RemoteFileStructure> getChildren() {
        if (!this.isDirectory()) {
            List<RemoteFileStructure> list = Collections.emptyList();
            if (list == null) {
                RemoteFileStructure.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (this.mySize == -1L) {
            List<RemoteFileStructure> list = this.myChildren;
            if (list == null) {
                RemoteFileStructure.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (this.mySize == -2L) {
            assert (this.myRemoteUpdater != null);
            List<RemoteFileStructure> children = this.myRemoteUpdater.getChildren(this.myFullRemoteName);
            this.myChildren = children;
            this.mySize = -1L;
            List<RemoteFileStructure> list = children;
            if (list == null) {
                RemoteFileStructure.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<RemoteFileStructure> list = Collections.emptyList();
        if (list == null) {
            RemoteFileStructure.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setRemoteUpdater(@NotNull RemoteFileStructureUpdater remoteUpdater) {
        if (remoteUpdater == null) {
            RemoteFileStructure.$$$reportNull$$$0(12);
        }
        this.myRemoteUpdater = remoteUpdater;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullRemoteName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/agentServer/RemoteFileStructure";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/agentServer/RemoteFileStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createForFetchedDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullRemoteName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createForFile";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForFetchedDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForNotFetchedDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteUpdater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

