/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import jetbrains.buildServer.vcs.VcsChange;
import jetbrains.buildServer.vcs.VcsChangeInfo;

public class VcsChangeConverter
implements Converter {
    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        VcsChangeInfo vcsChange = (VcsChangeInfo)o;
        writer.addAttribute("type", vcsChange.getType().name());
        if (vcsChange.getChangeTypeName() != null) {
            writer.addAttribute("cht", vcsChange.getChangeTypeName());
        }
        if (vcsChange.getBeforeChangeRevisionNumber() != null) {
            writer.addAttribute("bref", vcsChange.getBeforeChangeRevisionNumber());
        }
        if (vcsChange.getAfterChangeRevisionNumber() != null) {
            writer.addAttribute("aref", vcsChange.getAfterChangeRevisionNumber());
        }
        writer.startNode("fn");
        writer.setValue(vcsChange.getFileName());
        writer.endNode();
        if (!vcsChange.getRelativeFileName().equals(vcsChange.getFileName())) {
            writer.startNode("relfn");
            writer.setValue(vcsChange.getRelativeFileName());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        VcsChangeInfo.Type changeType = VcsChangeInfo.Type.valueOf(reader.getAttribute("type"));
        String changeTypeName = reader.getAttribute("cht");
        String beforeRev = reader.getAttribute("bref");
        String afterRev = reader.getAttribute("aref");
        reader.moveDown();
        String fileName = reader.getValue();
        reader.moveUp();
        String relativeFileName = fileName;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            relativeFileName = reader.getValue();
            reader.moveUp();
        }
        return new VcsChange(changeType, changeTypeName, fileName, relativeFileName, beforeRev, afterRev);
    }

    public boolean canConvert(Class aClass) {
        return VcsChangeInfo.class.isAssignableFrom(aClass);
    }
}

