/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.Function;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;
import jetbrains.buildServer.vcs.VcsUtil;
import org.jetbrains.annotations.NotNull;

class VcsRootEntryConverter
implements Converter {
    VcsRootEntryConverter() {
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        VcsRootEntry vcsRootEntry = (VcsRootEntry)o;
        writer.startNode("vcsRoot");
        writer.addAttribute("id", String.valueOf(vcsRootEntry.getVcsRoot().getId()));
        writer.setValue(VcsUtil.convertVcsRootToString(vcsRootEntry.getVcsRoot(), new Function<String, String>(){

            @Override
            public String apply(String value) {
                return EncryptUtil.scramble(value);
            }
        }));
        writer.endNode();
        writer.startNode("checkoutRules");
        writer.setValue(vcsRootEntry.getCheckoutRules().getAsString());
        writer.endNode();
        writer.startNode("signature");
        writer.setValue(vcsRootEntry.getSignature());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        reader.moveDown();
        long vcsRootId = Long.parseLong(reader.getAttribute("id"));
        String serialized = reader.getValue();
        VcsRoot vcsRoot = VcsUtil.convertStringToVcsRoot(vcsRootId, serialized, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return EncryptUtil.unscramble(s);
            }
        });
        reader.moveUp();
        reader.moveDown();
        CheckoutRules rules = new CheckoutRules(reader.getValue());
        reader.moveUp();
        reader.moveDown();
        final String signature = reader.getValue();
        reader.moveUp();
        return new VcsRootEntry(vcsRoot, rules){

            @Override
            @NotNull
            public String getSignature() {
                String string = signature;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/VcsRootEntryConverter$3", "getSignature"));
            }
        };
    }

    public boolean canConvert(Class aClass) {
        return VcsRootEntry.class.isAssignableFrom(aClass);
    }
}

