/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.artifacts.ArtifactDependency;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.artifacts.RevisionRules;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.ValueResolver;
import org.jetbrains.annotations.NotNull;

public abstract class BaseArtifactDependency
implements ArtifactDependency {
    private String mySourcePaths;
    private final String myId;
    private boolean myCleanDestinationFolder;
    private RevisionRule myRevisionRule;

    protected BaseArtifactDependency(@NotNull String id, @NotNull String sourcePaths, @NotNull RevisionRule revisionRule) {
        if (id == null) {
            BaseArtifactDependency.$$$reportNull$$$0(0);
        }
        if (sourcePaths == null) {
            BaseArtifactDependency.$$$reportNull$$$0(1);
        }
        if (revisionRule == null) {
            BaseArtifactDependency.$$$reportNull$$$0(2);
        }
        this.myCleanDestinationFolder = false;
        this.mySourcePaths = sourcePaths;
        this.myRevisionRule = revisionRule;
        this.myId = id;
    }

    @Override
    public void setCleanDestinationFolder(boolean cleanDestinationFolder) {
        this.myCleanDestinationFolder = cleanDestinationFolder;
    }

    @Override
    @NotNull
    public abstract String getSourceBuildTypeId();

    @Override
    @NotNull
    public abstract String getSourceExternalId();

    @Override
    @NotNull
    public String getSourcePaths() {
        String string = this.mySourcePaths;
        if (string == null) {
            BaseArtifactDependency.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isCleanDestinationFolder() {
        return this.myCleanDestinationFolder;
    }

    @Override
    @NotNull
    public RevisionRule getRevisionRule() {
        RevisionRule revisionRule = this.myRevisionRule;
        if (revisionRule == null) {
            BaseArtifactDependency.$$$reportNull$$$0(4);
        }
        return revisionRule;
    }

    public String toString() {
        return "build configuration id: " + this.getSourceExternalId() + ", internal id: " + this.getSourceBuildTypeId() + "; source path: \"" + this.mySourcePaths + "\"; clean destination: " + this.myCleanDestinationFolder + "; revision: \"" + this.myRevisionRule.getRevision() + "\"";
    }

    @Override
    public abstract void setSourceBuildTypeId(@NotNull String var1);

    @Override
    public void setRevisionRule(@NotNull RevisionRule revisionRule) {
        if (revisionRule == null) {
            BaseArtifactDependency.$$$reportNull$$$0(5);
        }
        this.myRevisionRule = revisionRule;
    }

    @Override
    public void setSourcePaths(@NotNull String paths) {
        if (paths == null) {
            BaseArtifactDependency.$$$reportNull$$$0(6);
        }
        this.mySourcePaths = paths;
    }

    @Override
    public void replaceReferences(@NotNull ValueResolver resolver) {
        if (resolver == null) {
            BaseArtifactDependency.$$$reportNull$$$0(7);
        }
        String resolvedSourcePaths = this.resolveValue(this.getSourcePaths(), resolver);
        this.setSourcePaths(resolvedSourcePaths);
        RevisionRule revisionRule = this.getRevisionRule();
        String branch = revisionRule.getBranch();
        if (branch != null) {
            branch = this.resolveValue(branch, resolver);
        }
        if ("buildNumber".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildNumberRule(this.resolveValue(revisionRule.getRevision(), resolver)));
        } else if ("buildTag".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildTagRule(this.resolveValue(((BuildTagRevisionRule)revisionRule).getBuildTag(), resolver), branch));
        } else if (branch != null) {
            this.setRevisionRule(RevisionRules.newBranchRevisionRule(revisionRule.getName(), revisionRule.getRevision(), branch));
        }
    }

    @NotNull
    private String resolveValue(@NotNull String value, ValueResolver resolver) {
        if (value == null) {
            BaseArtifactDependency.$$$reportNull$$$0(8);
        }
        String string = resolver.resolve(value).getResult();
        if (string == null) {
            BaseArtifactDependency.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public List<String> getReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        refs.addAll(ReferencesResolverUtil.getReferences(this.getRevisionRule().getRevision()));
        refs.addAll(ReferencesResolverUtil.getReferences(this.getSourcePaths()));
        String branch = this.myRevisionRule.getBranch();
        if (branch != null) {
            refs.addAll(ReferencesResolverUtil.getReferences(branch));
        }
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaseArtifactDependency)) {
            return false;
        }
        BaseArtifactDependency that = (BaseArtifactDependency)o;
        return this.myId.equals(that.myId);
    }

    @Override
    public boolean isSimilarTo(ArtifactDependency dep) {
        if (this == dep) {
            return true;
        }
        if (dep == null) {
            return false;
        }
        return this.myCleanDestinationFolder == dep.isCleanDestinationFolder() && this.myRevisionRule.equals(dep.getRevisionRule()) && this.getSourceBuildTypeId().equals(dep.getSourceBuildTypeId()) && this.mySourcePaths.equals(dep.getSourcePaths());
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            BaseArtifactDependency.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePaths";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionRule";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/BaseArtifactDependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/BaseArtifactDependency";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcePaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionRule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRevisionRule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSourcePaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

