/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.log.Loggers;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionRules {
    @NonNls
    public static final String REVISION_RULE_TAG = "revisionRule";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String REVISION_ATTR = "revision";
    @NonNls
    public static final String BRANCH_ATTR = "branch";
    public static final String BUILD_ID_SUFFIX = ".tcbuildid";
    public static final String BUILD_TAG_SUFFIX = ".tcbuildtag";
    public static final String LAST_PINNED_NAME = "lastPinned";
    public static final String LAST_SUCCESSFUL_NAME = "lastSuccessful";
    public static final String LAST_FINISHED_NAME = "lastFinished";
    public static final String LAST_FINISHED_SAME_CHAIN_NAME = "sameChainOrLastFinished";
    public static final String BUILD_NUMBER_NAME = "buildNumber";
    public static final String BUILD_ID_NAME = "buildId";
    public static final String BUILD_TAG_NAME = "buildTag";
    private static final Pattern BUILD_ID_PATTERN = Pattern.compile("([0-9]+)(:id|" + jetbrains.buildServer.util.StringUtil.escapeForRegex(".tcbuildid") + ")");
    @NotNull
    public static final RevisionRule LAST_PINNED_RULE = new LastPinnedRule(null);
    @NotNull
    public static final RevisionRule LAST_SUCCESSFUL_RULE = new LastSuccessfulRule(null);
    @NotNull
    public static final RevisionRule LAST_FINISHED_RULE = new LastFinishedRule(null);
    @NotNull
    public static final RevisionRule LAST_FINISHED_SAME_CHAIN_RULE = new LastFinishedSameChainRule();

    private RevisionRules() {
    }

    @NotNull
    public static RevisionRule newBuildNumberRule(@NotNull String buildNumber) {
        if (buildNumber == null) {
            RevisionRules.$$$reportNull$$$0(0);
        }
        BuildNumberRule buildNumberRule = new BuildNumberRule(buildNumber);
        if (buildNumberRule == null) {
            RevisionRules.$$$reportNull$$$0(1);
        }
        return buildNumberRule;
    }

    @NotNull
    public static RevisionRule newBuildTagRule(@Nullable String buildTagParam) {
        RevisionRule revisionRule = RevisionRules.newBuildTagRule(buildTagParam, null);
        if (revisionRule == null) {
            RevisionRules.$$$reportNull$$$0(2);
        }
        return revisionRule;
    }

    public static RevisionRule newBuildTagRule(@Nullable String buildTagParam, @Nullable String branch) {
        String buildTag = buildTagParam != null ? (buildTagParam.endsWith(BUILD_TAG_SUFFIX) ? buildTagParam.substring(0, buildTagParam.lastIndexOf(BUILD_TAG_SUFFIX)).trim() : buildTagParam.trim()) : "";
        return new BuildTagRevisionRuleImpl(buildTag, branch);
    }

    @NotNull
    public static RevisionRule newBuildIdRule(long buildId, @Nullable String buildNumber) {
        BuildIdRule buildIdRule = new BuildIdRule(buildId, buildNumber);
        if (buildIdRule == null) {
            RevisionRules.$$$reportNull$$$0(3);
        }
        return buildIdRule;
    }

    @NotNull
    public static Long extractBuildIdFromRule(RevisionRule rule) {
        String value = rule.getRevision();
        Matcher matcher = BUILD_ID_PATTERN.matcher(value);
        if (matcher.matches()) {
            String buildIdStr = matcher.group(1);
            Long l = Long.parseLong(buildIdStr);
            if (l == null) {
                RevisionRules.$$$reportNull$$$0(4);
            }
            return l;
        }
        throw new IllegalArgumentException("Revision rule " + rule.toString() + "is not a build id rule");
    }

    @NotNull
    public static RevisionRule newRevisionRule(@NotNull String name, @Nullable String value) {
        if (name == null) {
            RevisionRules.$$$reportNull$$$0(5);
        }
        RevisionRule revisionRule = RevisionRules.newBranchRevisionRule(name, value, null);
        if (revisionRule == null) {
            RevisionRules.$$$reportNull$$$0(6);
        }
        return revisionRule;
    }

    @NotNull
    public static RevisionRule newBranchRevisionRule(@NotNull String name, @Nullable String value, @Nullable String branch) {
        if (name == null) {
            RevisionRules.$$$reportNull$$$0(7);
        }
        if (LAST_FINISHED_NAME.equals(name)) {
            LastFinishedRule lastFinishedRule = new LastFinishedRule(branch);
            if (lastFinishedRule == null) {
                RevisionRules.$$$reportNull$$$0(8);
            }
            return lastFinishedRule;
        }
        if (LAST_FINISHED_SAME_CHAIN_NAME.equals(name)) {
            RevisionRule revisionRule = LAST_FINISHED_SAME_CHAIN_RULE;
            if (revisionRule == null) {
                RevisionRules.$$$reportNull$$$0(9);
            }
            return revisionRule;
        }
        if (LAST_PINNED_NAME.equals(name)) {
            LastPinnedRule lastPinnedRule = new LastPinnedRule(branch);
            if (lastPinnedRule == null) {
                RevisionRules.$$$reportNull$$$0(10);
            }
            return lastPinnedRule;
        }
        if (LAST_SUCCESSFUL_NAME.equals(name)) {
            LastSuccessfulRule lastSuccessfulRule = new LastSuccessfulRule(branch);
            if (lastSuccessfulRule == null) {
                RevisionRules.$$$reportNull$$$0(11);
            }
            return lastSuccessfulRule;
        }
        if (jetbrains.buildServer.util.StringUtil.isEmpty((String)value)) {
            throw new UnsupportedOperationException("Cannot create revision rule with empty value");
        }
        if (BUILD_TAG_NAME.equals(name)) {
            RevisionRule revisionRule = RevisionRules.newBuildTagRule(value, branch);
            if (revisionRule == null) {
                RevisionRules.$$$reportNull$$$0(12);
            }
            return revisionRule;
        }
        if (BUILD_NUMBER_NAME.equals(name)) {
            RevisionRule revisionRule = RevisionRules.newBuildNumberRule(value);
            if (revisionRule == null) {
                RevisionRules.$$$reportNull$$$0(13);
            }
            return revisionRule;
        }
        if (BUILD_ID_NAME.equals(name)) {
            block20: {
                RevisionRule revisionRule;
                try {
                    Matcher matcher = BUILD_ID_PATTERN.matcher(value);
                    if (!matcher.matches()) break block20;
                    String buildIdStr = matcher.group(1);
                    revisionRule = RevisionRules.newBuildIdRule(Long.parseLong(buildIdStr), null);
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedOperationException("Error creating buildId revision rule for a non-number \"" + value + "\": " + e.toString());
                }
                if (revisionRule == null) {
                    RevisionRules.$$$reportNull$$$0(14);
                }
                return revisionRule;
            }
            RevisionRule revisionRule = RevisionRules.newBuildIdRule(Long.valueOf(value), null);
            if (revisionRule == null) {
                RevisionRules.$$$reportNull$$$0(15);
            }
            return revisionRule;
        }
        throw new UnsupportedOperationException("Error creating revision rule. Unknown revision rule name \"" + name + "\"");
    }

    @Nullable
    public static RevisionRule newRevisionRule(@NotNull String revision) {
        if (revision == null) {
            RevisionRules.$$$reportNull$$$0(16);
        }
        return RevisionRules.newBranchRevisionRule(revision, null);
    }

    @Nullable
    public static RevisionRule newBranchRevisionRule(@NotNull String revision, @Nullable String branch) {
        Matcher matcher;
        if (revision == null) {
            RevisionRules.$$$reportNull$$$0(17);
        }
        if ((matcher = BUILD_ID_PATTERN.matcher(revision)).matches()) {
            String buildIdStr = matcher.group(1);
            try {
                return RevisionRules.newBuildIdRule(Long.parseLong(buildIdStr), null);
            }
            catch (NumberFormatException e) {
                Loggers.SERVER.warn("Failed to parse build id from the revision: " + revision);
                return null;
            }
        }
        if (revision.endsWith(BUILD_TAG_SUFFIX)) {
            return RevisionRules.newBuildTagRule(revision, branch);
        }
        String rev = revision;
        int lastDotIdx = revision.lastIndexOf(46);
        if (lastDotIdx != -1) {
            rev = revision.substring(lastDotIdx);
        }
        if (LAST_PINNED_RULE.getRevision().endsWith(rev)) {
            return new LastPinnedRule(branch);
        }
        if (LAST_FINISHED_RULE.getRevision().endsWith(rev)) {
            return new LastFinishedRule(branch);
        }
        if (LAST_SUCCESSFUL_RULE.getRevision().endsWith(rev)) {
            return new LastSuccessfulRule(branch);
        }
        if (LAST_FINISHED_SAME_CHAIN_RULE.getRevision().endsWith(rev)) {
            return LAST_FINISHED_SAME_CHAIN_RULE;
        }
        return RevisionRules.newBuildNumberRule(revision);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = BUILD_NUMBER_NAME;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/RevisionRules";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATTR;
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = REVISION_ATTR;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/RevisionRules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuildNumberRule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuildTagRule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuildIdRule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBuildIdFromRule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newRevisionRule";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newBranchRevisionRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newBuildNumberRule";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newRevisionRule";
                break;
            }
            case 7: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newBranchRevisionRule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class BuildTagRevisionRuleImpl
    extends BuildTagRevisionRule {
        private final String myBuildTag;

        public BuildTagRevisionRuleImpl(@NotNull String buildTag, @Nullable String branch) {
            if (buildTag == null) {
                BuildTagRevisionRuleImpl.$$$reportNull$$$0(0);
            }
            super(RevisionRules.BUILD_TAG_NAME, "Latest build with tag: '" + buildTag + "'", buildTag + RevisionRules.BUILD_TAG_SUFFIX, branch);
            this.myBuildTag = buildTag;
        }

        @Override
        @NotNull
        public String getBuildTag() {
            String string = this.myBuildTag;
            if (string == null) {
                BuildTagRevisionRuleImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = RevisionRules.BUILD_TAG_NAME;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/artifacts/RevisionRules$BuildTagRevisionRuleImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/artifacts/RevisionRules$BuildTagRevisionRuleImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class BuildIdRule
    extends AbstractRevisionRule {
        private BuildIdRule(long buildId, @Nullable String buildNumber) {
            super(RevisionRules.BUILD_ID_NAME, BuildIdRule.createDescription(buildId, buildNumber), buildId + RevisionRules.BUILD_ID_SUFFIX, null);
        }

        private static String createDescription(long buildId, @Nullable String buildNumber) {
            return !jetbrains.buildServer.util.StringUtil.isEmptyOrSpaces((String)buildNumber) ? "Build #" + buildNumber + " [id " + buildId + "]" : "Build with id: " + buildId;
        }
    }

    private static final class BuildNumberRule
    extends AbstractRevisionRule {
        private BuildNumberRule(@NotNull String buildNumber) {
            if (buildNumber == null) {
                BuildNumberRule.$$$reportNull$$$0(0);
            }
            super(RevisionRules.BUILD_NUMBER_NAME, "Build #" + buildNumber, buildNumber, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RevisionRules.BUILD_NUMBER_NAME, "jetbrains/buildServer/artifacts/RevisionRules$BuildNumberRule", "<init>"));
        }
    }

    private static final class LastFinishedSameChainRule
    extends AbstractRevisionRule {
        private LastFinishedSameChainRule() {
            super(RevisionRules.LAST_FINISHED_SAME_CHAIN_NAME, "Build from the same chain", "latest.sameChainOrLastFinished", null);
        }
    }

    private static final class LastFinishedRule
    extends AbstractRevisionRule {
        private LastFinishedRule(@Nullable String branch) {
            super(RevisionRules.LAST_FINISHED_NAME, "Latest finished build", "latest.lastFinished", branch);
        }
    }

    private static final class LastSuccessfulRule
    extends AbstractRevisionRule {
        private LastSuccessfulRule(@Nullable String branch) {
            super(RevisionRules.LAST_SUCCESSFUL_NAME, "Latest successful build", "latest.lastSuccessful", branch);
        }
    }

    private static final class LastPinnedRule
    extends AbstractRevisionRule {
        private LastPinnedRule(@Nullable String branch) {
            super(RevisionRules.LAST_PINNED_NAME, "Latest pinned build", "latest.lastPinned", branch);
        }
    }

    public static abstract class AbstractRevisionRule
    implements RevisionRule {
        @NotNull
        private final String myName;
        @NotNull
        private final String myDescription;
        @NotNull
        private final String myRevision;
        @Nullable
        private final String myBranch;

        protected AbstractRevisionRule(@NotNull String name, @NotNull String description, @NotNull String revision, @Nullable String branch) {
            if (name == null) {
                AbstractRevisionRule.$$$reportNull$$$0(0);
            }
            if (description == null) {
                AbstractRevisionRule.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                AbstractRevisionRule.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myDescription = description;
            this.myRevision = revision;
            this.myBranch = branch;
        }

        @Override
        @Nullable
        public String getBranch() {
            return this.myBranch;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                AbstractRevisionRule.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myRevision;
            if (string == null) {
                AbstractRevisionRule.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            if (StringUtil.isEmpty((String)this.myBranch)) {
                String string = this.myDescription;
                if (string == null) {
                    AbstractRevisionRule.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = this.myDescription + ", branch filter: " + this.myBranch;
            if (string == null) {
                AbstractRevisionRule.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public void writeTo(Element parentElement) {
            Element revisionRule = new Element(RevisionRules.REVISION_RULE_TAG);
            parentElement.addContent((Content)revisionRule);
            revisionRule.setAttribute(RevisionRules.NAME_ATTR, this.getName());
            revisionRule.setAttribute(RevisionRules.REVISION_ATTR, this.getRevision());
            if (this.myBranch != null) {
                revisionRule.setAttribute(RevisionRules.BRANCH_ATTR, this.myBranch);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionRule rule = (RevisionRule)o;
            return this.getName().equals(rule.getName()) && this.getRevision().equals(rule.getRevision()) && jetbrains.buildServer.util.StringUtil.emptyIfNull(this.myBranch).equals(jetbrains.buildServer.util.StringUtil.emptyIfNull(rule.getBranch()));
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + this.getRevision().hashCode();
            result = 31 * result + jetbrains.buildServer.util.StringUtil.emptyIfNull(this.myBranch).hashCode();
            return result;
        }

        public String toString() {
            return "AbstractRevisionRule{myName='" + this.myName + '\'' + ", myDescription='" + this.myDescription + '\'' + ", myRevision='" + this.myRevision + '\'' + ", myBranch='" + this.myBranch + '\'' + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = RevisionRules.NAME_ATTR;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = RevisionRules.REVISION_ATTR;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/artifacts/RevisionRules$AbstractRevisionRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/artifacts/RevisionRules$AbstractRevisionRule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

