/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.ThreadUtil;
import jetbrains.buildServer.util.executors.ExecutorsFactory;
import org.jetbrains.annotations.NotNull;

public class ChangeObserver {
    private static final Logger LOG = Logger.getInstance((String)"jetbrains.buildServer.ChangeObserver");
    private final Object myMonitor;
    private static volatile ScheduledExecutorService ourScheduler = null;
    private final EventDispatcher<ChangeListener> myListeners;
    private final List<ChangeProvider> myWatchers;
    private final AtomicBoolean myStopped;
    private final AtomicInteger myDisabledCounter;
    private String myLastRequestor;
    private volatile long mySleepingPeriod;
    private boolean mySkipListenersNotification;
    private boolean myChangesDetected;
    private final ScheduledExecutorService myScheduler;

    public ChangeObserver(long intervalForCheckingsMsecs) {
        this.myMonitor = new Object();
        this.myListeners = EventDispatcher.create(ChangeListener.class);
        this.myWatchers = new ArrayList<ChangeProvider>();
        this.myStopped = new AtomicBoolean(true);
        this.myDisabledCounter = new AtomicInteger(0);
        if (ourScheduler == null || ourScheduler.isShutdown() && LogInitializer.isUnitTest()) {
            ourScheduler = ExecutorsFactory.newFixedScheduledDaemonExecutor("Change Observer", 1);
        }
        this.myScheduler = ourScheduler;
        this.mySleepingPeriod = intervalForCheckingsMsecs;
    }

    /*
     * WARNING - void declaration
     */
    public ChangeObserver(long intervalForCheckingsMsecs, @NotNull ScheduledExecutorService scheduledExecutorService) {
        void scheduler;
        if (scheduledExecutorService == null) {
            ChangeObserver.$$$reportNull$$$0(0);
        }
        this.myMonitor = new Object();
        this.myListeners = EventDispatcher.create(ChangeListener.class);
        this.myWatchers = new ArrayList<ChangeProvider>();
        this.myStopped = new AtomicBoolean(true);
        this.myDisabledCounter = new AtomicInteger(0);
        this.myScheduler = scheduler;
        this.mySleepingPeriod = intervalForCheckingsMsecs;
    }

    public void registerListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            ChangeObserver.$$$reportNull$$$0(1);
        }
        this.myListeners.addListener(listener);
    }

    public void unregisterListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            ChangeObserver.$$$reportNull$$$0(2);
        }
        this.myListeners.removeListener(listener);
    }

    public final void registerChangeProvider(@NotNull ChangeProvider provider) {
        if (provider == null) {
            ChangeObserver.$$$reportNull$$$0(3);
        }
        this.myWatchers.add(provider);
    }

    public void unregisterChangeProvider(@NotNull ChangeProvider provider) {
        if (provider == null) {
            ChangeObserver.$$$reportNull$$$0(4);
        }
        this.myWatchers.remove(provider);
    }

    public void start() {
        this.myStopped.set(false);
        this.myDisabledCounter.set(0);
        this.scheduleMe();
    }

    public void stop() {
        this.myStopped.set(true);
    }

    public static void shutdownAll() {
        ScheduledExecutorService scheduler = ourScheduler;
        if (scheduler != null) {
            ThreadUtil.shutdownNowAndWait(scheduler, "Change Observer executor");
        }
    }

    public void setSleepingPeriod(long time) {
        this.mySleepingPeriod = time;
    }

    public long getSleepingPeriod() {
        return this.mySleepingPeriod;
    }

    public void clear() {
        this.myListeners.dispose();
        this.myWatchers.clear();
    }

    public void clearListeners() {
        this.myListeners.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipListenersNotification(boolean value) {
        Object object = this.myMonitor;
        synchronized (object) {
            this.mySkipListenersNotification = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActionWithDisabledObserver(@NotNull Runnable runnable) {
        if (runnable == null) {
            ChangeObserver.$$$reportNull$$$0(5);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            this.myDisabledCounter.incrementAndGet();
            try {
                runnable.run();
            }
            finally {
                int count = this.myDisabledCounter.decrementAndGet();
                if (count == 0) {
                    this.detectChanges();
                    this.resetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForModifications() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean changesDetected = this.detectChanges();
            if (changesDetected) {
                this.myChangesDetected = true;
                if (this.mySkipListenersNotification) {
                    this.resetChanged();
                    return;
                }
            }
            if (this.myChangesDetected) {
                try {
                    this.myListeners.getMulticaster().changeOccured(this.myLastRequestor);
                }
                finally {
                    try {
                        this.resetChanged();
                    }
                    finally {
                        this.myLastRequestor = null;
                        this.myChangesDetected = false;
                    }
                }
            }
        }
    }

    private void scheduleMe() {
        try {
            this.myScheduler.schedule(() -> {
                try {
                    if (this.myStopped.get()) {
                        return;
                    }
                    if (this.myDisabledCounter.get() == 0) {
                        this.checkForModifications();
                    }
                }
                catch (Throwable t) {
                    LOG.warnAndDebugDetails("File watcher task failed", t);
                }
                finally {
                    this.scheduleMe();
                }
            }, this.mySleepingPeriod, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOG.infoAndDebugDetails("Could not schedule file watcher task", (Throwable)e);
        }
    }

    private void resetChanged() {
        ChangeProvider[] watchers;
        for (ChangeProvider watcher : watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()])) {
            watcher.resetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectChanges() {
        boolean result = false;
        ChangeProvider[] watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()]);
        int i = 0;
        long startTime = System.currentTimeMillis();
        for (ChangeProvider watcher : watchers) {
            Disposable patchedThreadName = NamedThreadFactory.patchThreadName("Processing watcher" + (watchers.length > 1 ? " " + ++i + "/" + watchers.length : "") + ": " + this.getDescription(watcher));
            try {
                if (!watcher.changesDetected()) continue;
                result = true;
                this.myLastRequestor = watcher.getRequestor();
            }
            finally {
                patchedThreadName.dispose();
            }
        }
        if (LOG.isDebugEnabled() && (result || TeamCityProperties.getBoolean("teamcity.changeWatcher.enableBackgroundLogging"))) {
            LOG.debug("Finished detecting changes in " + (System.currentTimeMillis() - startTime) + "ms for " + (watchers.length > 1 ? watchers.length + " watchers" : watchers[0].describe(true)));
        }
        return result;
    }

    @NotNull
    private String getDescription(@NotNull ChangeProvider watcher) {
        String string;
        if (watcher == null) {
            ChangeObserver.$$$reportNull$$$0(6);
        }
        try {
            string = watcher.describe(false);
        }
        catch (AbstractMethodError e) {
            String string2 = watcher.getClass().getName();
            if (string2 == null) {
                ChangeObserver.$$$reportNull$$$0(8);
            }
            return string2;
        }
        if (string == null) {
            ChangeObserver.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/configuration/ChangeObserver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/configuration/ChangeObserver";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregisterListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runActionWithDisabledObserver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

