/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.configuration.WatchedFileState;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.log.Loggable;
import org.jetbrains.annotations.NotNull;

public class FilesState
implements Loggable {
    private final Map<String, WatchedFileState> myFilesState = new HashMap<String, WatchedFileState>();
    private final List<File> myNewFiles = new ArrayList<File>();
    private final List<File> myRemovedFiles = new ArrayList<File>();
    private final List<File> myModifiedFiles = new ArrayList<File>();
    private volatile boolean myInited = false;

    public void resetState(File ... watchedFiles) {
        if (watchedFiles == null) {
            FilesState.$$$reportNull$$$0(0);
        }
        this.clearDetectedChanges();
        this.myFilesState.clear();
        this.addToState(watchedFiles);
        this.myInited = true;
    }

    public void resetState(@NotNull Map<File, WatchedFileState> fileStatesMap) {
        if (fileStatesMap == null) {
            FilesState.$$$reportNull$$$0(1);
        }
        this.clearDetectedChanges();
        this.myFilesState.clear();
        for (Map.Entry<File, WatchedFileState> e : fileStatesMap.entrySet()) {
            this.myFilesState.put(e.getKey().getAbsolutePath(), e.getValue());
        }
        this.myInited = true;
    }

    public boolean isInitialized() {
        return this.myInited;
    }

    void addToState(File ... watchedFiles) {
        if (watchedFiles == null) {
            FilesState.$$$reportNull$$$0(2);
        }
        for (File watchedFile : watchedFiles) {
            this.myFilesState.put(watchedFile.getAbsolutePath(), new WatchedFileState(watchedFile));
        }
    }

    public boolean computeChanges(@NotNull File[] files) {
        if (files == null) {
            FilesState.$$$reportNull$$$0(3);
        }
        this.clearDetectedChanges();
        HashSet<String> filesPaths = new HashSet<String>();
        for (File file : files) {
            boolean updateState = false;
            if (!this.myFilesState.containsKey(file.getAbsolutePath())) {
                this.myNewFiles.add(file);
                updateState = true;
            } else {
                WatchedFileState watchedFile = this.myFilesState.get(file.getAbsolutePath());
                if (watchedFile.isCreated(file)) {
                    this.myNewFiles.add(file);
                    updateState = true;
                } else if (watchedFile.isRemoved(file)) {
                    this.myRemovedFiles.add(file);
                    updateState = true;
                } else if (watchedFile.isChanged(file)) {
                    this.myModifiedFiles.add(file);
                    updateState = true;
                }
            }
            if (updateState) {
                this.addToState(file);
            }
            filesPaths.add(file.getAbsolutePath());
        }
        for (String path : this.myFilesState.keySet()) {
            if (filesPaths.contains(path)) continue;
            this.myRemovedFiles.add(new File(path));
        }
        for (File removed : this.myRemovedFiles) {
            this.myFilesState.remove(removed.getAbsolutePath());
        }
        return !this.myNewFiles.isEmpty() || !this.myRemovedFiles.isEmpty() || !this.myModifiedFiles.isEmpty();
    }

    @NotNull
    public Map<String, WatchedFileState> getFilesState() {
        Map<String, WatchedFileState> map = this.myFilesState;
        if (map == null) {
            FilesState.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public List<File> getNewFiles() {
        List<File> list = Collections.unmodifiableList(new ArrayList<File>(this.myNewFiles));
        if (list == null) {
            FilesState.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<File> getRemovedFiles() {
        List<File> list = Collections.unmodifiableList(new ArrayList<File>(this.myRemovedFiles));
        if (list == null) {
            FilesState.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<File> getModifiedFiles() {
        List<File> list = Collections.unmodifiableList(new ArrayList<File>(this.myModifiedFiles));
        if (list == null) {
            FilesState.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void clearDetectedChanges() {
        this.myNewFiles.clear();
        this.myRemovedFiles.clear();
        this.myModifiedFiles.clear();
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        StringBuilder result = new StringBuilder();
        int count = this.myFilesState.size();
        if (count != 0) {
            String firstWatchedFileName = this.myFilesState.keySet().iterator().next();
            if (count > 1) {
                result.append(count).append(" files: ").append(LogUtil.quote(firstWatchedFileName)).append(" and others");
            } else {
                result.append("file: ").append(LogUtil.quote(firstWatchedFileName));
            }
            if (verbose) {
                result.append(", current state: modified: ").append(this.myModifiedFiles.size()).append(", new: ").append(this.myNewFiles.size()).append(", removed: ").append(this.myRemovedFiles.size());
            }
            String string = result.toString();
            if (string == null) {
                FilesState.$$$reportNull$$$0(8);
            }
            return string;
        }
        if ("<empty>" == null) {
            FilesState.$$$reportNull$$$0(9);
        }
        return "<empty>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchedFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatesMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/configuration/FilesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/configuration/FilesState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addToState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

