/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.FileWatcherListener;
import jetbrains.buildServer.configuration.FilesState;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.ThreadUtil;
import jetbrains.buildServer.util.TimePrinter;
import jetbrains.buildServer.util.WaitFor;
import jetbrains.buildServer.util.executors.ExecutorsFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesWatcher
implements Loggable {
    public static final String TEAMCITY_FILES_WATCHER_INIT_STATE_DELAY_PROP = "teamcity.filesWatcher.initStateDelay";
    private static final Logger LOG = Logger.getInstance((String)FilesWatcher.class.getName());
    private static final Logger LOG_DIAG = Logger.getInstance((String)("jetbrains.buildServer.diagnostic." + FilesWatcher.class.getSimpleName()));
    private static final String REQUESTOR_NAME = "FilesWatcher";
    private static final AtomicReference<ScheduledExecutorService> ourSchedulerRef = new AtomicReference();
    private final AtomicReference<FilesState> myFilesState;
    @NotNull
    private final WatchedFilesProvider myFilesProvider;
    private final EventDispatcher<ChangeListener> myListeners;
    private final EventDispatcher<FileWatcherListener> myExtendedListeners;
    private final AtomicInteger myDisabledCounter;
    private final AtomicReference<WatcherState> myWatcherState;
    private volatile long mySleepingPeriod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilesWatcher(@NotNull WatchedFilesProvider filesProvider) {
        if (filesProvider == null) {
            FilesWatcher.$$$reportNull$$$0(0);
        }
        this.myFilesState = new AtomicReference();
        this.myListeners = EventDispatcher.create(ChangeListener.class);
        this.myExtendedListeners = EventDispatcher.create(FileWatcherListener.class);
        this.myDisabledCounter = new AtomicInteger(0);
        this.myWatcherState = new AtomicReference<WatcherState>(WatcherState.STOPPED);
        this.mySleepingPeriod = 10000L;
        AtomicReference<ScheduledExecutorService> atomicReference = ourSchedulerRef;
        synchronized (atomicReference) {
            ScheduledExecutorService scheduler = ourSchedulerRef.get();
            if (scheduler == null || scheduler.isShutdown() && LogInitializer.isUnitTest()) {
                ourSchedulerRef.set(ExecutorsFactory.newFixedScheduledDaemonExecutor(REQUESTOR_NAME, 1));
            }
        }
        this.myFilesProvider = filesProvider;
        this.myFilesState.set(new FilesState());
    }

    @Used(value="tests")
    public boolean changesDetected() {
        return this.detectChanges() != null;
    }

    @Used(value="tests")
    @NotNull
    public List<File> getNewFiles() {
        FilesState filesState = this.myFilesState.get();
        List<File> list = filesState.isInitialized() ? filesState.getNewFiles() : Collections.emptyList();
        if (list == null) {
            FilesWatcher.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Used(value="tests")
    @NotNull
    public List<File> getRemovedFiles() {
        FilesState filesState = this.myFilesState.get();
        List<File> list = filesState.isInitialized() ? filesState.getRemovedFiles() : Collections.emptyList();
        if (list == null) {
            FilesWatcher.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Used(value="tests")
    @NotNull
    public List<File> getModifiedFiles() {
        FilesState filesState = this.myFilesState.get();
        List<File> list = filesState.isInitialized() ? filesState.getModifiedFiles() : Collections.emptyList();
        if (list == null) {
            FilesWatcher.$$$reportNull$$$0(3);
        }
        return list;
    }

    public String toString() {
        return "Files watcher for " + this.myFilesProvider;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String string = this.toString() + " with state " + this.myFilesState.get().describe(verbose);
        if (string == null) {
            FilesWatcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Deprecated
    public void registerListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            FilesWatcher.$$$reportNull$$$0(5);
        }
        this.myListeners.addListener(listener);
    }

    public void registerListener(@NotNull FileWatcherListener listener) {
        if (listener == null) {
            FilesWatcher.$$$reportNull$$$0(6);
        }
        this.myExtendedListeners.addListener(listener);
    }

    @Deprecated
    public void unregisterListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            FilesWatcher.$$$reportNull$$$0(7);
        }
        this.myListeners.removeListener(listener);
    }

    public void unregisterListener(@NotNull FileWatcherListener listener) {
        if (listener == null) {
            FilesWatcher.$$$reportNull$$$0(8);
        }
        this.myExtendedListeners.removeListener(listener);
    }

    public void start() {
        if (this.myWatcherState.compareAndSet(WatcherState.STOPPED, WatcherState.ACTIVE)) {
            this.myFilesState.set(new FilesState());
            this.myDisabledCounter.set(0);
        }
        this.scheduleMe(this.getInitStateDelay(), true);
    }

    public void stop() {
        this.myWatcherState.set(WatcherState.STOPPED);
    }

    public void setSleepingPeriod(long time) {
        this.mySleepingPeriod = time;
    }

    public long getSleepingPeriod() {
        return this.mySleepingPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActionWithDisabledObserver(@NotNull Runnable runnable) {
        if (runnable == null) {
            FilesWatcher.$$$reportNull$$$0(9);
        }
        LOG.debug("Disabling files watcher until some action finishes: " + this.describe(false));
        AtomicReference<FilesState> atomicReference = this.myFilesState;
        synchronized (atomicReference) {
            this.myDisabledCounter.incrementAndGet();
            this.myWatcherState.set(WatcherState.PAUSED);
            try {
                runnable.run();
            }
            finally {
                int count = this.myDisabledCounter.decrementAndGet();
                if (count == 0) {
                    LOG.debug("Re-enabling files watcher: " + this.describe(false));
                    this.myFilesState.set(new FilesState());
                    this.myWatcherState.set(WatcherState.ACTIVE);
                    this.scheduleMe(this.getInitStateDelay(), false);
                }
            }
        }
    }

    private long getInitStateDelay() {
        return TeamCityProperties.getLong(TEAMCITY_FILES_WATCHER_INIT_STATE_DELAY_PROP, 1000L);
    }

    @Used(value="tests")
    public boolean checkForModifications() {
        return this.notifyListeners(this.detectChanges());
    }

    private boolean notifyListeners(@Nullable FilesState filesState) {
        if (filesState == null) {
            return false;
        }
        this.myExtendedListeners.getMulticaster().changesDetected(filesState.getNewFiles(), filesState.getModifiedFiles(), filesState.getRemovedFiles());
        this.myListeners.getMulticaster().changeOccured(REQUESTOR_NAME);
        return true;
    }

    private void scheduleMe(long delay, boolean repeatable) {
        ReschedulableChangesDetector command = new ReschedulableChangesDetector(repeatable);
        if (delay == 0L) {
            command.run();
            return;
        }
        ScheduledExecutorService scheduler = ourSchedulerRef.get();
        if (scheduler != null) {
            try {
                scheduler.schedule(command, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                LOG.infoAndDebugDetails("Failed to schedule file watcher task: " + this.describe(false), (Throwable)e);
            }
        } else {
            LOG.debug("Could not schedule files watcher changes detection task because executor is not created yet: " + this.describe(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected FilesState detectChanges() {
        long startTime = System.currentTimeMillis();
        boolean changesDetected = false;
        FilesState filesState = this.myFilesState.get();
        if (!filesState.isInitialized()) {
            return null;
        }
        File[] watchedFiles = new File[]{};
        try {
            watchedFiles = this.getWatchedFilesInPatchedThread();
            if (this.myFilesState.get() != filesState) {
                FilesState filesState2 = null;
                return filesState2;
            }
            if (filesState.computeChanges(watchedFiles)) {
                if (this.myFilesState.get() != filesState) {
                    FilesState filesState3 = null;
                    return filesState3;
                }
                changesDetected = true;
                FilesState filesState4 = filesState;
                return filesState4;
            }
        }
        catch (IOException e) {
            filesState.clearDetectedChanges();
            LOG.warnAndDebugDetails("Exception in FilesWatcher", (Throwable)e);
        }
        finally {
            long duration = System.currentTimeMillis() - startTime;
            String durationStr = TimePrinter.createSecondsFormatter(false).formatTime(duration / 1000L);
            if (duration > TeamCityProperties.getLong("teamcity.filesWatcher.logSlowChangesDetection.thresholdMs", 3L * Dates.ONE_MINUTE)) {
                LOG_DIAG.info("Finished detecting changed files in " + durationStr + ", number of processed files: " + watchedFiles.length);
            } else if (LOG.isDebugEnabled() && (changesDetected || TeamCityProperties.getBoolean("teamcity.filesWatcher.enableBackgroundLogging"))) {
                LOG.debug("Finished detecting changed files in " + durationStr + " for " + this.describe(true));
            }
        }
        return null;
    }

    @NotNull
    private File[] getWatchedFilesInPatchedThread() throws IOException {
        File[] fileArray;
        Disposable patchedThreadName;
        block3: {
            patchedThreadName = NamedThreadFactory.patchThreadName("Processing watcher " + this.describe(false));
            fileArray = this.myFilesProvider.getWatchedFiles();
            if (fileArray != null) break block3;
            FilesWatcher.$$$reportNull$$$0(10);
        }
        return fileArray;
        finally {
            patchedThreadName.dispose();
        }
    }

    public static void shutdownAll() {
        ScheduledExecutorService scheduler = ourSchedulerRef.getAndSet(null);
        if (scheduler != null) {
            ThreadUtil.shutdownNowAndWait(scheduler, "Files Watcher executor");
        }
    }

    public boolean isStarted() {
        return this.myWatcherState.get() != WatcherState.STOPPED;
    }

    @Used(value="tests")
    public void waitForReadyState() {
        new WaitFor(){

            @Override
            protected boolean condition() {
                return ((FilesState)FilesWatcher.this.myFilesState.get()).isInitialized();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/configuration/FilesWatcher";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/configuration/FilesWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchedFilesInPatchedThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runActionWithDisabledObserver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum WatcherState {
        ACTIVE,
        PAUSED,
        STOPPED;

    }

    private class ReschedulableChangesDetector
    implements Runnable {
        private final boolean repeatable;

        ReschedulableChangesDetector(boolean repeatable) {
            this.repeatable = repeatable;
        }

        @Override
        public void run() {
            try {
                if (FilesWatcher.this.myWatcherState.get() == WatcherState.ACTIVE) {
                    FilesState fs = (FilesState)FilesWatcher.this.myFilesState.get();
                    if (fs.isInitialized()) {
                        FilesState filesState = FilesWatcher.this.detectChanges();
                        if (FilesWatcher.this.myWatcherState.get() == WatcherState.ACTIVE) {
                            FilesWatcher.this.notifyListeners(filesState);
                        }
                    } else {
                        FilesState cur = (FilesState)FilesWatcher.this.myFilesState.get();
                        FilesState newState = new FilesState();
                        newState.resetState(FilesWatcher.this.myFilesProvider.getWatchedFiles());
                        FilesWatcher.this.myFilesState.compareAndSet(cur, newState);
                    }
                }
                if (this.repeatable) {
                    boolean watcherStopped;
                    boolean bl = watcherStopped = FilesWatcher.this.myWatcherState.get() == WatcherState.STOPPED;
                    if (watcherStopped) {
                        LOG.debug("Skip re-scheduling changes detection task, because files watcher is stopped, " + FilesWatcher.this.describe(false));
                        return;
                    }
                    boolean threadInterrupted = Thread.currentThread().isInterrupted();
                    if (threadInterrupted) {
                        LOG.debug("Skip re-scheduling changes detection task, because files watcher executor thread is interrupted, " + FilesWatcher.this.describe(false));
                        return;
                    }
                    long repeatDelay = TeamCityProperties.getLong("teamcity.filesWatcher.repeatIntervalMs.override", -2L);
                    long actualDelay = repeatDelay != -2L ? repeatDelay : FilesWatcher.this.mySleepingPeriod;
                    FilesWatcher.this.scheduleMe(actualDelay, true);
                }
            }
            catch (IOException e) {
                LOG.warnAndDebugDetails("Exception in FilesWatcher: " + FilesWatcher.this.describe(false), (Throwable)e);
            }
            catch (Throwable t) {
                LOG.warnAndDebugDetails("FilesWatcher task failed: " + FilesWatcher.this.describe(false), t);
            }
        }
    }

    public static interface WatchedFilesProvider {
        @NotNull
        public File[] getWatchedFiles() throws IOException;
    }
}

