/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public class WatchedFileState {
    private final boolean myExists;
    private final boolean myIsDirectory;
    private final long myLastModified;
    private final long mySize;

    public WatchedFileState(@NotNull File file) {
        if (file == null) {
            WatchedFileState.$$$reportNull$$$0(0);
        }
        this.myLastModified = file.lastModified();
        boolean bl = this.myExists = this.myLastModified != 0L;
        if (this.myExists) {
            this.mySize = this.getFileSize(file);
            this.myIsDirectory = file.isDirectory();
        } else {
            this.myIsDirectory = false;
            this.mySize = 0L;
        }
    }

    public WatchedFileState(boolean exists, boolean isDirectory, long lastModified, long size) {
        this.myExists = exists;
        this.myIsDirectory = isDirectory;
        this.myLastModified = lastModified;
        this.mySize = size;
    }

    private long getFileSize(@NotNull File file) {
        if (file == null) {
            WatchedFileState.$$$reportNull$$$0(1);
        }
        return file.length();
    }

    boolean isCreated(@NotNull File file) {
        if (file == null) {
            WatchedFileState.$$$reportNull$$$0(2);
        }
        return !this.myExists && file.exists();
    }

    boolean isRemoved(@NotNull File file) {
        if (file == null) {
            WatchedFileState.$$$reportNull$$$0(3);
        }
        return this.myExists && !file.exists();
    }

    boolean isChanged(@NotNull File file) {
        boolean fileExists;
        if (file == null) {
            WatchedFileState.$$$reportNull$$$0(4);
        }
        if ((fileExists = file.exists()) != this.myExists) {
            return true;
        }
        if (!fileExists) {
            return false;
        }
        return this.myIsDirectory != file.isDirectory() || this.myLastModified != file.lastModified() || this.mySize != this.getFileSize(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "jetbrains/buildServer/configuration/WatchedFileState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCreated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

