/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.buildServer.dataStructures.CompositeIterator;

public class CompositeCollection<T>
implements Collection<T> {
    private final Collection<? extends Collection<T>> myCollections;

    public CompositeCollection(Collection<? extends Collection<T>> collections) {
        this.myCollections = collections;
    }

    @Override
    public int size() {
        int sz = 0;
        for (Collection<T> collection : this.myCollections) {
            sz += collection.size();
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> collection : this.myCollections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> collection : this.myCollections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList its = new ArrayList(this.myCollections.size());
        for (Collection<T> c : this.myCollections) {
            its.add(c.iterator());
        }
        return new CompositeIterator(its);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Collection<T> collection : this.myCollections) {
            for (T t : collection) {
                result[i++] = t;
            }
        }
        return result;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        E[] result = a;
        for (Collection<T> col : this.myCollections) {
            for (T t : col) {
                result[i++] = t;
            }
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("collection is readonly");
    }
}

