/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.dataStructures.BiMapper;
import jetbrains.buildServer.dataStructures.DecoratingCollection;
import jetbrains.buildServer.dataStructures.DecoratingCollectionBase;
import jetbrains.buildServer.dataStructures.DecoratingSet;
import jetbrains.buildServer.dataStructures.DecoratingSetBase;
import jetbrains.buildServer.dataStructures.Mapper;
import jetbrains.buildServer.dataStructures.NotNullMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratingMap<TK, TV, QK, QV>
implements Map<TK, TV> {
    private final Class<TK> myExternalKeyClass;
    private final Class<TV> myExternalValueClass;
    private final Map<QK, QV> myMap;
    private final BiMapper<QK, TK> myKeysMapper;
    private final BiMapper<QV, TV> myValuesMapper;

    public DecoratingMap(@NotNull Class<TK> externalKeyClass, @NotNull Class<TV> externalValueClass, @NotNull Map<QK, QV> map, @NotNull BiMapper<QK, TK> keysMapper, @NotNull BiMapper<QV, TV> valuesMapper) {
        if (externalKeyClass == null) {
            DecoratingMap.$$$reportNull$$$0(0);
        }
        if (externalValueClass == null) {
            DecoratingMap.$$$reportNull$$$0(1);
        }
        if (map == null) {
            DecoratingMap.$$$reportNull$$$0(2);
        }
        if (keysMapper == null) {
            DecoratingMap.$$$reportNull$$$0(3);
        }
        if (valuesMapper == null) {
            DecoratingMap.$$$reportNull$$$0(4);
        }
        this.myExternalKeyClass = externalKeyClass;
        this.myExternalValueClass = externalValueClass;
        this.myMap = map;
        this.myKeysMapper = keysMapper;
        this.myValuesMapper = valuesMapper;
    }

    @Override
    public int size() {
        if (this.myKeysMapper instanceof NotNullMapper && this.myValuesMapper instanceof NotNullMapper) {
            return this.myMap.size();
        }
        int sz = 0;
        for (Map.Entry<QK, QV> entry : this.myMap.entrySet()) {
            if (this.myKeysMapper.mapKey(entry.getKey()) == null || this.myValuesMapper.mapKey(entry.getValue()) == null) continue;
            ++sz;
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Map.Entry<QK, QV> entry : this.myMap.entrySet()) {
            if (this.myKeysMapper.mapKey(entry.getKey()) == null || this.myValuesMapper.mapKey(entry.getValue()) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.myExternalKeyClass.cast(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<TK, TV> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TV get(Object key) {
        QK internalKey = this.myKeysMapper.demapKey(this.myExternalKeyClass.cast(key));
        if (internalKey == null || this.myKeysMapper.mapKey(internalKey) == null) {
            return null;
        }
        QV qv = this.myMap.get(internalKey);
        if (qv == null) {
            return null;
        }
        return (TV)this.myValuesMapper.mapKey(qv);
    }

    @Override
    public TV put(TK key, TV value) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public TV remove(Object key) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void putAll(Map<? extends TK, ? extends TV> m) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public Set<TK> keySet() {
        if (this.myValuesMapper instanceof NotNullMapper) {
            return new DecoratingSet<TK, QK>(this.myExternalKeyClass, this.myMap.keySet(), this.myKeysMapper);
        }
        return new DecoratingSetBase<TK, Map.Entry<TK, TV>>(this.entrySet(), new Mapper<Map.Entry<TK, TV>, TK>(){

            @Override
            public TK mapKey(@NotNull Map.Entry<TK, TV> internal) {
                if (internal == null) {
                    1.$$$reportNull$$$0(0);
                }
                return internal.getKey();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internal", "jetbrains/buildServer/dataStructures/DecoratingMap$1", "mapKey"));
            }
        }){

            @Override
            public boolean contains(Object o) {
                return DecoratingMap.this.containsKey(o);
            }
        };
    }

    @Override
    public Collection<TV> values() {
        if (this.myKeysMapper instanceof NotNullMapper) {
            return new DecoratingCollection<TV, QV>(this.myExternalValueClass, this.myMap.values(), this.myValuesMapper);
        }
        return new DecoratingCollectionBase<TV, Map.Entry<TK, TV>>(this.entrySet(), new Mapper<Map.Entry<TK, TV>, TV>(){

            @Override
            public TV mapKey(@NotNull Map.Entry<TK, TV> internal) {
                if (internal == null) {
                    3.$$$reportNull$$$0(0);
                }
                return internal.getValue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internal", "jetbrains/buildServer/dataStructures/DecoratingMap$3", "mapKey"));
            }
        }){

            @Override
            public boolean contains(Object o) {
                return DecoratingMap.this.containsValue(o);
            }
        };
    }

    private Class<Map.Entry<TK, TV>> makeEntry() {
        Class<Map.Entry> clazz = Map.Entry.class;
        return clazz;
    }

    @Override
    public Set<Map.Entry<TK, TV>> entrySet() {
        return new DecoratingSet<Map.Entry<TK, TV>, Map.Entry<QK, QV>>(this.makeEntry(), this.myMap.entrySet(), new BiMapper<Map.Entry<QK, QV>, Map.Entry<TK, TV>>(){

            @Override
            @Nullable
            public Map.Entry<TK, TV> mapKey(@NotNull Map.Entry<QK, QV> internal) {
                Object tk;
                if (internal == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((tk = DecoratingMap.this.myKeysMapper.mapKey(internal.getKey())) == null) {
                    return null;
                }
                Object tv = DecoratingMap.this.myValuesMapper.mapKey(internal.getValue());
                if (tv == null) {
                    return null;
                }
                return new EntryImpl(tk, tv);
            }

            @Override
            @Nullable
            public Map.Entry<QK, QV> demapKey(@NotNull Map.Entry<TK, TV> external) {
                Object qk;
                if (external == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((qk = DecoratingMap.this.myKeysMapper.demapKey(external.getKey())) == null) {
                    return null;
                }
                Object qv = DecoratingMap.this.myValuesMapper.demapKey(external.getValue());
                if (qv == null) {
                    return null;
                }
                return new EntryImpl(qk, qv);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "internal";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "external";
                        break;
                    }
                }
                objectArray2[1] = "jetbrains/buildServer/dataStructures/DecoratingMap$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mapKey";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "demapKey";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "externalKeyClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "externalValueClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "keysMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "valuesMapper";
                break;
            }
        }
        objectArray[1] = "jetbrains/buildServer/dataStructures/DecoratingMap";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EntryImpl<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        private EntryImpl(@NotNull K key, @NotNull V value) {
            if (key == null) {
                EntryImpl.$$$reportNull$$$0(0);
            }
            if (value == null) {
                EntryImpl.$$$reportNull$$$0(1);
            }
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("map is readonly");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/dataStructures/DecoratingMap$EntryImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

