/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiMapDecorator<TK, TV, TC extends Collection<TV>> {
    protected final Map<TK, TC> myMap;

    public MultiMapDecorator(@NotNull Map<TK, TC> map) {
        if (map == null) {
            MultiMapDecorator.$$$reportNull$$$0(0);
        }
        this.myMap = map;
    }

    public void add(TK key, TV value) {
        this.getValuesInternal(key).add(value);
    }

    public void addEmpty(TK key) {
        this.getValuesInternal(key);
    }

    @NotNull
    public Collection<TV> getValues(TK key) {
        Collection collection = Collections.unmodifiableCollection(this.getValuesInternal(key));
        if (collection == null) {
            MultiMapDecorator.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public boolean containsKey(TK key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public Set<TK> keySet() {
        Set<TK> set = this.myMap.keySet();
        if (set == null) {
            MultiMapDecorator.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<TC> values() {
        Collection<TC> collection = this.myMap.values();
        if (collection == null) {
            MultiMapDecorator.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Set<Map.Entry<TK, TC>> entrySet() {
        Set<Map.Entry<TK, TC>> set = this.myMap.entrySet();
        if (set == null) {
            MultiMapDecorator.$$$reportNull$$$0(4);
        }
        return set;
    }

    public int size() {
        return this.myMap.size();
    }

    public int valuesSize() {
        int cnt = 0;
        for (Collection futures : this.values()) {
            cnt += futures.size();
        }
        return cnt;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Nullable
    public TC removeKey(TK key) {
        return (TC)((Collection)this.myMap.remove(key));
    }

    public void removeValue(TV v) {
        for (Collection tc : this.myMap.values()) {
            tc.remove(v);
        }
    }

    public void remove(TK key, TV v) {
        Collection col = (Collection)this.myMap.get(key);
        if (col != null) {
            col.remove(v);
        }
    }

    @NotNull
    private TC getValuesInternal(TK key) {
        Collection<Object> list = (Collection)this.myMap.get(key);
        if (list == null) {
            list = this.createEmptyCollection();
            this.myMap.put(key, list);
        }
        Collection collection = list;
        if (collection == null) {
            MultiMapDecorator.$$$reportNull$$$0(5);
        }
        return (TC)collection;
    }

    public void addAll(TK key, @NotNull Collection<? extends TV> values) {
        if (values == null) {
            MultiMapDecorator.$$$reportNull$$$0(6);
        }
        TC list = this.getValuesInternal(key);
        list.addAll(values);
    }

    public void addAll(@NotNull MultiMapDecorator<TK, TV, TC> map) {
        if (map == null) {
            MultiMapDecorator.$$$reportNull$$$0(7);
        }
        for (Map.Entry<TK, TC> entry : map.myMap.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("{");
        for (TK k : this.myMap.keySet()) {
            res.append(k).append(" -> ").append(this.myMap.get(k)).append(", ");
        }
        if (res.length() > 2) {
            res.delete(res.length() - 2, res.length());
        }
        res.append("}");
        return res.toString();
    }

    @NotNull
    protected abstract TC createEmptyCollection();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/dataStructures/MultiMapDecorator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/dataStructures/MultiMapDecorator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

