/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.diagnostic;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagnosticDirsConfig {
    private final File myParentDir;
    private final String myDirPrefix;

    public DiagnosticDirsConfig(@NotNull File parentDir, @NotNull String dirPrefix) {
        if (parentDir == null) {
            DiagnosticDirsConfig.$$$reportNull$$$0(0);
        }
        if (dirPrefix == null) {
            DiagnosticDirsConfig.$$$reportNull$$$0(1);
        }
        this.myParentDir = parentDir;
        this.myDirPrefix = dirPrefix;
    }

    @NotNull
    public File getCurrentDiagnosticDir() throws IOException {
        File dir = new File(this.myParentDir, this.myDirPrefix + Dates.getSimpleFileDateFormatter().format(Dates.now()));
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            DiagnosticDirsConfig.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public List<File> getDiagnosticDirs(final boolean onlyStandard) {
        final SimpleDateFormat simpleDateFormat = Dates.getSimpleFileDateFormatter();
        File[] dirsArray = FileUtil.listFiles(this.myParentDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                if (!file.isDirectory()) {
                    return false;
                }
                if (!name.startsWith(DiagnosticDirsConfig.this.myDirPrefix)) {
                    return false;
                }
                try {
                    simpleDateFormat.parse(name.substring(DiagnosticDirsConfig.this.myDirPrefix.length()));
                }
                catch (ParseException e) {
                    return !onlyStandard;
                }
                return true;
            }
        });
        FileUtil.sortFiles(dirsArray);
        List<File> list = Arrays.asList(dirsArray);
        if (list == null) {
            DiagnosticDirsConfig.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<DirData> getDiagnosticDirsData(boolean onlyStandard) {
        List list = CollectionsUtil.filterAndConvertCollection(this.getDiagnosticDirs(onlyStandard), new ArrayList(), new Converter<DirData, File>(){

            @Override
            public DirData createFrom(@NotNull File source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new DirData(source);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/diagnostic/DiagnosticDirsConfig$2", "createFrom"));
            }
        }, CollectionsUtil.acceptAllFilter());
        if (list == null) {
            DiagnosticDirsConfig.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPrefix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/diagnostic/DiagnosticDirsConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/diagnostic/DiagnosticDirsConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDiagnosticDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnosticDirs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnosticDirsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DirData {
        @NotNull
        private final File myDir;
        @Nullable
        private Integer myFilesCount;
        @Nullable
        private Long myFilesSize;

        public DirData(@NotNull File dir) {
            if (dir == null) {
                DirData.$$$reportNull$$$0(0);
            }
            this.myFilesCount = null;
            this.myFilesSize = null;
            this.myDir = dir;
        }

        @NotNull
        public File getDir() {
            File file = this.myDir;
            if (file == null) {
                DirData.$$$reportNull$$$0(1);
            }
            return file;
        }

        public int getFilesCount() {
            if (this.myFilesCount == null) {
                String[] list = this.myDir.list();
                this.myFilesCount = list == null ? 0 : list.length;
            }
            return this.myFilesCount;
        }

        public long getFilesSize() {
            if (this.myFilesSize == null) {
                this.myFilesSize = 0L;
                File[] list = this.myDir.listFiles();
                if (list != null) {
                    for (File file : list) {
                        this.myFilesSize = this.myFilesSize + file.length();
                    }
                }
            }
            return this.myFilesSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/diagnostic/DiagnosticDirsConfig$DirData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/diagnostic/DiagnosticDirsConfig$DirData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

